/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.ajc;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.aspectj.ajdt.ajc.ConfigParser;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.bridge.CountingMessageHandler;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.org.eclipse.jdt.core.compiler.InvalidInputException;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.Main;
import org.aspectj.util.FileUtil;
import org.aspectj.util.LangUtil;
import org.aspectj.weaver.Dump;
import org.aspectj.weaver.WeaverMessages;

public class BuildArgParser
extends Main {
    private static final String BUNDLE_NAME = "org.aspectj.ajdt.ajc.messages";
    private static boolean LOADED_BUNDLE = false;
    private final StringBuffer errorSink;
    private IMessageHandler handler;

    public static String getUsage() {
        return Main._bind("misc.usage", new String[]{Main._bind("compiler.name", null)});
    }

    public static String getXOptionUsage() {
        return Main._bind("xoption.usage", new String[]{Main._bind("compiler.name", null)});
    }

    public BuildArgParser(PrintWriter writer, IMessageHandler handler) {
        super(writer, writer, false);
        this.errorSink = writer instanceof StringPrintWriter ? ((StringPrintWriter)writer).stringWriter.getBuffer() : null;
        this.handler = handler;
    }

    public BuildArgParser(IMessageHandler handler) {
        this(new StringPrintWriter(new StringWriter()), handler);
    }

    public AjBuildConfig genBuildConfig(String[] args) {
        AjBuildConfig config = new AjBuildConfig();
        this.populateBuildConfig(config, args, true, null);
        return config;
    }

    public AjBuildConfig populateBuildConfig(AjBuildConfig buildConfig, String[] args, boolean setClasspath, File configFile) {
        Dump.saveCommandLine((String[])args);
        buildConfig.setConfigFile(configFile);
        try {
            File outjar;
            this.filenames = new String[]{""};
            AjcConfigParser parser = new AjcConfigParser(buildConfig, this.handler);
            parser.parseCommandLine(args);
            boolean swi = buildConfig.getShowWeavingInformation();
            if (this.handler instanceof CountingMessageHandler) {
                IMessageHandler delegate = ((CountingMessageHandler)this.handler).delegate;
                if (swi) {
                    delegate.dontIgnore(IMessage.WEAVEINFO);
                } else {
                    delegate.ignore(IMessage.WEAVEINFO);
                }
            }
            boolean incrementalMode = buildConfig.isIncrementalMode() || buildConfig.isIncrementalFileMode();
            ArrayList xmlfileList = new ArrayList();
            xmlfileList.addAll(parser.getXmlFiles());
            ArrayList fileList = new ArrayList();
            List files = parser.getFiles();
            if (!LangUtil.isEmpty((Collection)files)) {
                if (incrementalMode) {
                    MessageUtil.error((IMessageHandler)this.handler, (String)"incremental mode only handles source files using -sourceroots");
                } else {
                    fileList.addAll(files);
                }
            }
            ArrayList<String> javaArgList = new ArrayList<String>();
            javaArgList.add("-warn:none");
            javaArgList.add("-classpath");
            javaArgList.add(System.getProperty("user.dir"));
            javaArgList.add("-bootclasspath");
            javaArgList.add(System.getProperty("user.dir"));
            javaArgList.addAll(parser.getUnparsedArgs());
            super.configure(javaArgList.toArray(new String[javaArgList.size()]));
            if (!this.proceed) {
                buildConfig.doNotProceed();
                return buildConfig;
            }
            if (buildConfig.getSourceRoots() != null) {
                Iterator i = buildConfig.getSourceRoots().iterator();
                while (i.hasNext()) {
                    fileList.addAll(this.collectSourceRootFiles((File)i.next()));
                }
            }
            buildConfig.setXmlFiles(xmlfileList);
            buildConfig.setFiles(fileList);
            if (this.destinationPath != null) {
                buildConfig.setOutputDir(new File(this.destinationPath));
            }
            if (setClasspath) {
                buildConfig.setClasspath(this.getClasspath(parser));
                buildConfig.setBootclasspath(this.getBootclasspath(parser));
            }
            if (incrementalMode && 0 == buildConfig.getSourceRoots().size()) {
                MessageUtil.error((IMessageHandler)this.handler, (String)"specify a source root when in incremental mode");
            }
            if ((outjar = buildConfig.getOutputJar()) != null) {
                String message;
                Iterator i = buildConfig.getInJars().iterator();
                while (i.hasNext()) {
                    File injar = (File)i.next();
                    if (!injar.equals(outjar)) continue;
                    message = WeaverMessages.format((String)"outjarInInputPath");
                    MessageUtil.error((IMessageHandler)this.handler, (String)message);
                }
                i = buildConfig.getInpath().iterator();
                while (i.hasNext()) {
                    File inPathElement = (File)i.next();
                    if (inPathElement.isDirectory() || !inPathElement.equals(outjar)) continue;
                    message = WeaverMessages.format((String)"outjarInInputPath");
                    MessageUtil.error((IMessageHandler)this.handler, (String)message);
                }
                i = buildConfig.getAspectpath().iterator();
                while (i.hasNext()) {
                    File pathElement = (File)i.next();
                    if (pathElement.isDirectory() || !pathElement.equals(outjar)) continue;
                    message = WeaverMessages.format((String)"outjarInInputPath");
                    MessageUtil.error((IMessageHandler)this.handler, (String)message);
                }
            }
            this.setDebugOptions();
            buildConfig.getOptions().set(this.options);
        }
        catch (InvalidInputException iie) {
            SourceLocation location = null;
            if (buildConfig.getConfigFile() != null) {
                location = new SourceLocation(buildConfig.getConfigFile(), 0);
            }
            Message m = new Message(iie.getMessage(), IMessage.ERROR, null, (ISourceLocation)location);
            this.handler.handleMessage((IMessage)m);
        }
        return buildConfig;
    }

    public void printVersion() {
        String version = this.bind("misc.version", new String[]{this.bind("compiler.name"), "1.6.7.a - Built: Tuesday Jan 5, 2010 at 16:51:53 GMT", this.bind("compiler.version"), this.bind("compiler.copyright")});
        System.out.println(version);
    }

    public void printUsage() {
        System.out.println(this.bind("misc.usage"));
        System.out.flush();
    }

    public String getOtherMessages(boolean flush) {
        if (null == this.errorSink) {
            return null;
        }
        String result = this.errorSink.toString().trim();
        if (0 == result.length()) {
            result = null;
        }
        if (flush) {
            this.errorSink.setLength(0);
        }
        return result;
    }

    private void setDebugOptions() {
        this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
    }

    private Collection collectSourceRootFiles(File dir) {
        return Arrays.asList(FileUtil.listFiles((File)dir, (FileFilter)FileUtil.aspectjSourceFileFilter));
    }

    public List getBootclasspath(AjcConfigParser parser) {
        ArrayList ret = new ArrayList();
        if (parser.bootclasspath == null) {
            this.addClasspath(System.getProperty("sun.boot.class.path", ""), ret);
        } else {
            this.addClasspath(parser.bootclasspath, ret);
        }
        return ret;
    }

    public List getClasspath(AjcConfigParser parser) {
        ArrayList ret = new ArrayList();
        String extdirs = parser.extdirs;
        if (extdirs == null) {
            extdirs = System.getProperty("java.ext.dirs", "");
        }
        this.addExtDirs(extdirs, ret);
        if (parser.classpath == null) {
            this.addClasspath(System.getProperty("java.class.path", ""), ret);
            ArrayList<String> fixedList = new ArrayList<String>();
            Iterator it = ret.iterator();
            while (it.hasNext()) {
                String entry = (String)it.next();
                if (entry.endsWith("aspectjtools.jar")) continue;
                fixedList.add(entry);
            }
            ret = fixedList;
        } else {
            this.addClasspath(parser.classpath, ret);
        }
        return ret;
    }

    private void addExtDirs(String extdirs, List classpathCollector) {
        StringTokenizer tokenizer = new StringTokenizer(extdirs, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            File dirFile = new File(tokenizer.nextToken());
            if (!dirFile.canRead() || !dirFile.isDirectory()) continue;
            File[] files = dirFile.listFiles(FileUtil.ZIP_FILTER);
            for (int i = 0; i < files.length; ++i) {
                classpathCollector.add(files[i].getAbsolutePath());
            }
        }
    }

    private void addClasspath(String classpath, List classpathCollector) {
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            classpathCollector.add(tokenizer.nextToken());
        }
    }

    static {
        Main.bundleName = BUNDLE_NAME;
        Main.ResourceBundleFactory.getBundle(Locale.getDefault());
        if (!LOADED_BUNDLE) {
            LOADED_BUNDLE = true;
        }
    }

    private class AjcConfigParser
    extends ConfigParser {
        private String bootclasspath = null;
        private String classpath = null;
        private String extdirs = null;
        private List unparsedArgs = new ArrayList();
        private AjBuildConfig buildConfig;
        private IMessageHandler handler;

        public AjcConfigParser(AjBuildConfig buildConfig, IMessageHandler handler) {
            this.buildConfig = buildConfig;
            this.handler = handler;
        }

        public List getUnparsedArgs() {
            return this.unparsedArgs;
        }

        public void parseOption(String arg, LinkedList args) {
            int nextArgIndex = args.indexOf(arg) + 1;
            this.buildConfig.setXlazyTjp(true);
            if (LangUtil.isEmpty((String)arg)) {
                this.showWarning("empty arg found");
            } else if (arg.equals("-inpath")) {
                if (args.size() > nextArgIndex) {
                    List inPath = this.buildConfig.getInpath();
                    StringTokenizer st = new StringTokenizer(((ConfigParser.Arg)args.get(nextArgIndex)).getValue(), File.pathSeparator);
                    while (st.hasMoreTokens()) {
                        String filename = st.nextToken();
                        File file = this.makeFile(filename);
                        if (FileUtil.isZipFile((File)file)) {
                            inPath.add(file);
                            continue;
                        }
                        if (file.isDirectory()) {
                            inPath.add(file);
                            continue;
                        }
                        this.showWarning("skipping missing, empty or corrupt inpath entry: " + filename);
                    }
                    this.buildConfig.setInPath(inPath);
                    args.remove(args.get(nextArgIndex));
                }
            } else if (arg.equals("-injars")) {
                if (args.size() > nextArgIndex) {
                    StringTokenizer st = new StringTokenizer(((ConfigParser.Arg)args.get(nextArgIndex)).getValue(), File.pathSeparator);
                    while (st.hasMoreTokens()) {
                        String filename = st.nextToken();
                        File jarFile = this.makeFile(filename);
                        if (FileUtil.isZipFile((File)jarFile)) {
                            this.buildConfig.getInJars().add(jarFile);
                            continue;
                        }
                        File dirFile = this.makeFile(filename);
                        if (dirFile.isDirectory()) {
                            this.buildConfig.getInJars().add(dirFile);
                            continue;
                        }
                        this.showWarning("skipping missing, empty or corrupt injar: " + filename);
                    }
                    args.remove(args.get(nextArgIndex));
                }
            } else if (arg.equals("-aspectpath")) {
                if (args.size() > nextArgIndex) {
                    StringTokenizer st = new StringTokenizer(((ConfigParser.Arg)args.get(nextArgIndex)).getValue(), File.pathSeparator);
                    while (st.hasMoreTokens()) {
                        String filename = st.nextToken();
                        File jarFile = this.makeFile(filename);
                        if (FileUtil.isZipFile((File)jarFile) || jarFile.isDirectory()) {
                            this.buildConfig.getAspectpath().add(jarFile);
                            continue;
                        }
                        this.showWarning("skipping missing, empty or corrupt aspectpath entry: " + filename);
                    }
                    args.remove(args.get(nextArgIndex));
                }
            } else if (arg.equals("-sourceroots")) {
                if (args.size() > nextArgIndex) {
                    ArrayList<File> sourceRoots = new ArrayList<File>();
                    StringTokenizer st = new StringTokenizer(((ConfigParser.Arg)args.get(nextArgIndex)).getValue(), File.pathSeparator);
                    while (st.hasMoreTokens()) {
                        File f = this.makeFile(st.nextToken());
                        if (f.isDirectory() && f.canRead()) {
                            sourceRoots.add(f);
                            continue;
                        }
                        this.showError("bad sourceroot: " + f);
                    }
                    if (0 < sourceRoots.size()) {
                        this.buildConfig.setSourceRoots(sourceRoots);
                    }
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-sourceroots requires list of directories");
                }
            } else if (arg.equals("-outjar")) {
                if (args.size() > nextArgIndex) {
                    File jarFile = this.makeFile(((ConfigParser.Arg)args.get(nextArgIndex)).getValue());
                    if (!jarFile.isDirectory()) {
                        try {
                            if (!jarFile.exists()) {
                                jarFile.createNewFile();
                            }
                            this.buildConfig.setOutputJar(jarFile);
                        }
                        catch (IOException ioe) {
                            this.showError("unable to create outjar file: " + jarFile);
                        }
                    } else {
                        this.showError("invalid -outjar file: " + jarFile);
                    }
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-outjar requires jar path argument");
                }
            } else if (arg.equals("-outxml")) {
                this.buildConfig.setOutxmlName("META-INF/aop-ajc.xml");
            } else if (arg.equals("-outxmlfile")) {
                if (args.size() > nextArgIndex) {
                    String name = ((ConfigParser.Arg)args.get(nextArgIndex)).getValue();
                    this.buildConfig.setOutxmlName(name);
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-outxmlfile requires file name argument");
                }
            } else if (arg.equals("-log")) {
                args.remove(args.get(nextArgIndex));
            } else if (arg.equals("-messageHolder")) {
                args.remove(args.get(nextArgIndex));
            } else if (arg.equals("-incremental")) {
                this.buildConfig.setIncrementalMode(true);
            } else if (arg.equals("-XincrementalFile")) {
                if (args.size() > nextArgIndex) {
                    File file = this.makeFile(((ConfigParser.Arg)args.get(nextArgIndex)).getValue());
                    this.buildConfig.setIncrementalFile(file);
                    if (!file.canRead()) {
                        this.showError("bad -XincrementalFile : " + file);
                    }
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-XincrementalFile requires file argument");
                }
            } else if (arg.equals("-crossrefs")) {
                this.buildConfig.setGenerateCrossRefsMode(true);
                this.buildConfig.setGenerateModelMode(true);
            } else if (arg.startsWith("-checkRuntimeVersion:")) {
                String lcArg = arg.toLowerCase();
                if (lcArg.endsWith(":false")) {
                    this.buildConfig.setCheckRuntimeVersion(false);
                } else if (lcArg.endsWith(":true")) {
                    this.buildConfig.setCheckRuntimeVersion(true);
                } else {
                    this.showError("bad value for -checkRuntimeVersion option, must be true or false");
                }
            } else if (arg.equals("-emacssym")) {
                this.buildConfig.setEmacsSymMode(true);
                this.buildConfig.setGenerateModelMode(true);
            } else if (arg.equals("-XjavadocsInModel")) {
                this.buildConfig.setGenerateModelMode(true);
                this.buildConfig.setGenerateJavadocsInModelMode(true);
            } else if (arg.equals("-Xdev:NoAtAspectJProcessing")) {
                this.buildConfig.setNoAtAspectJAnnotationProcessing(true);
            } else if (arg.equals("-XaddSerialVersionUID")) {
                this.buildConfig.setAddSerialVerUID(true);
            } else if (arg.equals("-xmlConfigured")) {
                this.buildConfig.setXmlConfigured(true);
            } else if (arg.equals("-Xdev:Pinpoint")) {
                this.buildConfig.setXdevPinpointMode(true);
            } else if (arg.startsWith("-Xjoinpoints:")) {
                this.buildConfig.setXJoinpoints(arg.substring(13));
            } else if (arg.equals("-noWeave") || arg.equals("-XnoWeave")) {
                this.showWarning("the noweave option is no longer required and is being ignored");
            } else if (arg.equals("-XterminateAfterCompilation")) {
                this.buildConfig.setTerminateAfterCompilation(true);
            } else if (arg.equals("-XserializableAspects")) {
                this.buildConfig.setXserializableAspects(true);
            } else if (arg.equals("-XlazyTjp")) {
                this.showWarning("-XlazyTjp should no longer be used, build tjps lazily is now the default");
            } else if (arg.startsWith("-Xreweavable")) {
                this.showWarning("-Xreweavable is on by default");
                if (arg.endsWith(":compress")) {
                    this.showWarning("-Xreweavable:compress is no longer available - reweavable is now default");
                }
            } else if (arg.startsWith("-Xset:")) {
                this.buildConfig.setXconfigurationInfo(arg.substring(6));
            } else if (arg.startsWith("-XnotReweavable")) {
                this.buildConfig.setXnotReweavable(true);
            } else if (arg.equals("-XnoInline")) {
                this.buildConfig.setXnoInline(true);
            } else if (arg.equals("-XhasMember")) {
                this.buildConfig.setXHasMemberSupport(true);
            } else if (arg.startsWith("-showWeaveInfo")) {
                this.buildConfig.setShowWeavingInformation(true);
            } else if (arg.equals("-Xlintfile")) {
                if (args.size() > nextArgIndex) {
                    File lintSpecFile = this.makeFile(((ConfigParser.Arg)args.get(nextArgIndex)).getValue());
                    if (lintSpecFile.canRead() && lintSpecFile.getName().endsWith(".properties")) {
                        this.buildConfig.setLintSpecFile(lintSpecFile);
                    } else {
                        this.showError("bad -Xlintfile file: " + lintSpecFile);
                        this.buildConfig.setLintSpecFile(null);
                    }
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-Xlintfile requires .properties file argument");
                }
            } else if (arg.equals("-Xlint")) {
                this.buildConfig.setLintMode("default");
            } else if (arg.startsWith("-Xlint:")) {
                if (7 < arg.length()) {
                    this.buildConfig.setLintMode(arg.substring(7));
                } else {
                    this.showError("invalid lint option " + arg);
                }
            } else if (arg.equals("-bootclasspath")) {
                if (args.size() > nextArgIndex) {
                    String bcpArg = ((ConfigParser.Arg)args.get(nextArgIndex)).getValue();
                    StringBuffer bcp = new StringBuffer();
                    StringTokenizer strTok = new StringTokenizer(bcpArg, File.pathSeparator);
                    while (strTok.hasMoreTokens()) {
                        bcp.append(this.makeFile(strTok.nextToken()));
                        if (!strTok.hasMoreTokens()) continue;
                        bcp.append(File.pathSeparator);
                    }
                    this.bootclasspath = bcp.toString();
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-bootclasspath requires classpath entries");
                }
            } else if (arg.equals("-classpath") || arg.equals("-cp")) {
                if (args.size() > nextArgIndex) {
                    String cpArg = ((ConfigParser.Arg)args.get(nextArgIndex)).getValue();
                    StringBuffer cp = new StringBuffer();
                    StringTokenizer strTok = new StringTokenizer(cpArg, File.pathSeparator);
                    while (strTok.hasMoreTokens()) {
                        cp.append(this.makeFile(strTok.nextToken()));
                        if (!strTok.hasMoreTokens()) continue;
                        cp.append(File.pathSeparator);
                    }
                    this.classpath = cp.toString();
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-classpath requires classpath entries");
                }
            } else if (arg.equals("-extdirs")) {
                if (args.size() > nextArgIndex) {
                    String extdirsArg = ((ConfigParser.Arg)args.get(nextArgIndex)).getValue();
                    StringBuffer ed = new StringBuffer();
                    StringTokenizer strTok = new StringTokenizer(extdirsArg, File.pathSeparator);
                    while (strTok.hasMoreTokens()) {
                        ed.append(this.makeFile(strTok.nextToken()));
                        if (!strTok.hasMoreTokens()) continue;
                        ed.append(File.pathSeparator);
                    }
                    this.extdirs = ed.toString();
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-extdirs requires list of external directories");
                }
            } else if (arg.equals("-d")) {
                this.dirLookahead(arg, args, nextArgIndex);
            } else if (arg.equals("-proceedOnError")) {
                this.buildConfig.setProceedOnError(true);
            } else if (new File(arg).isDirectory()) {
                this.showError("dir arg not permitted: " + arg);
            } else if (arg.startsWith("-Xajruntimetarget")) {
                if (arg.endsWith(":1.2")) {
                    this.buildConfig.setTargetAspectjRuntimeLevel("1.2");
                } else if (arg.endsWith(":1.5")) {
                    this.buildConfig.setTargetAspectjRuntimeLevel("1.5");
                } else {
                    this.showError("-Xajruntimetarget:<level> only supports a target level of 1.2 or 1.5");
                }
            } else if (arg.equals("-timers")) {
                this.buildConfig.setTiming(true);
            } else if (arg.equals("-1.5")) {
                this.buildConfig.setBehaveInJava5Way(true);
                this.unparsedArgs.add("-1.5");
            } else if (arg.equals("-1.6")) {
                this.buildConfig.setBehaveInJava5Way(true);
                this.unparsedArgs.add("-1.6");
            } else if (arg.equals("-source")) {
                if (args.size() > nextArgIndex) {
                    String level = ((ConfigParser.Arg)args.get(nextArgIndex)).getValue();
                    if (level.equals("1.5") || level.equals("5") || level.equals("1.6") || level.equals("6")) {
                        this.buildConfig.setBehaveInJava5Way(true);
                    }
                    this.unparsedArgs.add("-source");
                    this.unparsedArgs.add(level);
                    args.remove(args.get(nextArgIndex));
                }
            } else {
                this.unparsedArgs.add(arg);
            }
        }

        protected void dirLookahead(String arg, LinkedList argList, int nextArgIndex) {
            this.unparsedArgs.add(arg);
            ConfigParser.Arg next = (ConfigParser.Arg)argList.get(nextArgIndex);
            String value = next.getValue();
            if (!LangUtil.isEmpty((String)value) && new File(value).isDirectory()) {
                this.unparsedArgs.add(value);
                argList.remove(next);
                return;
            }
        }

        public void showError(String message) {
            SourceLocation location = null;
            if (this.buildConfig.getConfigFile() != null) {
                location = new SourceLocation(this.buildConfig.getConfigFile(), 0);
            }
            Message errorMessage = new Message(ConfigParser.CONFIG_MSG + message, IMessage.ERROR, null, (ISourceLocation)location);
            this.handler.handleMessage((IMessage)errorMessage);
        }

        protected void showWarning(String message) {
            SourceLocation location = null;
            if (this.buildConfig.getConfigFile() != null) {
                location = new SourceLocation(this.buildConfig.getConfigFile(), 0);
            }
            Message errorMessage = new Message(ConfigParser.CONFIG_MSG + message, IMessage.WARNING, null, (ISourceLocation)location);
            this.handler.handleMessage((IMessage)errorMessage);
        }

        protected File makeFile(File dir, String name) {
            name = name.replace('/', File.separatorChar);
            File ret = new File(name);
            if (dir == null || ret.isAbsolute()) {
                return ret;
            }
            try {
                dir = dir.getCanonicalFile();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return new File(dir, name);
        }
    }

    private static class StringPrintWriter
    extends PrintWriter {
        public final StringWriter stringWriter;

        StringPrintWriter(StringWriter sw) {
            super(sw);
            this.stringWriter = sw;
        }
    }
}

