/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.jdt.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.contribution.jdt.JDTWeavingPlugin;
import org.eclipse.contribution.jdt.preferences.ReindexingJob;
import org.eclipse.contribution.jdt.preferences.WeavingStateConfigurer;
import org.eclipse.contribution.jdt.preferences.WeavingStateConfigurerUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

public class JDTWeavingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private WeavingStateConfigurer configurer;

    public JDTWeavingPreferencePage() {
        super("JDT Weaving preferences");
        this.setDescription("Preferences for the JDT Weaving plugin.  Enable and disable the weaving service here.");
        this.configurer = new WeavingStateConfigurer();
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        final Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        area.setLayout((Layout)gridLayout);
        Label messageLabel = new Label(area, 0);
        messageLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        if (this.configurer.isWeaving()) {
            messageLabel.setText("JDT Weaving is currently ENABLED");
        } else {
            messageLabel.setText("JDT Weaving is currently DISABLED");
        }
        Button changeWeavingButton = new Button(area, 8);
        changeWeavingButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        if (this.configurer.isWeaving()) {
            changeWeavingButton.setText("Click to DISABLE (requires restart)");
        } else {
            changeWeavingButton.setText("Click to ENABLE (requires restart)");
        }
        changeWeavingButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JDTWeavingPreferencePage.this.changeWeavingState(area.getShell());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                JDTWeavingPreferencePage.this.changeWeavingState(area.getShell());
            }
        });
        Label reindexLabel = new Label(area, 0);
        reindexLabel.setText("Click here if you want to reindex your workspace so\nthat all Java-like compilation units can be located by the indexer\n (e.g., during Java searches)");
        Button reindexButton = new Button(area, 8);
        reindexButton.setText("Reindex now");
        reindexButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                new ReindexingJob().schedule();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                new ReindexingJob().schedule();
            }
        });
        Label warningLabel = new Label(area, 0);
        warningLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        warningLabel.setText("In order to access the more advanced features of AJDT\n(such as AspectJ-aware content assist and eager parsing), it is\nnecessary to enable the weaving service.  With the weaving service\nenabled, Eclipse may require more resources.  If you encounter any\nsluggishness or memory problems, it is recommended that you increase\nyour Xmx and PermGen sizes to at least 512 and 128 respectively, using\nsomething like the following vmargs when launching eclipse:");
        Text vmargsText = new Text(area, 12);
        vmargsText.setBackground(area.getBackground());
        vmargsText.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        vmargsText.setText("\t-vmargs -Xmx512M -XX:MaxPermSize=128M");
        Link moreInfoLink = new Link(area, 2048);
        moreInfoLink.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        moreInfoLink.setText("<a href=\"http://wiki.eclipse.org/JDT_weaving_features\">More information...</a>");
        moreInfoLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                JDTWeavingPreferencePage.openUrl(event.text);
            }
        });
        Label weaverVersion = new Label(area, 0);
        weaverVersion.setText(new WeavingStateConfigurer().getWeaverVersionInfo());
        return area;
    }

    public void init(IWorkbench workbench) {
    }

    private void changeWeavingState(Shell shell) {
        new WeavingStateConfigurerUI(shell, this.configurer).askFromPreferences();
    }

    public static void openUrl(String location) {
        try {
            URL url = null;
            if (location != null) {
                url = new URL(location);
            }
            if (WebBrowserPreference.getBrowserChoice() == 1) {
                try {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    support.getExternalBrowser().openURL(url);
                }
                catch (Exception e) {
                    JDTWeavingPlugin.logException("Could not open browser", e);
                }
            } else {
                IWebBrowser browser = null;
                int flags = 0;
                flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? (flags |= 0x26) : (flags |= 0x86);
                String id = "org.eclipse.contribution.weaving.jdt";
                browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, id, null, null);
                browser.openURL(url);
            }
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Browser initialization error", (String)"Browser could not be initiated");
        }
        catch (MalformedURLException malformedURLException) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Malformed URL", (String)location);
        }
    }
}

