/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.tests.framework.ui;

import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import junit.framework.TestResult;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.rse.internal.tests.framework.TestFrameworkPlugin;
import org.eclipse.rse.tests.framework.AbstractTestSuiteHolder;
import org.eclipse.rse.tests.framework.DelegatingTestSuiteHolder;
import org.eclipse.rse.tests.framework.ITestSuiteHolder;
import org.eclipse.rse.tests.framework.ITestSuiteHolderListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class TestSuiteHolderView
extends ViewPart
implements ITestSuiteHolderListener,
ISelectionChangedListener {
    private SelectionListener graphicListener = new ColumnListener(new GraphicSorter());
    private SelectionListener nameListener = new ColumnListener(new NameSorter());
    private SelectionListener statusListener = new ColumnListener(new StatusSorter());
    private SelectionListener stampListener = new ColumnListener(new StampSorter());
    private TableViewer holderViewer;
    private Text resultsText;
    private ArrayContentProvider contentProvider = new ArrayContentProvider();
    private MyLabelProvider labelProvider = new MyLabelProvider();
    private ITestSuiteHolder[] holders = DelegatingTestSuiteHolder.getHolders();
    private String[] columnIds = new String[]{"graphic", "name", "status", "stamp"};
    private int[] columnWidths = new int[]{20, 200, 150, 150};
    private String[] columnTitles = new String[]{"", "Test Suite", "Summary", "Time Run"};
    private SelectionListener[] columnListeners = new SelectionListener[]{this.graphicListener, this.nameListener, this.statusListener, this.stampListener};
    private boolean[] columnResizable;
    private boolean[] columnMoveable;
    private Image graphicFailed;
    private Image graphicPassed;
    private Image graphicUnknown;

    public TestSuiteHolderView() {
        boolean[] blArray = new boolean[4];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        this.columnResizable = blArray;
        boolean[] blArray2 = new boolean[4];
        blArray2[1] = true;
        blArray2[2] = true;
        blArray2[3] = true;
        this.columnMoveable = blArray2;
        this.graphicFailed = null;
        this.graphicPassed = null;
        this.graphicUnknown = null;
    }

    public void createPartControl(Composite parent) {
        this.graphicFailed = this.createImage("icons/RedX.gif");
        this.graphicPassed = this.createImage("icons/GreenCheck.gif");
        this.graphicUnknown = this.createImage("icons/YellowQuestion.gif");
        Table table = new Table(parent, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        int n = this.columnIds.length;
        int i = 0;
        while (i < n) {
            TableColumn column = new TableColumn(table, 0);
            column.setData("id", (Object)this.columnIds[i]);
            column.setText(this.columnTitles[i]);
            column.setWidth(this.columnWidths[i]);
            column.setResizable(this.columnResizable[i]);
            column.setMoveable(this.columnMoveable[i]);
            column.addSelectionListener(this.columnListeners[i]);
            ++i;
        }
        this.holderViewer = new TableViewer(table);
        MenuManager menuManager = new MenuManager();
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.holderViewer);
        Control control = this.holderViewer.getControl();
        control.setMenu(menuManager.createContextMenu(control));
        GroupMarker item = new GroupMarker("additions");
        menuManager.add((IContributionItem)item);
        Sash sash = new Sash(parent, 256);
        sash.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Sash s = (Sash)e.widget;
                FormData fd = (FormData)s.getLayoutData();
                fd.top = new FormAttachment(0, e.y);
                s.getParent().layout();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.resultsText = new Text(parent, 2824);
        parent.setLayout((Layout)new FormLayout());
        FormData fd = null;
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment((Control)sash, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.holderViewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(50, 0);
        fd.height = 3;
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        sash.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)sash, 0);
        fd.bottom = new FormAttachment(100, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.resultsText.setLayoutData((Object)fd);
        this.holderViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.holderViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.holderViewer.setInput((Object)this.holders);
        int i2 = 0;
        while (i2 < this.holders.length) {
            ITestSuiteHolder holder = this.holders[i2];
            holder.addListener(this);
            ++i2;
        }
        this.holderViewer.setSelection((ISelection)new StructuredSelection());
        this.holderViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection sel = (StructuredSelection)event.getSelection();
        if (sel.size() == 1) {
            AbstractTestSuiteHolder holder = (AbstractTestSuiteHolder)sel.getFirstElement();
            this.resultsText.setText(holder.getResultString());
        } else {
            this.resultsText.setText("");
        }
    }

    public void setFocus() {
    }

    public void testEnded(ITestSuiteHolder holder) {
        this.updateHolderInView(holder);
        this.updateResultString(holder);
    }

    public void testHolderReset(ITestSuiteHolder holder) {
        this.updateHolderInView(holder);
        this.updateResultString(holder);
    }

    private String getColumnId(int columnIndex) {
        String columnId = null;
        if (this.holderViewer != null) {
            TableColumn column;
            Table table = this.holderViewer.getTable();
            int n = table.getColumnCount();
            if (columnIndex >= 0 && columnIndex < n && (column = table.getColumn(columnIndex)) != null) {
                columnId = (String)column.getData("id");
            }
        }
        return columnId;
    }

    private void updateHolderInView(final ITestSuiteHolder holder) {
        Runnable runnable = new Runnable(){

            public void run() {
                TestSuiteHolderView.this.holderViewer.update((Object)holder, null);
            }
        };
        Control control = this.holderViewer.getControl();
        if (!control.isDisposed()) {
            control.getDisplay().syncExec(runnable);
        }
    }

    private void updateResultString(ITestSuiteHolder holder) {
        Runnable runnable = new Runnable(){

            public void run() {
                StructuredSelection sel = (StructuredSelection)TestSuiteHolderView.this.holderViewer.getSelection();
                if (sel.size() == 1) {
                    AbstractTestSuiteHolder holder = (AbstractTestSuiteHolder)sel.getFirstElement();
                    TestSuiteHolderView.this.resultsText.setText(holder.getResultString());
                } else {
                    TestSuiteHolderView.this.resultsText.setText("");
                }
            }
        };
        if (!this.resultsText.isDisposed()) {
            this.resultsText.getDisplay().syncExec(runnable);
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.holders.length) {
            ITestSuiteHolder holder = this.holders[i];
            holder.removeListener(this);
            ++i;
        }
        this.graphicFailed.dispose();
        this.graphicPassed.dispose();
        this.graphicUnknown.dispose();
    }

    public Image createImage(String imageName) {
        TestFrameworkPlugin plugin = TestFrameworkPlugin.getDefault();
        Path path = new Path(imageName);
        Bundle bundle = plugin.getBundle();
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
        Image image = descriptor.createImage();
        return image;
    }

    public void selectAll() {
        if (!this.holderViewer.getControl().isDisposed()) {
            StructuredSelection selection = new StructuredSelection((Object[])this.holders);
            this.holderViewer.setSelection((ISelection)selection);
        }
    }

    private class ColumnListener
    implements SelectionListener {
        ColumnSorter sorter;

        public ColumnListener(ColumnSorter sorter) {
            this.sorter = sorter;
        }

        public void widgetSelected(SelectionEvent e) {
            if (TestSuiteHolderView.this.holderViewer.getSorter() == this.sorter) {
                this.sorter.reverse();
                TestSuiteHolderView.this.holderViewer.refresh();
            } else {
                TestSuiteHolderView.this.holderViewer.setSorter((ViewerSorter)this.sorter);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private abstract class ColumnSorter
    extends ViewerSorter {
        boolean ascending = false;

        private ColumnSorter() {
        }

        public void reverse() {
            this.ascending = !this.ascending;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String key1 = this.getKey(e1);
            String key2 = this.getKey(e2);
            int result = key1.compareTo(key2);
            if (!this.ascending) {
                result = -result;
            }
            return result;
        }

        public abstract String getKey(Object var1);
    }

    private class GraphicSorter
    extends ColumnSorter {
        private GraphicSorter() {
        }

        public String getKey(Object e) {
            AbstractTestSuiteHolder h = (AbstractTestSuiteHolder)e;
            TestResult r = h.getTestResult();
            if (r == null) {
                return "0" + r;
            }
            if (r.failureCount() > 0) {
                return "1" + r;
            }
            if (r.errorCount() > 0) {
                return "1" + r;
            }
            return "2" + r;
        }
    }

    private class MyLabelProvider
    implements ITableLabelProvider {
        private MyLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            AbstractTestSuiteHolder holder = (AbstractTestSuiteHolder)element;
            Image columnImage = null;
            String columnId = TestSuiteHolderView.this.getColumnId(columnIndex);
            if (columnId.equals("graphic")) {
                TestResult result = holder.getTestResult();
                columnImage = result != null ? (result.wasSuccessful() ? TestSuiteHolderView.this.graphicPassed : TestSuiteHolderView.this.graphicFailed) : TestSuiteHolderView.this.graphicUnknown;
            }
            return columnImage;
        }

        public String getColumnText(Object element, int columnIndex) {
            AbstractTestSuiteHolder holder = (AbstractTestSuiteHolder)element;
            String columnText = null;
            String columnId = TestSuiteHolderView.this.getColumnId(columnIndex);
            if (columnId.equals("name")) {
                columnText = holder.getName();
            } else if (columnId.equals("graphic")) {
                columnText = "";
            } else if (columnId.equals("status")) {
                TestResult result = holder.getTestResult();
                if (result != null) {
                    Object[] values = new Object[]{new Integer(result.runCount()), new Integer(result.failureCount()), new Integer(result.errorCount())};
                    String template = "{0,number,integer} run, {1,number,integer} failed, {2,number,integer} errors";
                    columnText = MessageFormat.format(template, values);
                } else {
                    columnText = "";
                }
            } else if (columnId.equals("stamp")) {
                Calendar stamp = holder.getLastRunTime();
                if (stamp != null) {
                    DateFormat formatter = DateFormat.getDateTimeInstance();
                    columnText = formatter.format(stamp.getTime());
                } else {
                    columnText = "";
                }
            }
            return columnText;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class NameSorter
    extends ColumnSorter {
        private NameSorter() {
        }

        public String getKey(Object e) {
            return ((AbstractTestSuiteHolder)e).getName();
        }
    }

    private class StampSorter
    extends ColumnSorter {
        private StampSorter() {
        }

        public String getKey(Object e) {
            AbstractTestSuiteHolder h = (AbstractTestSuiteHolder)e;
            Calendar c = h.getLastRunTime();
            long t = 0L;
            if (c != null) {
                t = c.getTimeInMillis();
            }
            String k = "0000000000000000000000000" + Long.toString(t);
            k = k.substring(k.length() - 25);
            k = String.valueOf(k) + h.getName();
            return k;
        }
    }

    private class StatusSorter
    extends ColumnSorter {
        private StatusSorter() {
        }

        public String getKey(Object e) {
            return "";
        }
    }
}

