/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.tests.framework.scripting;

import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.internal.tests.framework.scripting.ScriptContext;
import org.eclipse.rse.internal.tests.framework.ui.TestSuiteConsoleView;
import org.eclipse.rse.internal.tests.framework.ui.TestSuiteHolderView;
import org.eclipse.rse.internal.tests.framework.ui.TestSuiteImageView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;

public class PerspectiveContext
extends ScriptContext {
    private TestSuiteHolderView holderView;

    public PerspectiveContext(TestSuiteHolderView holderView, URL home) {
        super(home);
        this.holderView = holderView;
    }

    public void show(String imageName) {
        TestSuiteImageView view = this.findImageView();
        URL imageURL = this.getResourceURL(imageName);
        if (imageURL != null) {
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)imageURL);
            view.setImage(descriptor);
        }
    }

    public void tell(String text) {
        TestSuiteConsoleView view = this.findConsoleView();
        view.add(text);
    }

    public void pause(String text) {
        this.tell("pausing");
    }

    private TestSuiteImageView findImageView() {
        return (TestSuiteImageView)this.findView("org.eclipse.rse.tests.framework.ImageView");
    }

    private TestSuiteConsoleView findConsoleView() {
        return (TestSuiteConsoleView)this.findView("org.eclipse.rse.tests.framework.ConsoleView");
    }

    private IViewPart findView(String viewId) {
        IViewPart result = null;
        IViewSite site = this.holderView.getViewSite();
        IWorkbenchPage page = site.getPage();
        IViewReference[] references = page.getViewReferences();
        int i = 0;
        while (i < references.length) {
            IViewReference reference = references[i];
            String referenceId = reference.getId();
            if (referenceId.equals(viewId)) {
                result = reference.getView(true);
            }
            ++i;
        }
        return result;
    }
}

