/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.validators;

import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.validators.ISystemValidator;

public class ValidatorIntegerInput
implements ISystemValidator {
    protected boolean allowBlank = false;
    protected int number;
    protected SystemMessage emptyMsg;
    protected SystemMessage invalidMsg;
    protected SystemMessage currentMessage;

    public ValidatorIntegerInput() {
        this(RSEUIPlugin.getPluginMessage("RSEG1029"));
    }

    public ValidatorIntegerInput(SystemMessage emptyMsg) {
        this(emptyMsg, RSEUIPlugin.getPluginMessage("RSEG1017"));
    }

    public ValidatorIntegerInput(SystemMessage emptyMsg, SystemMessage invalidMsg) {
        this.setErrorMessages(emptyMsg, invalidMsg);
    }

    public void setBlankAllowed(boolean allowBlank) {
        this.allowBlank = allowBlank;
    }

    public void setErrorMessages(SystemMessage emptyMsg, SystemMessage invalidMsg) {
        this.emptyMsg = emptyMsg;
        this.invalidMsg = invalidMsg;
    }

    public String isValid(Object input) {
        this.currentMessage = null;
        if (!(input instanceof String)) {
            this.number = 1;
            return null;
        }
        return this.isValid((String)input);
    }

    public String isValid(String input) {
        this.currentMessage = null;
        if (input == null || input.length() == 0) {
            if (!this.allowBlank) {
                this.currentMessage = this.emptyMsg;
            }
        } else {
            try {
                this.number = Integer.parseInt(input);
            }
            catch (NumberFormatException numberFormatException) {
                this.currentMessage = this.invalidMsg;
                this.currentMessage.makeSubstitution((Object)input);
            }
        }
        return this.currentMessage == null ? null : this.currentMessage.getLevelOneText();
    }

    public SystemMessage getSystemMessage() {
        return this.currentMessage;
    }

    public int getMaximumNameLength() {
        return 11;
    }

    public SystemMessage validate(String text) {
        if (this.isValid(text) != null) {
            return this.currentMessage;
        }
        return null;
    }

    public int getNumber() {
        return this.number;
    }
}

