/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.universal.miners.filesystem;

import java.io.File;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.server.SecuredThread;
import org.eclipse.rse.dstore.universal.miners.ICancellableHandler;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;

public class QueryThread
extends SecuredThread
implements ICancellableHandler {
    protected DataElement _subject;
    protected DataElement _status;
    protected boolean _isCancelled = false;
    protected boolean _isDone = false;

    public QueryThread(DataElement subject, DataElement status) {
        super(subject.getDataStore());
        this._subject = subject;
        this._status = status;
    }

    public DataElement statusDone(DataElement status) {
        status.setAttribute(2, "done");
        this._dataStore.refresh(status);
        return status;
    }

    public void cancel() {
        this._isCancelled = true;
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public boolean isDone() {
        return this._isDone;
    }

    public String setProperties(File fileObj) {
        return this.setProperties(fileObj, false);
    }

    public String setProperties(File fileObj, boolean doArchiveProperties) {
        long expandedSize;
        String comment;
        String version = "version_1";
        StringBuffer buffer = new StringBuffer(500);
        long date = fileObj.lastModified();
        long size = fileObj.length();
        boolean hidden = fileObj.isHidden();
        boolean canWrite = fileObj.canWrite();
        boolean canRead = fileObj.canRead();
        boolean isArchive = false;
        if (isArchive) {
            try {
                comment = ArchiveHandlerManager.getInstance().getComment(fileObj);
            }
            catch (SystemMessageException systemMessageException) {
                comment = " ";
            }
        } else {
            comment = " ";
        }
        long compressedSize = size;
        String compressionMethod = " ";
        double compressionRatio = 0.0;
        if (isArchive) {
            try {
                expandedSize = ArchiveHandlerManager.getInstance().getExpandedSize(fileObj);
            }
            catch (SystemMessageException systemMessageException) {
                expandedSize = 0L;
            }
        } else {
            expandedSize = size;
        }
        try {
            buffer.append(version).append("|").append(date).append("|").append(size).append("|");
            buffer.append(hidden).append("|").append(canWrite).append("|").append(canRead);
            buffer.append("|");
            buffer.append(comment).append("|").append(compressedSize).append("|").append(compressionMethod).append("|");
            buffer.append(compressionRatio).append("|").append(expandedSize);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.exit(-1);
        }
        String buf = buffer.toString();
        return buf;
    }

    public String setProperties(VirtualChild fileObj) {
        String version = "version_1";
        StringBuffer buffer = new StringBuffer(500);
        long date = fileObj.getTimeStamp();
        long size = fileObj.getSize();
        boolean hidden = false;
        boolean canWrite = fileObj.getContainingArchive().canWrite();
        boolean canRead = fileObj.getContainingArchive().canRead();
        String comment = fileObj.getComment();
        if (comment.equals("")) {
            comment = " ";
        }
        long compressedSize = fileObj.getCompressedSize();
        String compressionMethod = fileObj.getCompressionMethod();
        if (compressionMethod.equals("")) {
            compressionMethod = " ";
        }
        double compressionRatio = fileObj.getCompressionRatio();
        long expandedSize = size;
        buffer.append(version).append("|").append(date).append("|").append(size).append("|");
        buffer.append(hidden).append("|").append(canWrite).append("|").append(canRead);
        buffer.append("|");
        buffer.append(comment).append("|").append(compressedSize).append("|").append(compressionMethod).append("|");
        buffer.append(compressionRatio).append("|").append(expandedSize);
        return buffer.toString();
    }
}

