/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.model.IPropertySetContainer;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.internal.core.filters.SystemFilter;
import org.eclipse.rse.internal.core.filters.SystemFilterContainerCommonMethods;
import org.eclipse.rse.internal.references.SystemPersistableReferencedObject;

public class SystemFilterPool
extends SystemPersistableReferencedObject
implements ISystemFilterPool,
IAdaptable {
    protected static final String NAME_EDEFAULT = null;
    private String name;
    protected static final String TYPE_EDEFAULT = null;
    private ISystemFilterPoolManager mgr;
    private SystemFilterContainerCommonMethods helpers = null;
    private Object filterPoolData = null;
    private boolean initialized = false;
    protected boolean specialCaseNoDataRestored = false;
    private boolean debug = false;
    protected static final String DELIMITER = "___";
    protected String type = TYPE_EDEFAULT;
    protected static final boolean SUPPORTS_NESTED_FILTERS_EDEFAULT = false;
    protected boolean supportsNestedFilters = false;
    protected static final boolean DELETABLE_EDEFAULT = false;
    protected boolean deletable = false;
    protected static final boolean DEFAULT_EDEFAULT = false;
    protected boolean default_ = false;
    protected static final boolean STRINGS_CASE_SENSITIVE_EDEFAULT = false;
    protected boolean stringsCaseSensitive = false;
    protected boolean stringsCaseSensitiveESet = false;
    protected static final boolean SUPPORTS_DUPLICATE_FILTER_STRINGS_EDEFAULT = false;
    protected boolean supportsDuplicateFilterStrings = false;
    protected static final int RELEASE_EDEFAULT = 0;
    protected int release = 0;
    protected static final boolean SINGLE_FILTER_STRING_ONLY_EDEFAULT = false;
    protected boolean singleFilterStringOnly = false;
    protected boolean singleFilterStringOnlyESet = false;
    protected static final String OWNING_PARENT_NAME_EDEFAULT = null;
    protected String owningParentName = OWNING_PARENT_NAME_EDEFAULT;
    protected static final boolean NON_RENAMABLE_EDEFAULT = false;
    protected boolean nonRenamable = false;
    protected List filters = new ArrayList(10);

    public SystemFilterPool(String poolName, boolean allowNestedFilters, boolean isDeletable) {
        this.helpers = new SystemFilterContainerCommonMethods();
        this.setRelease(200);
        if (!this.initialized) {
            this.initialize(poolName);
        }
        this.setDeletable(isDeletable);
        this.setSupportsNestedFilters(allowNestedFilters);
    }

    protected void initialize(String name) {
        this.setName(name);
        this.initialized = true;
    }

    protected List internalGetFilters() {
        return this.filters;
    }

    public ISystemFilterPoolManagerProvider getProvider() {
        ISystemFilterPoolManager mgr = this.getSystemFilterPoolManager();
        if (mgr != null) {
            return mgr.getProvider();
        }
        return null;
    }

    public void setSupportsNestedFilters(boolean supports) {
        this.setSupportsNestedFiltersGen(supports);
        ISystemFilter[] filters = this.getSystemFilters();
        if (filters != null) {
            int idx = 0;
            while (idx < filters.length) {
                filters[idx].setSupportsNestedFilters(supports);
                ++idx;
            }
        }
    }

    private void setSupportsNestedFiltersGen(boolean newSupportsNestedFilters) {
        this.supportsNestedFilters = newSupportsNestedFilters;
    }

    public void setSupportsDuplicateFilterStrings(boolean supports) {
        this.setSupportsDuplicateFilterStringsGen(supports);
        ISystemFilter[] filters = this.getSystemFilters();
        if (filters != null) {
            int idx = 0;
            while (idx < filters.length) {
                filters[idx].setSupportsDuplicateFilterStrings(supports);
                ++idx;
            }
        }
    }

    private void setSupportsDuplicateFilterStringsGen(boolean newSupportsDuplicateFilterStrings) {
        this.supportsDuplicateFilterStrings = newSupportsDuplicateFilterStrings;
        this.setDirty(true);
    }

    public void setStringsCaseSensitive(boolean supports) {
        this.setStringsCaseSensitiveGen(supports);
        ISystemFilter[] filters = this.getSystemFilters();
        if (filters != null) {
            int idx = 0;
            while (idx < filters.length) {
                filters[idx].setStringsCaseSensitive(supports);
                ++idx;
            }
        }
        this.setDirty(true);
    }

    private void setStringsCaseSensitiveGen(boolean newStringsCaseSensitive) {
        this.stringsCaseSensitive = newStringsCaseSensitive;
        this.stringsCaseSensitiveESet = true;
        this.setDirty(true);
    }

    public void setSystemFilterPoolManager(ISystemFilterPoolManager mgr) {
        this.mgr = mgr;
    }

    public ISystemFilterPoolManager getSystemFilterPoolManager() {
        return this.mgr;
    }

    public void setSystemFilterPoolData(Object data) {
        this.filterPoolData = data;
    }

    public Object getSystemFilterPoolData() {
        return this.filterPoolData;
    }

    public String getId() {
        return this.getProvider().getId();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return RSECoreMessages.RESID_MODELOBJECTS_FILTERPOOL_DESCRIPTION;
    }

    public void setName(String name) {
        if (name.indexOf(DELIMITER) >= 0) {
            throw new IllegalArgumentException("Cannot have ___ in filter pool name.");
        }
        if (this.name == null || !this.name.equals(name)) {
            this.name = name;
            this.setDirty(true);
        }
    }

    public String getType() {
        String type = this.getTypeGen();
        if (type == null) {
            return "default";
        }
        return type;
    }

    public String getTypeGen() {
        return this.type;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean newDeletable) {
        this.deletable = newDeletable;
        this.setDirty(true);
    }

    public boolean isDefault() {
        return this.default_;
    }

    public void setDefault(boolean newDefault) {
        this.default_ = newDefault;
    }

    public boolean supportsNestedFilters() {
        return this.isSupportsNestedFilters();
    }

    public boolean supportsDuplicateFilterStrings() {
        return this.isSupportsDuplicateFilterStrings();
    }

    public boolean isStringsCaseSensitive() {
        if (!this.isSetStringsCaseSensitive()) {
            return this.getSystemFilterPoolManager().isStringsCaseSensitive();
        }
        return this.stringsCaseSensitive;
    }

    public boolean areStringsCaseSensitive() {
        return this.isStringsCaseSensitive();
    }

    public void cloneSystemFilterPool(ISystemFilterPool targetPool) throws Exception {
        ISystemFilter[] filters;
        if (this.filterPoolData != null) {
            targetPool.setSystemFilterPoolData(this.filterPoolData);
        }
        targetPool.setType(this.getType());
        targetPool.setDeletable(this.isDeletable());
        targetPool.setSupportsNestedFilters(this.isSupportsNestedFilters());
        targetPool.setDefault(this.isDefault());
        targetPool.setSupportsDuplicateFilterStrings(this.supportsDuplicateFilterStrings());
        targetPool.setRelease(this.getRelease());
        targetPool.setNonRenamable(this.isNonRenamable());
        targetPool.setOwningParentName(this.getOwningParentName());
        if (this.isSetSingleFilterStringOnly()) {
            targetPool.setSingleFilterStringOnly(this.isSingleFilterStringOnly());
        }
        if (this.isSetStringsCaseSensitive()) {
            targetPool.setStringsCaseSensitive(this.isStringsCaseSensitive());
        }
        if ((filters = this.getSystemFilters()) != null && filters.length > 0) {
            int idx = 0;
            while (idx < filters.length) {
                this.copySystemFilter(targetPool, filters[idx], filters[idx].getName());
                ++idx;
            }
        }
    }

    public ISystemFilter copySystemFilter(ISystemFilterPool targetPool, ISystemFilter oldFilter, String newName) throws Exception {
        ISystemFilter newFilter = targetPool.createSystemFilter(newName, null);
        oldFilter.clone(newFilter);
        return newFilter;
    }

    public ISystemFilter[] getSystemFilters() {
        return this.helpers.getSystemFilters(this.internalGetFilters());
    }

    public ISystemFilterPool getSystemFilterPool() {
        return this;
    }

    public ISystemFilter createSystemFilter(String aliasName, String[] filterStrings) {
        ISystemFilter newFilter = this.helpers.createSystemFilter(this.internalGetFilters(), (ISystemFilterPool)this, aliasName, filterStrings);
        newFilter.setSupportsNestedFilters(this.supportsNestedFilters());
        newFilter.setStringsCaseSensitive(this.areStringsCaseSensitive());
        newFilter.setSupportsDuplicateFilterStrings(this.supportsDuplicateFilterStrings());
        this.setDirty(true);
        return newFilter;
    }

    public String[] getSystemFilterNames() {
        List filters = this.internalGetFilters();
        Vector names = this.helpers.getSystemFilterNames(filters);
        String[] result = new String[names.size()];
        names.toArray(result);
        return result;
    }

    public int getSystemFilterCount() {
        return this.helpers.getSystemFilterCount(this.internalGetFilters());
    }

    public ISystemFilter getSystemFilter(String aliasName) {
        return this.helpers.getSystemFilter(this.internalGetFilters(), aliasName);
    }

    public boolean addSystemFilter(ISystemFilter filter) {
        boolean result = this.helpers.addSystemFilter(this.internalGetFilters(), filter);
        if (result) {
            this.setDirty(true);
        }
        return result;
    }

    public void deleteSystemFilter(ISystemFilter filter) {
        this.helpers.deleteSystemFilter(this.internalGetFilters(), filter);
        this.setDirty(true);
    }

    public void renameSystemFilter(ISystemFilter filter, String newName) {
        this.helpers.renameSystemFilter(this.internalGetFilters(), filter, newName);
        this.setDirty(true);
    }

    public void updateSystemFilter(ISystemFilter filter, String newName, String[] newStrings) {
        this.helpers.updateSystemFilter(this.internalGetFilters(), filter, newName, newStrings);
        this.setDirty(true);
    }

    public ISystemFilter cloneSystemFilter(ISystemFilter filter, String aliasName) {
        ISystemFilter result = this.helpers.cloneSystemFilter(this.internalGetFilters(), filter, aliasName);
        this.setDirty(true);
        return result;
    }

    public int getSystemFilterPosition(ISystemFilter filter) {
        return this.helpers.getSystemFilterPosition(this.internalGetFilters(), filter);
    }

    public void moveSystemFilter(int pos, ISystemFilter filter) {
        this.helpers.moveSystemFilter(this.internalGetFilters(), pos, filter);
        this.setDirty(true);
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public void orderSystemFilters(String[] names) {
        ISystemFilter[] filterArray = new ISystemFilter[names.length];
        int idx = 0;
        while (idx < filterArray.length) {
            filterArray[idx] = this.getSystemFilter(names[idx]);
            ++idx;
        }
        this.filters.clear();
        idx = 0;
        while (idx < filterArray.length) {
            this.filters.add(filterArray[idx]);
            ++idx;
        }
        this.helpers.invalidateCache();
    }

    protected void initializeFilterStrings() {
        Iterator i = this.filters.iterator();
        while (i.hasNext()) {
            ((SystemFilter)i.next()).initializeFilterStrings();
        }
    }

    protected void sortFilters() {
        if (this.filters.size() <= 1) {
            return;
        }
        if (this.debug) {
            this.printFilterList("Before sorting");
        }
        this.helpers.invalidateCache();
        ISystemFilter[] filterArray = this.getSystemFilters();
        boolean[] processed = new boolean[filterArray.length];
        this.filters.clear();
        int processedCount = 0;
        int totalCount = filterArray.length;
        int nextHighest = -1;
        int firstMatchIdx = -1;
        int round = 0;
        boolean stop = false;
        int timeout = totalCount + 1;
        while (processedCount != totalCount && round < timeout) {
            nextHighest = 9999;
            firstMatchIdx = -1;
            stop = false;
            int idx = 0;
            while (!stop && idx < totalCount) {
                if (!processed[idx]) {
                    int currOrder = filterArray[idx].getRelativeOrder();
                    if (currOrder < nextHighest) {
                        nextHighest = currOrder;
                        firstMatchIdx = idx;
                    } else if (currOrder == nextHighest && firstMatchIdx == -1) {
                        firstMatchIdx = idx;
                    }
                }
                ++idx;
            }
            ++round;
            if (firstMatchIdx == -1) continue;
            this.filters.add(filterArray[firstMatchIdx]);
            processed[firstMatchIdx] = true;
            ++processedCount;
        }
        this.helpers.invalidateCache();
        if (this.debug) {
            this.printFilterList("After sorting");
        }
    }

    private void printFilterList(String tagLine) {
        ISystemFilter[] filters = this.getSystemFilters();
        if (filters.length == 0) {
            return;
        }
        System.out.println(String.valueOf(tagLine) + " for filter pool " + this.getName());
        int idx = 0;
        while (idx < filters.length) {
            System.out.println("  " + filters[idx].getName() + " " + filters[idx].getRelativeOrder());
            ++idx;
        }
        System.out.println();
    }

    public String getReferenceName() {
        return String.valueOf(this.getSystemFilterPoolManager().getName()) + DELIMITER + this.getName();
    }

    public String toString() {
        return this.getName();
    }

    public void setType(String newType) {
        this.type = newType;
        this.setDirty(true);
    }

    public boolean isSupportsNestedFilters() {
        return this.supportsNestedFilters;
    }

    public void unsetStringsCaseSensitive() {
        this.stringsCaseSensitive = false;
        this.stringsCaseSensitiveESet = false;
        this.setDirty(true);
    }

    public boolean isSetStringsCaseSensitive() {
        return this.stringsCaseSensitiveESet;
    }

    public ISystemFilter[] getFilters() {
        ISystemFilter[] result = new ISystemFilter[this.filters.size()];
        this.filters.toArray(result);
        return result;
    }

    public boolean isSupportsDuplicateFilterStrings() {
        return this.supportsDuplicateFilterStrings;
    }

    public int getRelease() {
        return this.release;
    }

    public void setRelease(int newRelease) {
        this.release = newRelease;
        this.setDirty(true);
    }

    public boolean isSingleFilterStringOnly() {
        if (this.isSetSingleFilterStringOnly()) {
            return this.singleFilterStringOnly;
        }
        return this.getSystemFilterPoolManager().isSingleFilterStringOnly();
    }

    public void setSingleFilterStringOnly(boolean newSingleFilterStringOnly) {
        this.singleFilterStringOnly = newSingleFilterStringOnly;
        this.singleFilterStringOnlyESet = true;
        this.setDirty(true);
    }

    public void unsetSingleFilterStringOnly() {
        this.singleFilterStringOnly = false;
        this.singleFilterStringOnlyESet = false;
        this.setDirty(true);
    }

    public boolean isSetSingleFilterStringOnly() {
        return this.singleFilterStringOnlyESet;
    }

    public String getOwningParentName() {
        return this.owningParentName;
    }

    public void setOwningParentName(String newOwningParentName) {
        if (newOwningParentName != this.owningParentName) {
            this.owningParentName = newOwningParentName;
            this.setDirty(true);
        }
    }

    public boolean isNonRenamable() {
        return this.nonRenamable;
    }

    public void setNonRenamable(boolean newNonRenamable) {
        boolean oldNonRenamable = this.nonRenamable;
        if (oldNonRenamable != newNonRenamable) {
            this.nonRenamable = newNonRenamable;
            this.setDirty(true);
        }
    }

    public boolean commit() {
        return this.getPersistableParent().commit();
    }

    public IRSEPersistableContainer getPersistableParent() {
        ISystemProfile profile = null;
        ISystemFilterPoolManager filterPoolManager = this.getSystemFilterPoolManager();
        if (filterPoolManager != null) {
            profile = filterPoolManager.getSystemProfile();
        }
        return profile;
    }

    public IRSEPersistableContainer[] getPersistableChildren() {
        ArrayList<IPropertySetContainer> children = new ArrayList<IPropertySetContainer>(10);
        children.addAll(Arrays.asList(this.getSystemFilters()));
        children.addAll(Arrays.asList(this.getPropertySets()));
        IRSEPersistableContainer[] result = new IRSEPersistableContainer[children.size()];
        children.toArray(result);
        return result;
    }
}

