/// <reference types="node" />
import cp = require('child_process');
import { DebugProtocol } from '@vscode/debugprotocol';
import { ProtocolClient } from './protocolClient';
export interface ILocation {
    path: string;
    line: number;
    column?: number;
    verified?: boolean;
}
export interface IPartialLocation {
    path?: string;
    line?: number;
    column?: number;
    verified?: boolean;
}
export declare class DebugClient extends ProtocolClient {
    private static CASE_INSENSITIVE_FILESYSTEM;
    private _runtime;
    private _executable;
    private _adapterProcess;
    private _spawnOptions;
    private _enableStderr;
    private _debugType;
    private _socket;
    private _supportsConfigurationDoneRequest;
    defaultTimeout: number;
    /**
     * Creates a DebugClient object that provides a promise-based API to write
     * debug adapter tests.
     * A simple mocha example for setting and hitting a breakpoint in line 15 of a program 'test.js' looks like this:
     *
     * var dc;
     * setup( () => {
     *     dc = new DebugClient('node', './out/node/nodeDebug.js', 'node');
     *     return dc.start();
     * });
     * teardown( () => dc.stop() );
     *
     * test('should stop on a breakpoint', () => {
     *     return dc.hitBreakpoint({ program: 'test.js' }, 'test.js', 15);
     * });
     */
    constructor(debugAdapterRuntime: string, debugAdapterExecutable: string, debugType: string, spawnOptions?: cp.SpawnOptions, enableStderr?: boolean);
    /**
     * Starts a new debug adapter and sets up communication via stdin/stdout.
     * If a port number is specified the adapter is not launched but a connection to
     * a debug adapter running in server mode is established. This is useful for debugging
     * the adapter while running tests. For this reason all timeouts are disabled in server mode.
     */
    start(port?: number): Promise<void>;
    /**
     * Shutdown the debuggee and the debug adapter (or disconnect if in server mode).
     */
    stop(): Promise<void>;
    private stopAdapter;
    initializeRequest(args?: DebugProtocol.InitializeRequestArguments): Promise<DebugProtocol.InitializeResponse>;
    configurationDoneRequest(args?: DebugProtocol.ConfigurationDoneArguments): Promise<DebugProtocol.ConfigurationDoneResponse>;
    launchRequest(args: DebugProtocol.LaunchRequestArguments): Promise<DebugProtocol.LaunchResponse>;
    attachRequest(args: DebugProtocol.AttachRequestArguments): Promise<DebugProtocol.AttachResponse>;
    restartRequest(args: DebugProtocol.RestartArguments): Promise<DebugProtocol.RestartResponse>;
    terminateRequest(args?: DebugProtocol.TerminateArguments): Promise<DebugProtocol.TerminateResponse>;
    disconnectRequest(args?: DebugProtocol.DisconnectArguments): Promise<DebugProtocol.DisconnectResponse>;
    setBreakpointsRequest(args: DebugProtocol.SetBreakpointsArguments): Promise<DebugProtocol.SetBreakpointsResponse>;
    setFunctionBreakpointsRequest(args: DebugProtocol.SetFunctionBreakpointsArguments): Promise<DebugProtocol.SetFunctionBreakpointsResponse>;
    setExceptionBreakpointsRequest(args: DebugProtocol.SetExceptionBreakpointsArguments): Promise<DebugProtocol.SetExceptionBreakpointsResponse>;
    dataBreakpointInfoRequest(args: DebugProtocol.DataBreakpointInfoArguments): Promise<DebugProtocol.DataBreakpointInfoResponse>;
    setDataBreakpointsRequest(args: DebugProtocol.SetDataBreakpointsArguments): Promise<DebugProtocol.SetDataBreakpointsResponse>;
    continueRequest(args: DebugProtocol.ContinueArguments): Promise<DebugProtocol.ContinueResponse>;
    nextRequest(args: DebugProtocol.NextArguments): Promise<DebugProtocol.NextResponse>;
    stepInRequest(args: DebugProtocol.StepInArguments): Promise<DebugProtocol.StepInResponse>;
    stepOutRequest(args: DebugProtocol.StepOutArguments): Promise<DebugProtocol.StepOutResponse>;
    stepBackRequest(args: DebugProtocol.StepBackArguments): Promise<DebugProtocol.StepBackResponse>;
    reverseContinueRequest(args: DebugProtocol.ReverseContinueArguments): Promise<DebugProtocol.ReverseContinueResponse>;
    restartFrameRequest(args: DebugProtocol.RestartFrameArguments): Promise<DebugProtocol.RestartFrameResponse>;
    gotoRequest(args: DebugProtocol.GotoArguments): Promise<DebugProtocol.GotoResponse>;
    pauseRequest(args: DebugProtocol.PauseArguments): Promise<DebugProtocol.PauseResponse>;
    stackTraceRequest(args: DebugProtocol.StackTraceArguments): Promise<DebugProtocol.StackTraceResponse>;
    scopesRequest(args: DebugProtocol.ScopesArguments): Promise<DebugProtocol.ScopesResponse>;
    variablesRequest(args: DebugProtocol.VariablesArguments): Promise<DebugProtocol.VariablesResponse>;
    setVariableRequest(args: DebugProtocol.SetVariableArguments): Promise<DebugProtocol.SetVariableResponse>;
    sourceRequest(args: DebugProtocol.SourceArguments): Promise<DebugProtocol.SourceResponse>;
    threadsRequest(): Promise<DebugProtocol.ThreadsResponse>;
    modulesRequest(args: DebugProtocol.ModulesArguments): Promise<DebugProtocol.ModulesResponse>;
    evaluateRequest(args: DebugProtocol.EvaluateArguments): Promise<DebugProtocol.EvaluateResponse>;
    disassembleRequest(args: DebugProtocol.DisassembleArguments): Promise<DebugProtocol.DisassembleResponse>;
    stepInTargetsRequest(args: DebugProtocol.StepInTargetsArguments): Promise<DebugProtocol.StepInTargetsResponse>;
    gotoTargetsRequest(args: DebugProtocol.GotoTargetsArguments): Promise<DebugProtocol.GotoTargetsResponse>;
    completionsRequest(args: DebugProtocol.CompletionsArguments): Promise<DebugProtocol.CompletionsResponse>;
    exceptionInfoRequest(args: DebugProtocol.ExceptionInfoArguments): Promise<DebugProtocol.ExceptionInfoResponse>;
    customRequest(command: string, args?: any): Promise<DebugProtocol.Response>;
    waitForEvent(eventType: string, timeout?: number): Promise<DebugProtocol.Event>;
    configurationSequence(): Promise<any>;
    /**
     * Returns a promise that will resolve if a 'initialize' and a 'launch' request were successful.
     */
    launch(launchArgs: any): Promise<DebugProtocol.LaunchResponse>;
    private configurationDone;
    assertStoppedLocation(reason: string, expected: {
        path?: string | RegExp;
        line?: number;
        column?: number;
    }): Promise<DebugProtocol.StackTraceResponse>;
    private assertPartialLocationsEqual;
    assertOutput(category: string, expected: string, timeout?: number): Promise<DebugProtocol.Event>;
    assertPath(path: string, expected: string | RegExp, message?: string): void;
    /**
     * Returns a promise that will resolve if a configurable breakpoint has been hit within some time
     * and the event's reason and line number was asserted.
     * The promise will be rejected if a timeout occurs, the assertions fail, or if the requests fails.
     */
    hitBreakpoint(launchArgs: any, location: ILocation, expectedStopLocation?: IPartialLocation, expectedBPLocation?: IPartialLocation): Promise<any>;
}
