"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_external-terminal_lib_electron-browser_external-terminal-frontend--e8b2bc"],{

/***/ "../../node_modules/@theia/external-terminal/lib/common/external-terminal.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/external-terminal/lib/common/external-terminal.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.externalTerminalServicePath = exports.ExternalTerminalService = void 0;
exports.ExternalTerminalService = Symbol('ExternalTerminalService');
exports.externalTerminalServicePath = '/services/external-terminal';


/***/ }),

/***/ "../../node_modules/@theia/external-terminal/lib/electron-browser/external-terminal-contribution.js":
/*!**********************************************************************************************************!*\
  !*** ../../node_modules/@theia/external-terminal/lib/electron-browser/external-terminal-contribution.js ***!
  \**********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExternalTerminalFrontendContribution = exports.ExternalTerminalCommands = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const env_variables_1 = __webpack_require__(/*! @theia/core/lib/common/env-variables */ "../../node_modules/@theia/core/lib/common/env-variables/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const editor_manager_1 = __webpack_require__(/*! @theia/editor/lib/browser/editor-manager */ "../../node_modules/@theia/editor/lib/browser/editor-manager.js");
const browser_2 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const external_terminal_1 = __webpack_require__(/*! ../common/external-terminal */ "../../node_modules/@theia/external-terminal/lib/common/external-terminal.js");
const external_terminal_preference_1 = __webpack_require__(/*! ./external-terminal-preference */ "../../node_modules/@theia/external-terminal/lib/electron-browser/external-terminal-preference.js");
const quick_pick_service_1 = __webpack_require__(/*! @theia/core/lib/common/quick-pick-service */ "../../node_modules/@theia/core/lib/common/quick-pick-service.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
var ExternalTerminalCommands;
(function (ExternalTerminalCommands) {
    ExternalTerminalCommands.OPEN_NATIVE_CONSOLE = common_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.terminal.openNativeConsole',
        label: 'Open New External Terminal'
    });
})(ExternalTerminalCommands || (exports.ExternalTerminalCommands = ExternalTerminalCommands = {}));
let ExternalTerminalFrontendContribution = class ExternalTerminalFrontendContribution {
    registerCommands(commands) {
        commands.registerCommand(ExternalTerminalCommands.OPEN_NATIVE_CONSOLE, {
            execute: () => this.openExternalTerminal()
        });
    }
    registerKeybindings(keybindings) {
        keybindings.registerKeybinding({
            command: ExternalTerminalCommands.OPEN_NATIVE_CONSOLE.id,
            keybinding: 'ctrlcmd+shift+c',
            when: '!terminalFocus'
        });
    }
    /**
     * Open a native console on the host machine.
     *
     * - If multi-root workspace is open, displays a quick pick to let users choose which workspace to spawn the terminal.
     * - If only one workspace is open, the terminal spawns at the root of the current workspace.
     * - If no workspace is open and there is an active editor, the terminal spawns at the parent folder of that file.
     * - If no workspace is open and there are no active editors, the terminal spawns at user home directory.
     */
    async openExternalTerminal() {
        var _a, _b;
        const configuration = this.externalTerminalPreferences.getExternalTerminalConfiguration();
        if (this.workspaceService.isMultiRootWorkspaceOpened) {
            const chosenWorkspaceRoot = await this.selectCwd();
            if (chosenWorkspaceRoot) {
                await this.externalTerminalService.openTerminal(configuration, chosenWorkspaceRoot);
            }
            return;
        }
        if (this.workspaceService.opened) {
            const workspaceRootUri = this.workspaceService.tryGetRoots()[0].resource;
            await this.externalTerminalService.openTerminal(configuration, workspaceRootUri.toString());
            return;
        }
        const fallbackUri = (_b = (_a = this.editorManager.activeEditor) === null || _a === void 0 ? void 0 : _a.editor.uri.parent) !== null && _b !== void 0 ? _b : await this.envVariablesServer.getHomeDirUri();
        await this.externalTerminalService.openTerminal(configuration, fallbackUri.toString());
    }
    /**
     * Display a quick pick for user to choose a target workspace in opened workspaces.
     */
    async selectCwd() {
        const roots = this.workspaceService.tryGetRoots();
        const selectedItem = await this.quickPickService.show(roots.map(({ resource }) => ({
            label: this.labelProvider.getName(resource),
            description: this.labelProvider.getLongName(resource),
            value: resource.toString()
        })), { placeholder: nls_1.nls.localize('theia/external-terminal/cwd', 'Select current working directory for new external terminal') });
        return selectedItem === null || selectedItem === void 0 ? void 0 : selectedItem.value;
    }
};
exports.ExternalTerminalFrontendContribution = ExternalTerminalFrontendContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(editor_manager_1.EditorManager),
    tslib_1.__metadata("design:type", editor_manager_1.EditorManager)
], ExternalTerminalFrontendContribution.prototype, "editorManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(env_variables_1.EnvVariablesServer),
    tslib_1.__metadata("design:type", Object)
], ExternalTerminalFrontendContribution.prototype, "envVariablesServer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], ExternalTerminalFrontendContribution.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(quick_pick_service_1.QuickPickService),
    tslib_1.__metadata("design:type", Object)
], ExternalTerminalFrontendContribution.prototype, "quickPickService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(external_terminal_1.ExternalTerminalService),
    tslib_1.__metadata("design:type", Object)
], ExternalTerminalFrontendContribution.prototype, "externalTerminalService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(external_terminal_preference_1.ExternalTerminalPreferenceService),
    tslib_1.__metadata("design:type", external_terminal_preference_1.ExternalTerminalPreferenceService)
], ExternalTerminalFrontendContribution.prototype, "externalTerminalPreferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.WorkspaceService),
    tslib_1.__metadata("design:type", browser_2.WorkspaceService)
], ExternalTerminalFrontendContribution.prototype, "workspaceService", void 0);
exports.ExternalTerminalFrontendContribution = ExternalTerminalFrontendContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ExternalTerminalFrontendContribution);


/***/ }),

/***/ "../../node_modules/@theia/external-terminal/lib/electron-browser/external-terminal-frontend-module.js":
/*!*************************************************************************************************************!*\
  !*** ../../node_modules/@theia/external-terminal/lib/electron-browser/external-terminal-frontend-module.js ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const external_terminal_preference_1 = __webpack_require__(/*! ./external-terminal-preference */ "../../node_modules/@theia/external-terminal/lib/electron-browser/external-terminal-preference.js");
const external_terminal_contribution_1 = __webpack_require__(/*! ./external-terminal-contribution */ "../../node_modules/@theia/external-terminal/lib/electron-browser/external-terminal-contribution.js");
const external_terminal_1 = __webpack_require__(/*! ../common/external-terminal */ "../../node_modules/@theia/external-terminal/lib/common/external-terminal.js");
exports["default"] = new inversify_1.ContainerModule((bind) => {
    bind(external_terminal_contribution_1.ExternalTerminalFrontendContribution).toSelf().inSingletonScope();
    (0, external_terminal_preference_1.bindExternalTerminalPreferences)(bind);
    [common_1.CommandContribution, browser_1.KeybindingContribution].forEach(serviceIdentifier => bind(serviceIdentifier).toService(external_terminal_contribution_1.ExternalTerminalFrontendContribution));
    bind(external_terminal_1.ExternalTerminalService).toDynamicValue(ctx => browser_1.WebSocketConnectionProvider.createProxy(ctx.container, external_terminal_1.externalTerminalServicePath)).inSingletonScope();
});


/***/ }),

/***/ "../../node_modules/@theia/external-terminal/lib/electron-browser/external-terminal-preference.js":
/*!********************************************************************************************************!*\
  !*** ../../node_modules/@theia/external-terminal/lib/electron-browser/external-terminal-preference.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getExternalTerminalSchema = exports.ExternalTerminalPreferenceService = exports.bindExternalTerminalPreferences = exports.ExternalTerminalSchemaProvider = exports.ExternalTerminalPreferences = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const injectable_preference_proxy_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences/injectable-preference-proxy */ "../../node_modules/@theia/core/lib/browser/preferences/injectable-preference-proxy.js");
const preference_contribution_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences/preference-contribution */ "../../node_modules/@theia/core/lib/browser/preferences/preference-contribution.js");
const os_1 = __webpack_require__(/*! @theia/core/lib/common/os */ "../../node_modules/@theia/core/lib/common/os.js");
const external_terminal_1 = __webpack_require__(/*! ../common/external-terminal */ "../../node_modules/@theia/external-terminal/lib/common/external-terminal.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
exports.ExternalTerminalPreferences = Symbol('ExternalTerminalPreferences');
exports.ExternalTerminalSchemaProvider = Symbol('ExternalTerminalSchemaPromise');
function bindExternalTerminalPreferences(bind) {
    bind(ExternalTerminalPreferenceService).toSelf().inSingletonScope();
    bind(exports.ExternalTerminalSchemaProvider)
        .toProvider(ctx => {
        const schema = getExternalTerminalSchema(ctx.container.get(external_terminal_1.ExternalTerminalService));
        return () => schema;
    });
    bind(exports.ExternalTerminalPreferences)
        .toDynamicValue(ctx => {
        const factory = ctx.container.get(injectable_preference_proxy_1.PreferenceProxyFactory);
        const schemaProvider = ctx.container.get(exports.ExternalTerminalSchemaProvider);
        return factory(schemaProvider());
    })
        .inSingletonScope();
}
exports.bindExternalTerminalPreferences = bindExternalTerminalPreferences;
let ExternalTerminalPreferenceService = class ExternalTerminalPreferenceService {
    init() {
        this.doInit();
    }
    async doInit() {
        this.preferenceSchemaProvider.setSchema(await this.promisedSchema());
    }
    /**
     * Get the external terminal configurations from preferences.
     */
    getExternalTerminalConfiguration() {
        return {
            'terminal.external.linuxExec': this.preferences['terminal.external.linuxExec'],
            'terminal.external.osxExec': this.preferences['terminal.external.osxExec'],
            'terminal.external.windowsExec': this.preferences['terminal.external.windowsExec'],
        };
    }
};
exports.ExternalTerminalPreferenceService = ExternalTerminalPreferenceService;
tslib_1.__decorate([
    (0, inversify_1.inject)(exports.ExternalTerminalPreferences),
    tslib_1.__metadata("design:type", Object)
], ExternalTerminalPreferenceService.prototype, "preferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_contribution_1.PreferenceSchemaProvider),
    tslib_1.__metadata("design:type", preference_contribution_1.PreferenceSchemaProvider)
], ExternalTerminalPreferenceService.prototype, "preferenceSchemaProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(exports.ExternalTerminalSchemaProvider),
    tslib_1.__metadata("design:type", Function)
], ExternalTerminalPreferenceService.prototype, "promisedSchema", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], ExternalTerminalPreferenceService.prototype, "init", null);
exports.ExternalTerminalPreferenceService = ExternalTerminalPreferenceService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ExternalTerminalPreferenceService);
/**
 * Use the backend {@link ExternalTerminalService} to establish the schema for the `ExternalTerminalPreferences`.
 *
 * @param externalTerminalService the external terminal backend service.
 * @returns a preference schema with the OS default exec set by the backend service.
 */
async function getExternalTerminalSchema(externalTerminalService) {
    const hostExec = await externalTerminalService.getDefaultExec();
    return {
        type: 'object',
        properties: {
            'terminal.external.windowsExec': {
                type: 'string',
                typeDetails: { isFilepath: true },
                description: nls_1.nls.localizeByDefault('Customizes which terminal to run on Windows.'),
                default: `${os_1.isWindows ? hostExec : 'C:\\WINDOWS\\System32\\cmd.exe'}`
            },
            'terminal.external.osxExec': {
                type: 'string',
                description: nls_1.nls.localizeByDefault('Customizes which terminal application to run on macOS.'),
                default: `${os_1.isOSX ? hostExec : 'Terminal.app'}`
            },
            'terminal.external.linuxExec': {
                type: 'string',
                description: nls_1.nls.localizeByDefault('Customizes which terminal to run on Linux.'),
                default: `${!(os_1.isWindows || os_1.isOSX) ? hostExec : 'xterm'}`
            }
        }
    };
}
exports.getExternalTerminalSchema = getExternalTerminalSchema;


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/index.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-commands */ "../../node_modules/@theia/workspace/lib/browser/workspace-commands.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./canonical-uri-service */ "../../node_modules/@theia/workspace/lib/browser/canonical-uri-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-frontend-contribution */ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-frontend-module */ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-module.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-preferences */ "../../node_modules/@theia/workspace/lib/browser/workspace-preferences.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-trust-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-trust-service.js"), exports);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_external-terminal_lib_electron-browser_external-terminal-frontend--e8b2bc.js.map