/*********************************************************************
 * Copyright (c) 2018 Ericsson and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
import { IGDBBackend } from '../types/gdb';
import { FrameReference } from '../types/session';
import { MIResponse, MIRegisterValueInfo } from './base';
interface MIDataReadMemoryBytesResponse {
    memory: Array<{
        begin: string;
        end: string;
        offset: string;
        contents: string;
    }>;
}
export interface MIDataDisassembleAsmInsn {
    address: string;
    'func-name': string;
    offset: string;
    opcodes: string;
    inst: string;
}
export interface MIDataDisassembleSrcAndAsmLine {
    line: string;
    file: string;
    fullname: string;
    line_asm_insn: MIDataDisassembleAsmInsn[];
}
export interface MIDataDisassembleResponse {
    asm_insns: MIDataDisassembleSrcAndAsmLine[];
}
export interface MIListRegisterNamesResponse extends MIResponse {
    'register-names': string[];
}
export interface MIListRegisterValuesResponse extends MIResponse {
    'register-values': MIRegisterValueInfo[];
}
export interface MIGDBDataEvaluateExpressionResponse extends MIResponse {
    value?: string;
}
export declare function sendDataReadMemoryBytes(gdb: IGDBBackend, address: string, size: number, offset?: number): Promise<MIDataReadMemoryBytesResponse>;
export declare function sendDataWriteMemoryBytes(gdb: IGDBBackend, memoryReference: string, data: string): Promise<void>;
export declare function sendDataEvaluateExpression(gdb: IGDBBackend, expr: string): Promise<MIGDBDataEvaluateExpressionResponse>;
export declare function sendDataDisassemble(gdb: IGDBBackend, startAddress: string, endAddress: string): Promise<MIDataDisassembleResponse>;
export declare function sendDataListRegisterNames(gdb: IGDBBackend, params: {
    regno?: number[];
    frameRef: FrameReference;
}): Promise<MIListRegisterNamesResponse>;
export declare function sendDataListRegisterValues(gdb: IGDBBackend, params: {
    fmt: string;
    regno?: number[];
    frameRef: FrameReference;
}): Promise<MIListRegisterValuesResponse>;
export {};
