"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_output_lib_browser_output-contribution_js"],{

/***/ "../../node_modules/@theia/output/lib/browser/output-commands.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@theia/output/lib/browser/output-commands.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2020 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OutputCommands = void 0;
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
var OutputCommands;
(function (OutputCommands) {
    const OUTPUT_CATEGORY = 'Output';
    const OUTPUT_CATEGORY_KEY = common_1.nls.getDefaultKey(OUTPUT_CATEGORY);
    /* #region VS Code `OutputChannel` API */
    // Based on: https://github.com/theia-ide/vscode/blob/standalone/0.19.x/src/vs/vscode.d.ts#L4692-L4745
    OutputCommands.APPEND = {
        id: 'output:append'
    };
    OutputCommands.APPEND_LINE = {
        id: 'output:appendLine'
    };
    OutputCommands.CLEAR = {
        id: 'output:clear'
    };
    OutputCommands.SHOW = {
        id: 'output:show'
    };
    OutputCommands.HIDE = {
        id: 'output:hide'
    };
    OutputCommands.DISPOSE = {
        id: 'output:dispose'
    };
    /* #endregion VS Code `OutputChannel` API */
    OutputCommands.CLEAR__WIDGET = common_1.Command.toLocalizedCommand({
        id: 'output:widget:clear',
        category: OUTPUT_CATEGORY,
        iconClass: (0, browser_1.codicon)('clear-all')
    }, '', OUTPUT_CATEGORY_KEY);
    OutputCommands.LOCK__WIDGET = common_1.Command.toLocalizedCommand({
        id: 'output:widget:lock',
        category: OUTPUT_CATEGORY,
        iconClass: (0, browser_1.codicon)('unlock')
    }, '', OUTPUT_CATEGORY_KEY);
    OutputCommands.UNLOCK__WIDGET = common_1.Command.toLocalizedCommand({
        id: 'output:widget:unlock',
        category: OUTPUT_CATEGORY,
        iconClass: (0, browser_1.codicon)('lock')
    }, '', OUTPUT_CATEGORY_KEY);
    OutputCommands.CLEAR__QUICK_PICK = common_1.Command.toLocalizedCommand({
        id: 'output:pick-clear',
        label: 'Clear Output Channel...',
        category: OUTPUT_CATEGORY
    }, 'theia/output/clearOutputChannel', OUTPUT_CATEGORY_KEY);
    OutputCommands.SHOW__QUICK_PICK = common_1.Command.toLocalizedCommand({
        id: 'output:pick-show',
        label: 'Show Output Channel...',
        category: OUTPUT_CATEGORY
    }, 'theia/output/showOutputChannel', OUTPUT_CATEGORY_KEY);
    OutputCommands.HIDE__QUICK_PICK = common_1.Command.toLocalizedCommand({
        id: 'output:pick-hide',
        label: 'Hide Output Channel...',
        category: OUTPUT_CATEGORY
    }, 'theia/output/hideOutputChannel', OUTPUT_CATEGORY_KEY);
    OutputCommands.DISPOSE__QUICK_PICK = common_1.Command.toLocalizedCommand({
        id: 'output:pick-dispose',
        label: 'Close Output Channel...',
        category: OUTPUT_CATEGORY
    }, 'theia/output/closeOutputChannel', OUTPUT_CATEGORY_KEY);
    OutputCommands.COPY_ALL = {
        id: 'output:copy-all',
    };
})(OutputCommands || (exports.OutputCommands = OutputCommands = {}));


/***/ }),

/***/ "../../node_modules/@theia/output/lib/browser/output-context-menu.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@theia/output/lib/browser/output-context-menu.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OutputContextMenuService = exports.OutputContextMenu = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2020 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const monaco_context_menu_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-context-menu */ "../../node_modules/@theia/monaco/lib/browser/monaco-context-menu.js");
var OutputContextMenu;
(function (OutputContextMenu) {
    OutputContextMenu.MENU_PATH = ['output_context_menu'];
    OutputContextMenu.TEXT_EDIT_GROUP = [...OutputContextMenu.MENU_PATH, '0_text_edit_group'];
    OutputContextMenu.COMMAND_GROUP = [...OutputContextMenu.MENU_PATH, '1_command_group'];
    OutputContextMenu.WIDGET_GROUP = [...OutputContextMenu.MENU_PATH, '2_widget_group'];
})(OutputContextMenu || (exports.OutputContextMenu = OutputContextMenu = {}));
let OutputContextMenuService = class OutputContextMenuService extends monaco_context_menu_1.MonacoContextMenuService {
    menuPath() {
        return OutputContextMenu.MENU_PATH;
    }
};
exports.OutputContextMenuService = OutputContextMenuService;
exports.OutputContextMenuService = OutputContextMenuService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], OutputContextMenuService);


/***/ }),

/***/ "../../node_modules/@theia/output/lib/browser/output-contribution.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@theia/output/lib/browser/output-contribution.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OutputContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const widget_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets/widget */ "../../node_modules/@theia/core/lib/browser/widgets/widget.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const view_contribution_1 = __webpack_require__(/*! @theia/core/lib/browser/shell/view-contribution */ "../../node_modules/@theia/core/lib/browser/shell/view-contribution.js");
const output_widget_1 = __webpack_require__(/*! ./output-widget */ "../../node_modules/@theia/output/lib/browser/output-widget.js");
const output_context_menu_1 = __webpack_require__(/*! ./output-context-menu */ "../../node_modules/@theia/output/lib/browser/output-context-menu.js");
const output_uri_1 = __webpack_require__(/*! ../common/output-uri */ "../../node_modules/@theia/output/lib/common/output-uri.js");
const clipboard_service_1 = __webpack_require__(/*! @theia/core/lib/browser/clipboard-service */ "../../node_modules/@theia/core/lib/browser/clipboard-service.js");
const output_channel_1 = __webpack_require__(/*! ./output-channel */ "../../node_modules/@theia/output/lib/browser/output-channel.js");
const output_commands_1 = __webpack_require__(/*! ./output-commands */ "../../node_modules/@theia/output/lib/browser/output-commands.js");
const quick_pick_service_1 = __webpack_require__(/*! @theia/core/lib/common/quick-pick-service */ "../../node_modules/@theia/core/lib/common/quick-pick-service.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
let OutputContribution = class OutputContribution extends view_contribution_1.AbstractViewContribution {
    constructor() {
        super({
            widgetId: output_widget_1.OutputWidget.ID,
            widgetName: output_widget_1.OutputWidget.LABEL,
            defaultWidgetOptions: {
                area: 'bottom'
            },
            toggleCommandId: 'output:toggle',
            toggleKeybinding: 'CtrlCmd+Shift+U'
        });
        this.id = `${output_widget_1.OutputWidget.ID}-opener`;
    }
    init() {
        this.outputChannelManager.onChannelWasShown(({ name, preserveFocus }) => (0, browser_1.open)(this.openerService, output_uri_1.OutputUri.create(name), { activate: !preserveFocus, reveal: true }));
    }
    registerCommands(registry) {
        super.registerCommands(registry);
        registry.registerCommand(output_commands_1.OutputCommands.CLEAR__WIDGET, {
            isEnabled: arg => {
                if (arg instanceof widget_1.Widget) {
                    return arg instanceof output_widget_1.OutputWidget;
                }
                return this.shell.currentWidget instanceof output_widget_1.OutputWidget;
            },
            isVisible: arg => {
                if (arg instanceof widget_1.Widget) {
                    return arg instanceof output_widget_1.OutputWidget;
                }
                return this.shell.currentWidget instanceof output_widget_1.OutputWidget;
            },
            execute: () => {
                this.widget.then(widget => {
                    this.withWidget(widget, output => {
                        output.clear();
                        return true;
                    });
                });
            }
        });
        registry.registerCommand(output_commands_1.OutputCommands.LOCK__WIDGET, {
            isEnabled: widget => this.withWidget(widget, output => !output.isLocked),
            isVisible: widget => this.withWidget(widget, output => !output.isLocked),
            execute: widget => this.withWidget(widget, output => {
                output.lock();
                return true;
            })
        });
        registry.registerCommand(output_commands_1.OutputCommands.UNLOCK__WIDGET, {
            isEnabled: widget => this.withWidget(widget, output => output.isLocked),
            isVisible: widget => this.withWidget(widget, output => output.isLocked),
            execute: widget => this.withWidget(widget, output => {
                output.unlock();
                return true;
            })
        });
        registry.registerCommand(output_commands_1.OutputCommands.COPY_ALL, {
            execute: () => {
                var _a;
                const textToCopy = (_a = this.tryGetWidget()) === null || _a === void 0 ? void 0 : _a.getText();
                if (textToCopy) {
                    this.clipboardService.writeText(textToCopy);
                }
            }
        });
        registry.registerCommand(output_commands_1.OutputCommands.APPEND, {
            execute: ({ name, text }) => {
                if (name && text) {
                    this.outputChannelManager.getChannel(name).append(text);
                }
            }
        });
        registry.registerCommand(output_commands_1.OutputCommands.APPEND_LINE, {
            execute: ({ name, text }) => {
                if (name && text) {
                    this.outputChannelManager.getChannel(name).appendLine(text);
                }
            }
        });
        registry.registerCommand(output_commands_1.OutputCommands.CLEAR, {
            execute: ({ name }) => {
                if (name) {
                    this.outputChannelManager.getChannel(name).clear();
                }
            }
        });
        registry.registerCommand(output_commands_1.OutputCommands.DISPOSE, {
            execute: ({ name }) => {
                if (name) {
                    this.outputChannelManager.deleteChannel(name);
                }
            }
        });
        registry.registerCommand(output_commands_1.OutputCommands.SHOW, {
            execute: ({ name, options }) => {
                if (name) {
                    const preserveFocus = options && options.preserveFocus || false;
                    this.outputChannelManager.getChannel(name).show({ preserveFocus });
                }
            }
        });
        registry.registerCommand(output_commands_1.OutputCommands.HIDE, {
            execute: ({ name }) => {
                if (name) {
                    this.outputChannelManager.getChannel(name).hide();
                }
            }
        });
        registry.registerCommand(output_commands_1.OutputCommands.CLEAR__QUICK_PICK, {
            execute: async () => {
                const channel = await this.pick({
                    placeholder: output_commands_1.OutputCommands.CLEAR__QUICK_PICK.label,
                    channels: this.outputChannelManager.getChannels().slice()
                });
                if (channel) {
                    channel.clear();
                }
            },
            isEnabled: () => !!this.outputChannelManager.getChannels().length,
            isVisible: () => !!this.outputChannelManager.getChannels().length
        });
        registry.registerCommand(output_commands_1.OutputCommands.SHOW__QUICK_PICK, {
            execute: async () => {
                const channel = await this.pick({
                    placeholder: output_commands_1.OutputCommands.SHOW__QUICK_PICK.label,
                    channels: this.outputChannelManager.getChannels().slice()
                });
                if (channel) {
                    const { name } = channel;
                    registry.executeCommand(output_commands_1.OutputCommands.SHOW.id, { name, options: { preserveFocus: false } });
                }
            },
            isEnabled: () => !!this.outputChannelManager.getChannels().length,
            isVisible: () => !!this.outputChannelManager.getChannels().length
        });
        registry.registerCommand(output_commands_1.OutputCommands.HIDE__QUICK_PICK, {
            execute: async () => {
                const channel = await this.pick({
                    placeholder: output_commands_1.OutputCommands.HIDE__QUICK_PICK.label,
                    channels: this.outputChannelManager.getVisibleChannels().slice()
                });
                if (channel) {
                    const { name } = channel;
                    registry.executeCommand(output_commands_1.OutputCommands.HIDE.id, { name });
                }
            },
            isEnabled: () => !!this.outputChannelManager.getVisibleChannels().length,
            isVisible: () => !!this.outputChannelManager.getVisibleChannels().length
        });
        registry.registerCommand(output_commands_1.OutputCommands.DISPOSE__QUICK_PICK, {
            execute: async () => {
                const channel = await this.pick({
                    placeholder: output_commands_1.OutputCommands.DISPOSE__QUICK_PICK.label,
                    channels: this.outputChannelManager.getChannels().slice()
                });
                if (channel) {
                    const { name } = channel;
                    registry.executeCommand(output_commands_1.OutputCommands.DISPOSE.id, { name });
                }
            },
            isEnabled: () => !!this.outputChannelManager.getChannels().length,
            isVisible: () => !!this.outputChannelManager.getChannels().length
        });
    }
    registerMenus(registry) {
        super.registerMenus(registry);
        registry.registerMenuAction(output_context_menu_1.OutputContextMenu.TEXT_EDIT_GROUP, {
            commandId: browser_1.CommonCommands.COPY.id
        });
        registry.registerMenuAction(output_context_menu_1.OutputContextMenu.TEXT_EDIT_GROUP, {
            commandId: output_commands_1.OutputCommands.COPY_ALL.id,
            label: nls_1.nls.localizeByDefault('Copy All')
        });
        registry.registerMenuAction(output_context_menu_1.OutputContextMenu.COMMAND_GROUP, {
            commandId: browser_1.quickCommand.id,
            label: nls_1.nls.localizeByDefault('Command Palette...')
        });
        registry.registerMenuAction(output_context_menu_1.OutputContextMenu.WIDGET_GROUP, {
            commandId: output_commands_1.OutputCommands.CLEAR__WIDGET.id,
            label: nls_1.nls.localizeByDefault('Clear Output')
        });
    }
    canHandle(uri) {
        return output_uri_1.OutputUri.is(uri) ? 200 : 0;
    }
    async open(uri, options) {
        if (!output_uri_1.OutputUri.is(uri)) {
            throw new Error(`Expected '${output_uri_1.OutputUri.SCHEME}' URI scheme. Got: ${uri} instead.`);
        }
        const widget = await this.openView(options);
        return widget;
    }
    withWidget(widget = this.tryGetWidget(), predicate = () => true) {
        return widget instanceof output_widget_1.OutputWidget ? predicate(widget) : false;
    }
    async pick({ channels, placeholder }) {
        const items = [];
        const outputChannels = nls_1.nls.localize('theia/output/outputChannels', 'Output Channels');
        const hiddenChannels = nls_1.nls.localize('theia/output/hiddenChannels', 'Hidden Channels');
        for (let i = 0; i < channels.length; i++) {
            const channel = channels[i];
            if (i === 0) {
                items.push({ label: channel.isVisible ? outputChannels : hiddenChannels, type: 'separator' });
            }
            else if (!channel.isVisible && channels[i - 1].isVisible) {
                items.push({ label: hiddenChannels, type: 'separator' });
            }
            items.push({ label: channel.name, value: channel });
        }
        const selectedItem = await this.quickPickService.show(items, { placeholder });
        return selectedItem && ('value' in selectedItem) ? selectedItem.value : undefined;
    }
};
exports.OutputContribution = OutputContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(clipboard_service_1.ClipboardService),
    tslib_1.__metadata("design:type", Object)
], OutputContribution.prototype, "clipboardService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.CommandService),
    tslib_1.__metadata("design:type", Object)
], OutputContribution.prototype, "commandService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(output_channel_1.OutputChannelManager),
    tslib_1.__metadata("design:type", output_channel_1.OutputChannelManager)
], OutputContribution.prototype, "outputChannelManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], OutputContribution.prototype, "openerService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(quick_pick_service_1.QuickPickService),
    tslib_1.__metadata("design:type", Object)
], OutputContribution.prototype, "quickPickService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], OutputContribution.prototype, "init", null);
exports.OutputContribution = OutputContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], OutputContribution);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_output_lib_browser_output-contribution_js.js.map