/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtilControlSize;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public abstract class AquaBorder
implements Border,
UIResource {
    protected final AquaPainter<? extends JRSUIState> painter;
    protected final AquaUtilControlSize.SizeDescriptor sizeDescriptor;
    protected AquaUtilControlSize.SizeVariant sizeVariant;

    protected AquaBorder(AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
        this.sizeDescriptor = sizeDescriptor;
        this.sizeVariant = sizeDescriptor.get(JRSUIConstants.Size.REGULAR);
        this.painter = this.createPainter();
    }

    protected AquaPainter<? extends JRSUIState> createPainter() {
        AquaPainter<JRSUIState> aquaPainter = AquaPainter.create(JRSUIState.getInstance());
        ((JRSUIState)aquaPainter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
        ((JRSUIState)aquaPainter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
        return aquaPainter;
    }

    protected AquaBorder(AquaBorder aquaBorder) {
        this.sizeDescriptor = aquaBorder.sizeDescriptor;
        this.sizeVariant = aquaBorder.sizeVariant;
        this.painter = AquaPainter.create(((JRSUIState)aquaBorder.painter.state).derive());
        ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
        ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
    }

    protected void setSize(JRSUIConstants.Size size) {
        this.sizeVariant = this.sizeDescriptor.get(size);
        ((JRSUIState)this.painter.state).set(size);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return (Insets)this.sizeVariant.margins.clone();
    }

    protected AquaBorder deriveBorderForSize(JRSUIConstants.Size size) {
        try {
            Class<?> clazz = this.getClass();
            AquaBorder aquaBorder = (AquaBorder)clazz.getConstructor(clazz).newInstance(this);
            aquaBorder.setSize(size);
            return aquaBorder;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void repaintBorder(JComponent jComponent) {
        Container container;
        JComponent jComponent2 = jComponent;
        Border border = jComponent.getBorder();
        if (border == null && (container = jComponent.getParent()) instanceof JViewport && (jComponent2 = (JComponent)container.getParent()) != null) {
            border = jComponent2.getBorder();
        }
        if (border == null || jComponent2 == null) {
            return;
        }
        int n = jComponent2.getWidth();
        int n2 = jComponent2.getHeight();
        Insets insets = jComponent2.getInsets();
        jComponent2.repaint(0, 0, n, insets.top);
        jComponent2.repaint(0, 0, insets.left, n2);
        jComponent2.repaint(0, n2 - insets.bottom, n, insets.bottom);
        jComponent2.repaint(n - insets.right, 0, insets.right, n2);
    }

    protected boolean isFocused(Component component) {
        JViewport jViewport;
        Component component2 = component;
        if (component instanceof JScrollPane ? (jViewport = ((JScrollPane)component).getViewport()) != null && (component2 = jViewport.getView()) instanceof JTextComponent : component2 instanceof JTextComponent && !((JTextComponent)component2).isEditable()) {
            return false;
        }
        return component2 != null && component2 instanceof JComponent && ((JComponent)component2).hasFocus();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        this.painter.paint(graphics, component, n, n2, n3, n4);
    }

    static class Default
    extends AquaBorder {
        Default() {
            super(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant()));
        }
    }
}

