/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import javax.swing.KeyStroke;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

public class MotifTextUI {
    static final JTextComponent.KeyBinding[] defaultBindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(155, 2), "copy-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(155, 1), "paste-from-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(127, 1), "cut-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(37, 1), "selection-backward"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(39, 1), "selection-forward")};

    public static Caret createCaret() {
        return new MotifCaret();
    }

    public static class MotifCaret
    extends DefaultCaret
    implements UIResource {
        static final int IBeamOverhang = 2;

        @Override
        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            this.getComponent().repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            super.focusLost(focusEvent);
            this.getComponent().repaint();
        }

        @Override
        protected void damage(Rectangle rectangle) {
            if (rectangle != null) {
                this.x = rectangle.x - 2 - 1;
                this.y = rectangle.y;
                this.width = rectangle.width + 4 + 3;
                this.height = rectangle.height;
                this.repaint();
            }
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.isVisible()) {
                try {
                    JTextComponent jTextComponent = this.getComponent();
                    Color color = jTextComponent.hasFocus() ? jTextComponent.getCaretColor() : jTextComponent.getDisabledTextColor();
                    TextUI textUI = jTextComponent.getUI();
                    int n = this.getDot();
                    Rectangle rectangle = textUI.modelToView(jTextComponent, n);
                    int n2 = rectangle.x - 2;
                    int n3 = rectangle.x + 2;
                    int n4 = rectangle.y + 1;
                    int n5 = rectangle.y + rectangle.height - 2;
                    graphics.setColor(color);
                    graphics.drawLine(rectangle.x, n4, rectangle.x, n5);
                    graphics.drawLine(n2, n4, n3, n4);
                    graphics.drawLine(n2, n5, n3, n5);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }
}

