/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.lang.ref.SoftReference;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.text.spi.BreakIteratorProvider;
import java.util.Locale;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleServiceProviderPool;

public abstract class BreakIterator
implements Cloneable {
    public static final int DONE = -1;
    private static final int CHARACTER_INDEX = 0;
    private static final int WORD_INDEX = 1;
    private static final int LINE_INDEX = 2;
    private static final int SENTENCE_INDEX = 3;
    private static final SoftReference<BreakIteratorCache>[] iterCache = new SoftReference[4];

    protected BreakIterator() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    public abstract int first();

    public abstract int last();

    public abstract int next(int var1);

    public abstract int next();

    public abstract int previous();

    public abstract int following(int var1);

    public int preceding(int n) {
        int n2 = this.following(n);
        while (n2 >= n && n2 != -1) {
            n2 = this.previous();
        }
        return n2;
    }

    public boolean isBoundary(int n) {
        if (n == 0) {
            return true;
        }
        int n2 = this.following(n - 1);
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        return n2 == n;
    }

    public abstract int current();

    public abstract CharacterIterator getText();

    public void setText(String string) {
        this.setText(new StringCharacterIterator(string));
    }

    public abstract void setText(CharacterIterator var1);

    public static BreakIterator getWordInstance() {
        return BreakIterator.getWordInstance(Locale.getDefault());
    }

    public static BreakIterator getWordInstance(Locale locale) {
        return BreakIterator.getBreakInstance(locale, 1);
    }

    public static BreakIterator getLineInstance() {
        return BreakIterator.getLineInstance(Locale.getDefault());
    }

    public static BreakIterator getLineInstance(Locale locale) {
        return BreakIterator.getBreakInstance(locale, 2);
    }

    public static BreakIterator getCharacterInstance() {
        return BreakIterator.getCharacterInstance(Locale.getDefault());
    }

    public static BreakIterator getCharacterInstance(Locale locale) {
        return BreakIterator.getBreakInstance(locale, 0);
    }

    public static BreakIterator getSentenceInstance() {
        return BreakIterator.getSentenceInstance(Locale.getDefault());
    }

    public static BreakIterator getSentenceInstance(Locale locale) {
        return BreakIterator.getBreakInstance(locale, 3);
    }

    private static BreakIterator getBreakInstance(Locale locale, int n) {
        Object object;
        if (iterCache[n] != null && (object = iterCache[n].get()) != null && ((BreakIteratorCache)object).getLocale().equals(locale)) {
            return ((BreakIteratorCache)object).createBreakInstance();
        }
        object = BreakIterator.createBreakInstance(locale, n);
        BreakIteratorCache breakIteratorCache = new BreakIteratorCache(locale, (BreakIterator)object);
        BreakIterator.iterCache[n] = new SoftReference<BreakIteratorCache>(breakIteratorCache);
        return object;
    }

    private static BreakIterator createBreakInstance(Locale locale, int n) {
        LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.getAdapter(BreakIteratorProvider.class, locale);
        BreakIterator breakIterator = BreakIterator.createBreakInstance(localeProviderAdapter, locale, n);
        if (breakIterator == null) {
            breakIterator = BreakIterator.createBreakInstance(LocaleProviderAdapter.forJRE(), locale, n);
        }
        return breakIterator;
    }

    private static BreakIterator createBreakInstance(LocaleProviderAdapter localeProviderAdapter, Locale locale, int n) {
        BreakIteratorProvider breakIteratorProvider = localeProviderAdapter.getBreakIteratorProvider();
        BreakIterator breakIterator = null;
        switch (n) {
            case 0: {
                breakIterator = breakIteratorProvider.getCharacterInstance(locale);
                break;
            }
            case 1: {
                breakIterator = breakIteratorProvider.getWordInstance(locale);
                break;
            }
            case 2: {
                breakIterator = breakIteratorProvider.getLineInstance(locale);
                break;
            }
            case 3: {
                breakIterator = breakIteratorProvider.getSentenceInstance(locale);
            }
        }
        return breakIterator;
    }

    public static synchronized Locale[] getAvailableLocales() {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(BreakIteratorProvider.class);
        return localeServiceProviderPool.getAvailableLocales();
    }

    private static final class BreakIteratorCache {
        private BreakIterator iter;
        private Locale locale;

        BreakIteratorCache(Locale locale, BreakIterator breakIterator) {
            this.locale = locale;
            this.iter = (BreakIterator)breakIterator.clone();
        }

        Locale getLocale() {
            return this.locale;
        }

        BreakIterator createBreakInstance() {
            return (BreakIterator)this.iter.clone();
        }
    }
}

