/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.BufferedPaints;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.RenderQueue;
import sun.java2d.pipe.SpanIterator;
import sun.java2d.pipe.hw.AccelSurface;

public abstract class BufferedContext {
    public static final int NO_CONTEXT_FLAGS = 0;
    public static final int SRC_IS_OPAQUE = 1;
    public static final int USE_MASK = 2;
    protected RenderQueue rq;
    protected RenderBuffer buf;
    protected static BufferedContext currentContext;
    private Reference<AccelSurface> validSrcDataRef = new WeakReference<Object>(null);
    private Reference<AccelSurface> validDstDataRef = new WeakReference<Object>(null);
    private Reference<Region> validClipRef = new WeakReference<Object>(null);
    private Reference<Composite> validCompRef = new WeakReference<Object>(null);
    private Reference<Paint> validPaintRef = new WeakReference<Object>(null);
    private boolean isValidatedPaintJustAColor;
    private int validatedRGB;
    private int validatedFlags;
    private boolean xformInUse;
    private AffineTransform transform;

    protected BufferedContext(RenderQueue renderQueue) {
        this.rq = renderQueue;
        this.buf = renderQueue.getBuffer();
    }

    public static void validateContext(AccelSurface accelSurface, AccelSurface accelSurface2, Region region, Composite composite, AffineTransform affineTransform, Paint paint, SunGraphics2D sunGraphics2D, int n) {
        BufferedContext bufferedContext = accelSurface2.getContext();
        bufferedContext.validate(accelSurface, accelSurface2, region, composite, affineTransform, paint, sunGraphics2D, n);
    }

    public static void validateContext(AccelSurface accelSurface) {
        BufferedContext.validateContext(accelSurface, accelSurface, null, null, null, null, null, 0);
    }

    public void validate(AccelSurface accelSurface, AccelSurface accelSurface2, Region region, Composite composite, AffineTransform affineTransform, Paint paint, SunGraphics2D sunGraphics2D, int n) {
        Region region2;
        boolean bl = false;
        boolean bl2 = false;
        if (!accelSurface2.isValid() || accelSurface2.isSurfaceLost() || accelSurface.isSurfaceLost()) {
            this.invalidateContext();
            throw new InvalidPipeException("bounds changed or surface lost");
        }
        if (paint instanceof Color) {
            int n2 = ((Color)paint).getRGB();
            if (this.isValidatedPaintJustAColor) {
                if (n2 != this.validatedRGB) {
                    this.validatedRGB = n2;
                    bl2 = true;
                }
            } else {
                this.validatedRGB = n2;
                bl2 = true;
                this.isValidatedPaintJustAColor = true;
            }
        } else if (this.validPaintRef.get() != paint) {
            bl2 = true;
            this.isValidatedPaintJustAColor = false;
        }
        AccelSurface accelSurface3 = this.validSrcDataRef.get();
        AccelSurface accelSurface4 = this.validDstDataRef.get();
        if (currentContext != this || accelSurface != accelSurface3 || accelSurface2 != accelSurface4) {
            if (accelSurface2 != accelSurface4) {
                bl = true;
            }
            if (paint == null) {
                bl2 = true;
            }
            this.setSurfaces(accelSurface, accelSurface2);
            currentContext = this;
            this.validSrcDataRef = new WeakReference<AccelSurface>(accelSurface);
            this.validDstDataRef = new WeakReference<AccelSurface>(accelSurface2);
        }
        if (region != (region2 = this.validClipRef.get()) || bl) {
            if (region != null) {
                if (bl || region2 == null || !region2.isRectangular() || !region.isRectangular() || region.getLoX() != region2.getLoX() || region.getLoY() != region2.getLoY() || region.getHiX() != region2.getHiX() || region.getHiY() != region2.getHiY()) {
                    this.setClip(region);
                }
            } else {
                this.resetClip();
            }
            this.validClipRef = new WeakReference<Region>(region);
        }
        if (composite != this.validCompRef.get() || n != this.validatedFlags) {
            if (composite != null) {
                this.setComposite(composite, n);
            } else {
                this.resetComposite();
            }
            bl2 = true;
            this.validCompRef = new WeakReference<Composite>(composite);
            this.validatedFlags = n;
        }
        boolean bl3 = false;
        if (affineTransform == null) {
            if (this.xformInUse) {
                this.resetTransform();
                this.xformInUse = false;
                bl3 = true;
            } else if (sunGraphics2D != null && !sunGraphics2D.transform.equals(this.transform)) {
                bl3 = true;
            }
            if (sunGraphics2D != null && bl3) {
                this.transform = new AffineTransform(sunGraphics2D.transform);
            }
        } else {
            this.setTransform(affineTransform);
            this.xformInUse = true;
            bl3 = true;
        }
        if (!this.isValidatedPaintJustAColor && bl3) {
            bl2 = true;
        }
        if (bl2) {
            if (paint != null) {
                BufferedPaints.setPaint(this.rq, sunGraphics2D, paint, n);
            } else {
                BufferedPaints.resetPaint(this.rq);
            }
            this.validPaintRef = new WeakReference<Paint>(paint);
        }
        accelSurface2.markDirty();
    }

    private void invalidateSurfaces() {
        this.validSrcDataRef.clear();
        this.validDstDataRef.clear();
    }

    private void setSurfaces(AccelSurface accelSurface, AccelSurface accelSurface2) {
        this.rq.ensureCapacityAndAlignment(20, 4);
        this.buf.putInt(70);
        this.buf.putLong(accelSurface.getNativeOps());
        this.buf.putLong(accelSurface2.getNativeOps());
    }

    private void resetClip() {
        this.rq.ensureCapacity(4);
        this.buf.putInt(55);
    }

    private void setClip(Region region) {
        if (region.isRectangular()) {
            this.rq.ensureCapacity(20);
            this.buf.putInt(51);
            this.buf.putInt(region.getLoX()).putInt(region.getLoY());
            this.buf.putInt(region.getHiX()).putInt(region.getHiY());
        } else {
            this.rq.ensureCapacity(28);
            this.buf.putInt(52);
            this.buf.putInt(53);
            int n = this.buf.position();
            this.buf.putInt(0);
            int n2 = 0;
            int n3 = this.buf.remaining() / 16;
            int[] nArray = new int[4];
            SpanIterator spanIterator = region.getSpanIterator();
            while (spanIterator.nextSpan(nArray)) {
                if (n3 == 0) {
                    this.buf.putInt(n, n2);
                    this.rq.flushNow();
                    this.buf.putInt(53);
                    n = this.buf.position();
                    this.buf.putInt(0);
                    n2 = 0;
                    n3 = this.buf.remaining() / 16;
                }
                this.buf.putInt(nArray[0]);
                this.buf.putInt(nArray[1]);
                this.buf.putInt(nArray[2]);
                this.buf.putInt(nArray[3]);
                ++n2;
                --n3;
            }
            this.buf.putInt(n, n2);
            this.rq.ensureCapacity(4);
            this.buf.putInt(54);
        }
    }

    private void resetComposite() {
        this.rq.ensureCapacity(4);
        this.buf.putInt(58);
    }

    private void setComposite(Composite composite, int n) {
        if (composite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)composite;
            this.rq.ensureCapacity(16);
            this.buf.putInt(56);
            this.buf.putInt(alphaComposite.getRule());
            this.buf.putFloat(alphaComposite.getAlpha());
            this.buf.putInt(n);
        } else if (composite instanceof XORComposite) {
            int n2 = ((XORComposite)composite).getXorPixel();
            this.rq.ensureCapacity(8);
            this.buf.putInt(57);
            this.buf.putInt(n2);
        } else {
            throw new InternalError("not yet implemented");
        }
    }

    private void resetTransform() {
        this.rq.ensureCapacity(4);
        this.buf.putInt(60);
    }

    private void setTransform(AffineTransform affineTransform) {
        this.rq.ensureCapacityAndAlignment(52, 4);
        this.buf.putInt(59);
        this.buf.putDouble(affineTransform.getScaleX());
        this.buf.putDouble(affineTransform.getShearY());
        this.buf.putDouble(affineTransform.getShearX());
        this.buf.putDouble(affineTransform.getScaleY());
        this.buf.putDouble(affineTransform.getTranslateX());
        this.buf.putDouble(affineTransform.getTranslateY());
    }

    public void invalidateContext() {
        this.resetTransform();
        this.resetComposite();
        this.resetClip();
        BufferedPaints.resetPaint(this.rq);
        this.invalidateSurfaces();
        this.validCompRef.clear();
        this.validClipRef.clear();
        this.validPaintRef.clear();
        this.isValidatedPaintJustAColor = false;
        this.xformInUse = false;
    }

    public abstract RenderQueue getRenderQueue();

    public abstract void saveState();

    public abstract void restoreState();
}

