/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.nio.ByteOrder;
import sun.misc.Unsafe;

final class Bits {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final boolean unalignedAccess = false;
    private static final boolean bigEndian = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    private Bits() {
    }

    private static short swap(short s) {
        return Short.reverseBytes(s);
    }

    private static char swap(char c) {
        return Character.reverseBytes(c);
    }

    private static int swap(int n) {
        return Integer.reverseBytes(n);
    }

    private static long swap(long l) {
        return Long.reverseBytes(l);
    }

    private static float swap(float f) {
        return Float.intBitsToFloat(Bits.swap(Float.floatToIntBits(f)));
    }

    private static double swap(double d) {
        return Double.longBitsToDouble(Bits.swap(Double.doubleToLongBits(d)));
    }

    private static boolean isAddressAligned(long l, int n) {
        return (l & (long)(n - 1)) == 0L;
    }

    private static byte char1(char c) {
        return (byte)(c >> 8);
    }

    private static byte char0(char c) {
        return (byte)c;
    }

    private static byte short1(short s) {
        return (byte)(s >> 8);
    }

    private static byte short0(short s) {
        return (byte)s;
    }

    private static byte int3(int n) {
        return (byte)(n >> 24);
    }

    private static byte int2(int n) {
        return (byte)(n >> 16);
    }

    private static byte int1(int n) {
        return (byte)(n >> 8);
    }

    private static byte int0(int n) {
        return (byte)n;
    }

    private static byte long7(long l) {
        return (byte)(l >> 56);
    }

    private static byte long6(long l) {
        return (byte)(l >> 48);
    }

    private static byte long5(long l) {
        return (byte)(l >> 40);
    }

    private static byte long4(long l) {
        return (byte)(l >> 32);
    }

    private static byte long3(long l) {
        return (byte)(l >> 24);
    }

    private static byte long2(long l) {
        return (byte)(l >> 16);
    }

    private static byte long1(long l) {
        return (byte)(l >> 8);
    }

    private static byte long0(long l) {
        return (byte)l;
    }

    private static void putCharBigEndianUnaligned(long l, char c) {
        Bits.putByte_(l, Bits.char1(c));
        Bits.putByte_(l + 1L, Bits.char0(c));
    }

    private static void putShortBigEndianUnaligned(long l, short s) {
        Bits.putByte_(l, Bits.short1(s));
        Bits.putByte_(l + 1L, Bits.short0(s));
    }

    private static void putIntBigEndianUnaligned(long l, int n) {
        Bits.putByte_(l, Bits.int3(n));
        Bits.putByte_(l + 1L, Bits.int2(n));
        Bits.putByte_(l + 2L, Bits.int1(n));
        Bits.putByte_(l + 3L, Bits.int0(n));
    }

    private static void putLongBigEndianUnaligned(long l, long l2) {
        Bits.putByte_(l, Bits.long7(l2));
        Bits.putByte_(l + 1L, Bits.long6(l2));
        Bits.putByte_(l + 2L, Bits.long5(l2));
        Bits.putByte_(l + 3L, Bits.long4(l2));
        Bits.putByte_(l + 4L, Bits.long3(l2));
        Bits.putByte_(l + 5L, Bits.long2(l2));
        Bits.putByte_(l + 6L, Bits.long1(l2));
        Bits.putByte_(l + 7L, Bits.long0(l2));
    }

    private static void putFloatBigEndianUnaligned(long l, float f) {
        Bits.putIntBigEndianUnaligned(l, Float.floatToRawIntBits(f));
    }

    private static void putDoubleBigEndianUnaligned(long l, double d) {
        Bits.putLongBigEndianUnaligned(l, Double.doubleToRawLongBits(d));
    }

    private static void putByte_(long l, byte by) {
        unsafe.putByte(l, by);
    }

    private static void putBoolean_(long l, boolean bl) {
        unsafe.putBoolean(null, l, bl);
    }

    private static void putChar_(long l, char c) {
        unsafe.putChar(l, bigEndian ? c : Bits.swap(c));
    }

    private static void putShort_(long l, short s) {
        unsafe.putShort(l, bigEndian ? s : Bits.swap(s));
    }

    private static void putInt_(long l, int n) {
        unsafe.putInt(l, bigEndian ? n : Bits.swap(n));
    }

    private static void putLong_(long l, long l2) {
        unsafe.putLong(l, bigEndian ? l2 : Bits.swap(l2));
    }

    private static void putFloat_(long l, float f) {
        unsafe.putFloat(l, bigEndian ? f : Bits.swap(f));
    }

    private static void putDouble_(long l, double d) {
        unsafe.putDouble(l, bigEndian ? d : Bits.swap(d));
    }

    static int putByte(long l, byte by) {
        Bits.putByte_(l, by);
        return 1;
    }

    static int putBoolean(long l, boolean bl) {
        Bits.putBoolean_(l, bl);
        return 1;
    }

    static int putChar(long l, char c) {
        if (Bits.isAddressAligned(l, 2)) {
            Bits.putChar_(l, c);
            return 2;
        }
        Bits.putCharBigEndianUnaligned(l, c);
        return 2;
    }

    static int putShort(long l, short s) {
        if (Bits.isAddressAligned(l, 2)) {
            Bits.putShort_(l, s);
            return 2;
        }
        Bits.putShortBigEndianUnaligned(l, s);
        return 2;
    }

    static int putInt(long l, int n) {
        if (Bits.isAddressAligned(l, 4)) {
            Bits.putInt_(l, n);
            return 4;
        }
        Bits.putIntBigEndianUnaligned(l, n);
        return 4;
    }

    static int putLong(long l, long l2) {
        if (Bits.isAddressAligned(l, 8)) {
            Bits.putLong_(l, l2);
            return 8;
        }
        Bits.putLongBigEndianUnaligned(l, l2);
        return 8;
    }

    static int putFloat(long l, float f) {
        if (Bits.isAddressAligned(l, 4)) {
            Bits.putFloat_(l, f);
            return 4;
        }
        Bits.putFloatBigEndianUnaligned(l, f);
        return 4;
    }

    static int putDouble(long l, double d) {
        if (Bits.isAddressAligned(l, 8)) {
            Bits.putDouble_(l, d);
            return 8;
        }
        Bits.putDoubleBigEndianUnaligned(l, d);
        return 8;
    }
}

