/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.Messages;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.PlotterPanel;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XMBeanAttributes;
import sun.tools.jconsole.inspector.XPlotter;

public class XPlottingViewer
extends PlotterPanel
implements ActionListener {
    private static final int PLOTTER_DECIMALS = 4;
    private JButton plotButton;
    private static HashMap<String, XPlottingViewer> plotterCache = new HashMap();
    private static HashMap<String, Timer> timerCache = new HashMap();
    private MBeansTab tab;
    private String attributeName;
    private String key;
    private JTable table;

    private XPlottingViewer(String string, XMBean xMBean, String string2, Object object, JTable jTable, MBeansTab mBeansTab) {
        super((String)null);
        this.tab = mBeansTab;
        this.key = string;
        this.table = jTable;
        this.attributeName = string2;
        Plotter plotter = this.createPlotter(xMBean, string2, string, jTable);
        this.setupDisplay(plotter);
    }

    static void dispose(MBeansTab mBeansTab) {
        String string;
        Iterator<String> iterator = plotterCache.keySet().iterator();
        while (iterator.hasNext()) {
            string = iterator.next();
            if (!string.startsWith(String.valueOf(mBeansTab.hashCode()))) continue;
            iterator.remove();
        }
        iterator = timerCache.keySet().iterator();
        while (iterator.hasNext()) {
            string = iterator.next();
            if (!string.startsWith(String.valueOf(mBeansTab.hashCode()))) continue;
            Timer timer = timerCache.get(string);
            timer.cancel();
            iterator.remove();
        }
    }

    public static boolean isViewableValue(Object object) {
        return object instanceof Number;
    }

    public static Component loadPlotting(XMBean xMBean, String string, Object object, JTable jTable, MBeansTab mBeansTab) {
        XPlottingViewer xPlottingViewer = null;
        if (XPlottingViewer.isViewableValue(object)) {
            String string2 = String.valueOf(mBeansTab.hashCode()) + " " + String.valueOf(xMBean.hashCode()) + " " + xMBean.getObjectName().getCanonicalName() + string;
            XPlottingViewer xPlottingViewer2 = plotterCache.get(string2);
            if (xPlottingViewer2 == null) {
                xPlottingViewer2 = new XPlottingViewer(string2, xMBean, string, object, jTable, mBeansTab);
                plotterCache.put(string2, xPlottingViewer2);
            }
            xPlottingViewer = xPlottingViewer2;
        }
        return xPlottingViewer;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        plotterCache.remove(this.key);
        Timer timer = timerCache.remove(this.key);
        timer.cancel();
        ((XMBeanAttributes)this.table).collapse(this.attributeName, this);
    }

    public Plotter createPlotter(final XMBean xMBean, final String string, String string2, JTable jTable) {
        final XPlotter xPlotter = new XPlotter(jTable, Plotter.Unit.NONE){
            Dimension prefSize;
            {
                this.prefSize = new Dimension(400, 170);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.prefSize;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.prefSize;
            }
        };
        xPlotter.createSequence(string, string, null, true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                XPlottingViewer.this.tab.workerAdd(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            long l;
                            Number number = (Number)xMBean.getSnapshotMBeanServerConnection().getAttribute(xMBean.getObjectName(), string);
                            if (number instanceof Float || number instanceof Double) {
                                xPlotter.setDecimals(4);
                                double d = number instanceof Float ? (double)((Float)number).floatValue() : (Double)number;
                                l = Math.round(d * Math.pow(10.0, 4.0));
                            } else {
                                l = number.longValue();
                            }
                            xPlotter.addValues(System.currentTimeMillis(), l);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        String string3 = "Timer-" + string2;
        Timer timer = new Timer(string3, true);
        timer.schedule(timerTask, 0L, (long)this.tab.getUpdateInterval());
        timerCache.put(string2, timer);
        return xPlotter;
    }

    private void setupDisplay(Plotter plotter) {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLayout(new BorderLayout());
        this.plotButton = new JButton(Messages.DISCARD_CHART);
        this.plotButton.addActionListener(this);
        this.plotButton.setEnabled(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.plotButton, gridBagConstraints);
        jPanel.add(this.plotButton);
        if (this.attributeName != null && this.attributeName.length() != 0) {
            JPanel jPanel2 = new JPanel();
            JLabel jLabel = new JLabel(this.attributeName);
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            jPanel2.setLayout(gridBagLayout2);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.fill = 3;
            gridBagConstraints2.anchor = 10;
            gridBagConstraints2.ipady = 10;
            gridBagLayout2.setConstraints(jLabel, gridBagConstraints2);
            jPanel2.add(jLabel);
            this.add((Component)jPanel2, "North");
        }
        this.setPlotter(plotter);
        this.add((Component)jPanel, "South");
        this.repaint();
    }
}

