/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import java.util.ArrayList;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.BaseClass;
import sun.jvm.hotspot.debugger.cdbg.CompoundType;
import sun.jvm.hotspot.debugger.cdbg.Field;
import sun.jvm.hotspot.debugger.cdbg.FieldIdentifier;
import sun.jvm.hotspot.debugger.cdbg.ObjectVisitor;
import sun.jvm.hotspot.debugger.cdbg.Type;
import sun.jvm.hotspot.debugger.cdbg.TypeVisitor;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicBaseClass;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicField;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicNamedFieldIdentifier;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicType;
import sun.jvm.hotspot.debugger.cdbg.basic.CompoundTypeKind;
import sun.jvm.hotspot.debugger.cdbg.basic.ResolveListener;
import sun.jvm.hotspot.utilities.Assert;

public class BasicCompoundType
extends BasicType
implements CompoundType {
    private CompoundTypeKind kind;
    private List baseClasses;
    private List fields;

    public BasicCompoundType(String name, int size, CompoundTypeKind kind) {
        this(name, size, kind, 0);
    }

    private BasicCompoundType(String name, int size, CompoundTypeKind kind, int cvAttributes) {
        super(name, size, cvAttributes);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(kind != null, "null kind");
        }
        this.kind = kind;
    }

    @Override
    public CompoundType asCompound() {
        return this;
    }

    @Override
    public int getNumBaseClasses() {
        return this.baseClasses == null ? 0 : this.baseClasses.size();
    }

    @Override
    public BaseClass getBaseClass(int i) {
        return (BaseClass)this.baseClasses.get(i);
    }

    public void addBaseClass(BaseClass b) {
        if (this.baseClasses == null) {
            this.baseClasses = new ArrayList();
        }
        this.baseClasses.add(b);
    }

    @Override
    public int getNumFields() {
        return this.fields == null ? 0 : this.fields.size();
    }

    @Override
    public Field getField(int i) {
        return (Field)this.fields.get(i);
    }

    public void addField(Field f) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        this.fields.add(f);
    }

    @Override
    public boolean isClass() {
        return this.kind == CompoundTypeKind.CLASS;
    }

    @Override
    public boolean isStruct() {
        return this.kind == CompoundTypeKind.STRUCT;
    }

    @Override
    public boolean isUnion() {
        return this.kind == CompoundTypeKind.UNION;
    }

    @Override
    Type resolveTypes(BasicCDebugInfoDataBase db, ResolveListener listener) {
        super.resolveTypes(db, listener);
        if (this.baseClasses != null) {
            for (Object b : this.baseClasses) {
                ((BasicBaseClass)b).resolveTypes(this, db, listener);
            }
        }
        if (this.fields != null) {
            for (Object b : this.fields) {
                ((BasicField)b).resolveTypes(this, db, listener);
            }
        }
        return this;
    }

    @Override
    public void iterateObject(Address a, ObjectVisitor v, FieldIdentifier f) {
        if (f == null) {
            int i;
            for (i = 0; i < this.getNumBaseClasses(); ++i) {
                BasicCompoundType b = (BasicCompoundType)this.getBaseClass(i).getType();
                b.iterateObject(a, v, f);
            }
            v.enterType(this, a);
            for (i = 0; i < this.getNumFields(); ++i) {
                Field field = this.getField(i);
                BasicType fieldType = (BasicType)field.getType();
                fieldType.iterateObject(a.addOffsetTo(field.getOffset()), v, new BasicNamedFieldIdentifier(field));
            }
            v.exitType();
        } else {
            v.doCompound(f, a);
        }
    }

    @Override
    protected Type createCVVariant(int cvAttributes) {
        BasicCompoundType t = new BasicCompoundType(this.getName(), this.getSize(), this.kind, cvAttributes);
        t.kind = this.kind;
        t.baseClasses = this.baseClasses;
        t.fields = this.fields;
        return t;
    }

    @Override
    public void visit(TypeVisitor v) {
        v.doCompoundType(this);
    }
}

