/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.sr;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sr extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e-\u0430\u0444\u0440\u0438\u0447\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "\u041c\u043e\u0441\u043a\u0432\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "MST",
               "\u041c\u043e\u0441\u043a\u0432\u0430 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "MST",
               "\u041c\u043e\u0441\u043a\u0432\u0430 \u0432\u0440\u0435\u043c\u0435",
               "MT",
            };
        final String[] Japan = new String[] {
               "\u0408\u0430\u043f\u0430\u043d\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "JST",
               "\u0408\u0430\u043f\u0430\u043d\u0441\u043a\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "JDT",
               "\u0408\u0430\u043f\u0430\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "PST",
               "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "PST",
               "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d \u0432\u0440\u0435\u043c\u0435",
               "PT",
            };
        final String[] Taipei = new String[] {
               "\u0422\u0430\u0438\u043f\u0435\u0438 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0435\u043c\u0435",
               "TST",
               "\u0422\u0430\u0438\u043f\u0435\u0438 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "TDT",
               "\u0422\u0430\u0438\u043f\u0435\u0438 \u0432\u0440\u0435\u043c\u0435",
               "TT",
            };
        final String[] Hovd = new String[] {
               "\u0425\u043e\u0432\u0434 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "HST",
               "\u0425\u043e\u0432\u0434 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "HST",
               "\u0425\u043e\u0432\u0434 \u0432\u0440\u0435\u043c\u0435",
               "HT",
            };
        final String[] Magadan = new String[] {
               "\u041c\u0430\u0433\u0430\u0434\u0430\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "MST",
               "\u041c\u0430\u0433\u0430\u0434\u0430\u043d \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0435\u043c\u0435\u043d\u0430",
               "MST",
               "\u041c\u0430\u0433\u0430\u0434\u0430\u043d \u0432\u0440\u0435\u043c\u0435",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0410\u0443\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0441\u043a\u043e \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "ACWST",
               "\u0410\u0443\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0441\u043a\u043e \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "ACWDT",
               "\u0410\u0443\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0441\u043a\u043e \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "\u0421\u0440\u0435\u0434\u045a\u0435\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CEST",
               "\u0421\u0440\u0435\u0434\u045a\u0435\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "CEST",
               "\u0421\u0440\u0435\u0434\u045a\u0435\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "\u0421\u0430\u0445\u0430\u043b\u0438\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "SST",
               "\u0421\u0430\u0445\u0430\u043b\u0438\u043d \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "SST",
               "\u0421\u0430\u0445\u0430\u043b\u0438\u043d \u0432\u0440\u0435\u043c\u0435",
               "ST",
            };
        final String[] Paraguay = new String[] {
               "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0458 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "PST",
               "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0458 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "PST",
               "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0458 \u0432\u0440\u0435\u043c\u0435",
               "PT",
            };
        final String[] Malaysia = new String[] {
               "\u041c\u0430\u043b\u0435\u0437\u0438\u0458\u0430 \u0432\u0440\u0435\u043c\u0435",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] America_Eastern = new String[] {
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "EST",
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "EDT",
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "\u041b\u043e\u0440\u0434 \u0425\u043e\u0432 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "LHST",
               "\u041b\u043e\u0440\u0434 \u0425\u043e\u0432 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "LHDT",
               "\u041b\u043e\u0440\u0434 \u0425\u043e\u0432 \u0432\u0440\u0435\u043c\u0435",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "\u041d\u043e\u0432\u0438 \u0417\u0435\u043b\u0430\u043d\u0434 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "NZST",
               "\u041d\u043e\u0432\u0438 \u0417\u0435\u043b\u0430\u043d\u0434 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "NZDT",
               "\u041d\u043e\u0432\u0438 \u0417\u0435\u043b\u0430\u043d\u0434 \u0432\u0440\u0435\u043c\u0435",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u0418\u043d\u0434\u0438\u0458\u0441\u043a\u043e \u043e\u043a\u0435\u0430\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "\u0408\u0430\u043a\u0443\u0442\u0441\u043a \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "YST",
               "\u0408\u0430\u043a\u0443\u0442\u0441\u043a \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "YST",
               "\u0408\u0430\u043a\u0443\u0442\u0441\u043a \u0432\u0440\u0435\u043c\u0435",
               "YT",
            };
        final String[] Mauritius = new String[] {
               "\u041c\u0430\u0443\u0440\u0438\u0446\u0438\u0458\u0443\u0441 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "MST",
               "\u041c\u0430\u0443\u0440\u0438\u0446\u0438\u0458\u0443\u0441 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "MST",
               "\u041c\u0430\u0443\u0440\u0438\u0446\u0438\u0458\u0443\u0441 \u0432\u0440\u0435\u043c\u0435",
               "MT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e-\u0430\u0444\u0440\u0438\u0447\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "\u0418\u0441\u0442\u043e\u0447\u043d\u0438 \u0442\u0438\u043c\u043e\u0440 \u0432\u0440\u0435\u043c\u0435",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Solomon = new String[] {
               "\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430 \u0432\u0440\u0435\u043c\u0435",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Kosrae = new String[] {
               "\u041a\u043e\u0448\u0440\u0435 \u0432\u0440\u0435\u043c\u0435",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Marshall_Islands = new String[] {
               "\u041c\u0430\u0440\u0448\u0430\u043b\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430 \u0432\u0440\u0435\u043c\u0435",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "EEST",
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "EEST",
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u040a\u0443\u0444\u0430\u0443\u043d\u0434\u043b\u0435\u043d\u0434 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "NST",
               "\u040a\u0443\u0444\u0430\u0443\u043d\u0434\u043b\u0435\u043d\u0434 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "NDT",
               "\u040a\u0443\u0444\u0430\u0443\u043d\u0434\u043b\u0435\u043d\u0434 \u0432\u0440\u0435\u043c\u0435",
               "NT",
            };
        final String[] Hong_Kong = new String[] {
               "\u0425\u043e\u043d\u0433 \u041a\u043e\u043d\u0433 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "HKST",
               "\u0425\u043e\u043d\u0433\u043a\u043e\u043d\u0448\u043a\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "HKST",
               "\u0425\u043e\u043d\u0433 \u041a\u043e\u043d\u0433 \u0432\u0440\u0435\u043c\u0435",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WAST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "WAST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u0432\u0440\u0435\u043c\u0435",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "\u0410\u0442\u043b\u0430\u043d\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AST",
               "\u0410\u0442\u043b\u0430\u043d\u0441\u043a\u043e \u043b\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "ADT",
               "\u0410\u0442\u043b\u0430\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "AT",
            };
        final String[] Ponape = new String[] {
               "\u041f\u043e\u043d\u0430\u043f\u0435 \u0432\u0440\u0435\u043c\u0435",
               "PT",
               "Ponape Summer Time",
               "PST",
               "Ponape Time",
               "PT",
            };
        final String[] Bolivia = new String[] {
               "\u0411\u043e\u043b\u0438\u0432\u0438\u0458\u0430 \u0432\u0440\u0435\u043c\u0435",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u041f\u0458\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u043e\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "PMST",
               "\u041f\u0458\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u043e\u043d \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0435\u043c\u0435\u043d\u0430",
               "PMDT",
               "\u041f\u0458\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u043e\u043d \u0432\u0440\u0435\u043c\u0435",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "\u0418\u043d\u0434\u043e\u043a\u0438\u043d\u0430 \u0432\u0440\u0435\u043c\u0435",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u0408\u0435\u043a\u0430\u0442\u0435\u0440\u0438\u043d\u0431\u0443\u0440\u0433 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "YST",
               "\u0408\u0435\u043a\u0430\u0442\u0435\u0440\u0438\u043d\u0431\u0443\u0440\u0433 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "YST",
               "\u0408\u0435\u043a\u0430\u0442\u0435\u0440\u0438\u043d\u0431\u0443\u0440\u0433 \u0432\u0440\u0435\u043c\u0435",
               "YT",
            };
        final String[] Maldives = new String[] {
               "\u041c\u0430\u043b\u0434\u0438\u0432\u0438 \u0432\u0440\u0435\u043c\u0435",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Tahiti = new String[] {
               "\u0422\u0430\u0445\u0438\u0442\u0438 \u0432\u0440\u0435\u043c\u0435",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Israel = new String[] {
               "\u0418\u0437\u0440\u0430\u0435\u043b\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "IST",
               "\u0418\u0437\u0440\u0430\u0435\u043b\u0441\u043a\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "IDT",
               "\u0418\u0437\u0440\u0430\u0435\u043b\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e-\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0458\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Wallis = new String[] {
               "\u0412\u0430\u043b\u0438\u0441 \u0438 \u0424\u0443\u0442\u0443\u043d\u0430 \u041e\u0441\u0442\u0440\u0432\u0430 \u0432\u0440\u0435\u043c\u0435",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "\u0408\u0443\u0436\u043d\u043e-\u0430\u0444\u0440\u0438\u0447\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "\u0428\u043e\u0432\u0430 \u0432\u0440\u0435\u043c\u0435",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Line_Islands = new String[] {
               "\u041b\u0438\u043d\u0435 \u041e\u0441\u0442\u0440\u0432\u0430 \u0432\u0440\u0435\u043c\u0435",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Uzbekistan = new String[] {
               "\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "UST",
               "\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "UST",
               "\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d \u0432\u0440\u0435\u043c\u0435",
               "UT",
            };
        final String[] Omsk = new String[] {
               "\u041e\u043c\u0441\u043a \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "OST",
               "\u041e\u043c\u0441\u043a \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "OST",
               "\u041e\u043c\u0441\u043a \u0432\u0440\u0435\u043c\u0435",
               "OT",
            };
        final String[] Seychelles = new String[] {
               "\u0421\u0435\u0458\u0448\u0435\u043b\u0438 \u0432\u0440\u0435\u043c\u0435",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Uruguay = new String[] {
               "\u0423\u0440\u0443\u0433\u0432\u0430\u0458 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "UST",
               "\u0423\u0440\u0443\u0433\u0432\u0430\u0458 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "UST",
               "\u0423\u0440\u0443\u0433\u0432\u0430\u0458 \u0432\u0440\u0435\u043c\u0435",
               "UT",
            };
        final String[] Nepal = new String[] {
               "\u041d\u0435\u043f\u0430\u043b \u0432\u0440\u0435\u043c\u0435",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Mongolia = new String[] {
               "\u0423\u043b\u0430\u043d \u0411\u0430\u0442\u043e\u0440 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "UBST",
               "\u0423\u043b\u0430\u043d \u0411\u0430\u0442\u043e\u0440 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "UBST",
               "\u0423\u043b\u0430\u043d \u0411\u0430\u0442\u043e\u0440 \u0432\u0440\u0435\u043c\u0435",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CST",
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "CDT",
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CT",
            };
        final String[] Truk = new String[] {
               "\u0422\u0440\u0443\u043a \u0432\u0440\u0435\u043c\u0435",
               "CT",
               "Chuuk Summer Time",
               "CST",
               "Chuuk Time",
               "CT",
            };
        final String[] Niue = new String[] {
               "\u041d\u0438\u0443\u0435 \u0432\u0440\u0435\u043c\u0435",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Wake = new String[] {
               "\u0412\u0435\u0458\u043a \u043e\u0441\u0442\u0440\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Falkland = new String[] {
               "\u0424\u043e\u043b\u043a\u043b\u0430\u043d\u0434\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "FIST",
               "\u0424\u043e\u043b\u043a\u043b\u0430\u043d\u0434\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "FIST",
               "\u0424\u043e\u043b\u043a\u043b\u0430\u043d\u0434\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430 \u0432\u0440\u0435\u043c\u0435",
               "FIT",
            };
        final String[] Vanuatu = new String[] {
               "\u0412\u0430\u043d\u0443\u0430\u0442\u0443 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "VST",
               "\u0412\u0430\u043d\u0443\u0430\u0442\u0443 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "VST",
               "\u0412\u0430\u043d\u0443\u0430\u0442\u0443 \u0432\u0440\u0435\u043c\u0435",
               "VT",
            };
        final String[] Novosibirsk = new String[] {
               "\u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "NST",
               "\u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "NST",
               "\u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a \u0432\u0440\u0435\u043c\u0435",
               "NT",
            };
        final String[] Singapore = new String[] {
               "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Azores = new String[] {
               "\u0410\u0437\u043e\u0440\u0438 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AST",
               "\u0410\u0437\u043e\u0440\u0438 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "AST",
               "\u0410\u0437\u043e\u0440\u0438 \u0432\u0440\u0435\u043c\u0435",
               "AT",
            };
        final String[] Bhutan = new String[] {
               "\u0411\u0443\u0442\u0430\u043d \u0432\u0440\u0435\u043c\u0435",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Suriname = new String[] {
               "\u0421\u0443\u0440\u0438\u043d\u0430\u043c \u0432\u0440\u0435\u043c\u0435",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Nauru = new String[] {
               "\u041d\u0430\u0443\u0440\u0443 \u0432\u0440\u0435\u043c\u0435",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u041a\u0440\u0430\u0441\u043d\u043e\u0458\u0430\u0440\u0441\u043a \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "KST",
               "\u041a\u0440\u0430\u0441\u043d\u043e\u0458\u0430\u0440\u0441\u043a \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "KST",
               "\u041a\u0440\u0430\u0441\u043d\u043e\u0458\u0430\u0440\u0441\u043a \u0432\u0440\u0435\u043c\u0435",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e-\u043a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Myanmar = new String[] {
               "\u041c\u0438\u0458\u0430\u043d\u043c\u0430\u0440 \u0432\u0440\u0435\u043c\u0435",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Christmas = new String[] {
               "\u0411\u043e\u0436\u0438\u045b\u043d\u0430 \u043e\u0441\u0442\u0440\u0432\u0430 \u0432\u0440\u0435\u043c\u0435",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "\u0410\u043c\u0430\u0437\u043e\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AST",
               "\u0410\u043c\u0430\u0437\u043e\u043d \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "AST",
               "\u0410\u043c\u0430\u0437\u043e\u043d \u0432\u0440\u0435\u043c\u0435",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e-\u043a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Fiji = new String[] {
               "\u0424\u0438\u045f\u0438 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "FST",
               "\u0424\u0438\u045f\u0438 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "FST",
               "\u0424\u0438\u045f\u0438 \u0432\u0440\u0435\u043c\u0435",
               "FT",
            };
        final String[] Reunion = new String[] {
               "\u0420\u0435\u0438\u043d\u0438\u043e\u043d \u0432\u0440\u0435\u043c\u0435",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Cocos = new String[] {
               "\u041a\u043e\u043a\u043e\u0441 (\u041a\u0435\u043b\u0438\u043d\u0433) \u041e\u0441\u0442\u0440\u0432\u0430 \u0432\u0440\u0435\u043c\u0435",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Chatham = new String[] {
               "\u0427\u0430\u0442\u0430\u043c \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CST",
               "\u0427\u0430\u0442\u0430\u043c \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "CDT",
               "\u0427\u0430\u0442\u0430\u043c \u0432\u0440\u0435\u043c\u0435",
               "CT",
            };
        final String[] Vostok = new String[] {
               "\u0412\u043e\u0441\u0442\u043e\u043a \u0432\u0440\u0435\u043c\u0435",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Argentina = new String[] {
               "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AST",
               "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "AST",
               "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u0432\u0440\u0435\u043c\u0435",
               "AT",
            };
        final String[] Gambier = new String[] {
               "\u0413\u0430\u043c\u0431\u0438\u0458\u0435\u0440 \u0432\u0440\u0435\u043c\u0435",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Tuvalu = new String[] {
               "\u0422\u0443\u0432\u0430\u043b\u0443 \u0432\u0440\u0435\u043c\u0435",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Galapagos = new String[] {
               "\u0413\u0430\u043b\u0430\u043f\u0430\u0433\u043e\u0441 \u0432\u0440\u0435\u043c\u0435",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] Macquarie = new String[] {
               "\u041c\u0430\u043a\u0432\u0435\u0440\u0438\u0458\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Venezuela = new String[] {
               "\u0412\u0435\u043d\u0435\u0446\u0443\u0435\u043b\u0430 \u0432\u0440\u0435\u043c\u0435",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u0425\u0430\u0432\u0430\u0458\u0441\u043a\u043e-\u0430\u043b\u0435\u0443\u0442\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "HAST",
               "\u0425\u0430\u0432\u0430\u0458\u0441\u043a\u043e-\u0430\u043b\u0435\u0443\u0442\u0441\u043a\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "HADT",
               "\u0425\u0430\u0432\u0430\u0458\u0441\u043a\u043e-\u0430\u043b\u0435\u0443\u0442\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\u0410\u0443\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0441\u043a\u043e \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "ACST",
               "\u0410\u0443\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0441\u043a\u043e \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "ACDT",
               "\u0410\u0443\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0441\u043a\u043e \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "\u041f\u0430\u0446\u0438\u0444\u0438\u0447\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "PST",
               "\u041f\u0430\u0446\u0438\u0444\u0438\u0447\u043a\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "PDT",
               "\u041f\u0430\u0446\u0438\u0444\u0438\u0447\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u0424\u0435\u043d\u0438\u043a\u0441 \u043e\u0441\u0442\u0440\u0432\u0430 \u0432\u0440\u0435\u043c\u0435",
               "PIT",
               "Phoenix Islands Summer Time",
               "PIST",
               "Phoenix Islands Time",
               "PIT",
            };
        final String[] Turkmenistan = new String[] {
               "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "TST",
               "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "TST",
               "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d \u0432\u0440\u0435\u043c\u0435",
               "TT",
            };
        final String[] Europe_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WEST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "WEST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "\u0417\u0435\u043b\u0435\u043d\u0438\u0440\u0442\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CVST",
               "\u0417\u0435\u043b\u0435\u043d\u043e\u0440\u0442\u0441\u043a\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "CVST",
               "\u0417\u0435\u043b\u0435\u043d\u0438\u0440\u0442\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u041e\u0441\u0442\u0440\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Guyana = new String[] {
               "\u0413\u0432\u0430\u0458\u0430\u043d\u0430 \u0432\u0440\u0435\u043c\u0435",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Pitcairn = new String[] {
               "\u041f\u0438\u0442\u043a\u0435\u0440\u043d \u0432\u0440\u0435\u043c\u0435",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "\u0420\u043e\u0442\u0435\u0440\u0430 \u0432\u0440\u0435\u043c\u0435",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Samoa = new String[] {
               "\u0421\u0430\u043c\u043e\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Azerbaijan = new String[] {
               "\u0410\u0437\u0435\u0440\u0431\u0435\u0458\u045f\u0430\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AST",
               "\u0410\u0437\u0435\u0440\u0431\u0435\u0458\u045f\u0430\u043d \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "AST",
               "\u0410\u0437\u0435\u0440\u0431\u0435\u0458\u045f\u0430\u043d \u0432\u0440\u0435\u043c\u0435",
               "AT",
            };
        final String[] Mawson = new String[] {
               "\u041c\u043e\u0441\u043e\u043d \u0432\u0440\u0435\u043c\u0435",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Davis = new String[] {
               "\u0414\u0435\u0458\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "\u041a\u0443\u0431\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CST",
               "\u041a\u0443\u0431\u0430 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "CDT",
               "\u041a\u0443\u0431\u0430 \u0432\u0440\u0435\u043c\u0435",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e-\u0430\u0444\u0440\u0438\u0447\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WAST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e-\u0430\u0444\u0440\u0438\u0447\u043a\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "WAST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e-\u0430\u0444\u0440\u0438\u0447\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "WAT",
            };
        final String[] GMT = new String[] {
               "\u0413\u0440\u0438\u043d\u0432\u0438\u0447 \u0441\u0440\u0435\u0434\u045a\u0435 \u0432\u0440\u0435\u043c\u0435",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Philippines = new String[] {
               "\u0424\u0438\u043b\u0438\u043f\u0438\u043d\u0438 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "PST",
               "\u0424\u0438\u043b\u0438\u043f\u0438\u043d\u0438 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "PST",
               "\u0424\u0438\u043b\u0438\u043f\u0438\u043d\u0438 \u0432\u0440\u0435\u043c\u0435",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u043e \u0458\u0443\u0436\u043d\u043e \u0438 \u0430\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u0447\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] South_Georgia = new String[] {
               "\u0408\u0443\u0436\u043d\u0430 \u040f\u043e\u0440\u045f\u0438\u0458\u0430 \u0432\u0440\u0435\u043c\u0435",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] New_Caledonia = new String[] {
               "\u041d\u043e\u0432\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u0458\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "NCST",
               "\u041d\u043e\u0432\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u0458\u0430 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "NCST",
               "\u041d\u043e\u0432\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u0458\u0430 \u0432\u0440\u0435\u043c\u0435",
               "NCT",
            };
        final String[] Volgograd = new String[] {
               "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "VST",
               "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "VST",
               "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434 \u0432\u0440\u0435\u043c\u0435",
               "VT",
            };
        final String[] Brunei = new String[] {
               "\u0411\u0440\u0443\u043d\u0435\u0458 \u0414\u0430\u0440\u0443\u0441\u0430\u043b\u0443\u043c \u0432\u0440\u0435\u043c\u0435",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Iran = new String[] {
               "\u0418\u0440\u0430\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "IST",
               "\u0418\u0440\u0430\u043d \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "IDT",
               "\u0418\u0440\u0430\u043d \u0432\u0440\u0435\u043c\u0435",
               "IT",
            };
        final String[] Easter = new String[] {
               "\u0423\u0441\u043a\u0440\u0448\u045a\u0430 \u043e\u0441\u0442\u0440\u0432\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "EIST",
               "\u0423\u0441\u043a\u0440\u0448\u045a\u0430 \u043e\u0441\u0442\u0440\u0432\u0430 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "EIST",
               "\u0423\u0441\u043a\u0440\u0448\u045a\u0430 \u043e\u0441\u0442\u0440\u0432\u0430 \u0432\u0440\u0435\u043c\u0435",
               "EIT",
            };
        final String[] DumontDUrville = new String[] {
               "\u0414\u0438\u043c\u043e\u043d \u0434\u2019\u0423\u0440\u0432\u0438\u043b \u0432\u0440\u0435\u043c\u0435",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Tajikistan = new String[] {
               "\u0422\u0430\u045f\u0438\u043a\u0438\u0441\u0442\u0430\u043d \u0432\u0440\u0435\u043c\u0435",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Tonga = new String[] {
               "\u0422\u043e\u043d\u0433\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "TST",
               "\u0422\u043e\u043d\u0433\u0430 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "TST",
               "\u0422\u043e\u043d\u0433\u0430 \u0432\u0440\u0435\u043c\u0435",
               "TT",
            };
        final String[] Bangladesh = new String[] {
               "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "BST",
               "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "BST",
               "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448 \u0432\u0440\u0435\u043c\u0435",
               "BT",
            };
        final String[] Peru = new String[] {
               "\u041f\u0435\u0440\u0443 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "PST",
               "\u041f\u0435\u0440\u0443 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "PST",
               "\u041f\u0435\u0440\u0443 \u0432\u0440\u0435\u043c\u0435",
               "PT",
            };
        final String[] Greenland_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u043d\u0438 \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WGST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u0438 \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "WGST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u0438 \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u0432\u0440\u0435\u043c\u0435",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "\u0415\u043a\u0432\u0430\u0434\u043e\u0440 \u0432\u0440\u0435\u043c\u0435",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u0418\u0441\u0442\u043e\u0447\u043d\u0438 \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "EGST",
               "\u0418\u0441\u0442\u043e\u0447\u043d\u0438 \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "EGST",
               "\u0418\u0441\u0442\u043e\u0447\u043d\u0438 \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u0432\u0440\u0435\u043c\u0435",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "\u0417\u0430\u043b\u0438\u0432 \u0432\u0440\u0435\u043c\u0435",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e-\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0458\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "\u041a\u043e\u0440\u0435\u0458\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "KST",
               "\u041a\u043e\u0440\u0435\u0458\u0441\u043a\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "KDT",
               "\u041a\u043e\u0440\u0435\u0458\u0430 \u0432\u0440\u0435\u043c\u0435",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "\u0410\u0443\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0441\u043a\u043e \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AWST",
               "\u0410\u0443\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0441\u043a\u043e \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "AWDT",
               "\u0410\u0443\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0441\u043a\u043e \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WAT",
            };
        final String[] Kyrgystan = new String[] {
               "\u041a\u0438\u0440\u0433\u0438\u0437\u0441\u0442\u0430\u043d \u0432\u0440\u0435\u043c\u0435",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e-\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0458\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0410\u0443\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0441\u043a\u043e \u0438\u0441\u0442\u043e\u0447\u043d\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AEST",
               "\u0410\u0443\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0441\u043a\u043e \u0438\u0441\u0442\u043e\u0447\u043d\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "AEDT",
               "\u0410\u0443\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0441\u043a\u043e \u0438\u0441\u0442\u043e\u0447\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "EAT",
            };
        final String[] French_Guiana = new String[] {
               "\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0430 \u0413\u0432\u0430\u0458\u0430\u043d\u0430 \u0432\u0440\u0435\u043c\u0435",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Colombia = new String[] {
               "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0458\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CST",
               "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0458\u0430 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "CST",
               "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0458\u0430 \u0432\u0440\u0435\u043c\u0435",
               "CT",
            };
        final String[] Chile = new String[] {
               "\u0427\u0438\u043b\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CST",
               "\u0427\u0438\u043b\u0435 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "CST",
               "\u0427\u0438\u043b\u0435 \u0432\u0440\u0435\u043c\u0435",
               "CT",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u0413\u0438\u043b\u0431\u0435\u0440\u0442 \u043e\u0441\u0442\u0440\u0432\u0430 \u0432\u0440\u0435\u043c\u0435",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] America_Mountain = new String[] {
               "\u041f\u043b\u0430\u043d\u0438\u043d\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "MST",
               "\u041f\u043b\u0430\u043d\u0438\u043d\u0441\u043a\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "MDT",
               "\u041f\u043b\u0430\u043d\u0438\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "\u041c\u0430\u0440\u043a\u0438\u0437 \u0432\u0440\u0435\u043c\u0435",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Arabian = new String[] {
               "\u0410\u0440\u0430\u0431\u0438\u0458\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AST",
               "\u0410\u0440\u0430\u0431\u0438\u0458\u0441\u043a\u043e \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "ADT",
               "\u0410\u0440\u0430\u0431\u0438\u0458\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "AT",
            };
        final String[] Alaska = new String[] {
               "\u0410\u0459\u0430\u0448\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AKST",
               "\u0410\u0459\u0430\u0448\u043a\u043e \u043b\u0435\u0442\u045a\u0435 \u0432\u0440\u0435\u043c\u0435",
               "AKDT",
               "\u0410\u0459\u0430\u0448\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "\u0412\u043b\u0430\u0434\u0438\u0432\u043e\u0441\u0442\u043e\u043a \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "VST",
               "\u0412\u043b\u0430\u0434\u0438\u0432\u043e\u0441\u0442\u043e\u043a \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "VST",
               "\u0412\u043b\u0430\u0434\u0438\u0432\u043e\u0441\u0442\u043e\u043a \u0432\u0440\u0435\u043c\u0435",
               "VT",
            };
        final String[] Chamorro = new String[] {
               "\u0427\u0430\u043c\u043e\u0440\u043e \u0432\u0440\u0435\u043c\u0435",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Irkutsk = new String[] {
               "\u0418\u0440\u043a\u0443\u0446\u043a \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "IST",
               "\u0418\u0440\u043a\u0443\u0446\u043a \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "IST",
               "\u0418\u0440\u043a\u0443\u0446\u043a \u0432\u0440\u0435\u043c\u0435",
               "IT",
            };
        final String[] Georgia = new String[] {
               "\u0413\u0440\u0443\u0437\u0438\u0458\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "GST",
               "\u0413\u0440\u0443\u0437\u0438\u0458\u0430 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "GST",
               "\u0413\u0440\u0443\u0437\u0438\u0458\u0430 \u0432\u0440\u0435\u043c\u0435",
               "GT",
            };
        final String[] Tokelau = new String[] {
               "\u0422\u043e\u043a\u0435\u043b\u0430\u0443 \u0432\u0440\u0435\u043c\u0435",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u041f\u0430\u043f\u0443\u0430 \u041d\u043e\u0432\u0430 \u0413\u0432\u0438\u043d\u0435\u0458\u0430 \u0432\u0440\u0435\u043c\u0435",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Noronha = new String[] {
               "\u0424\u0435\u0440\u043d\u0430\u043d\u0434\u043e \u0434\u0435 \u041d\u043e\u0440\u043e\u045a\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "FNST",
               "\u0424\u0435\u0440\u043d\u0430\u043d\u0434\u043e \u0434\u0435 \u041d\u043e\u0440\u043e\u045a\u0430 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "FNST",
               "\u0424\u0435\u0440\u043d\u0430\u043d\u0434\u043e \u0434\u0435 \u041d\u043e\u0440\u043e\u045a\u0430 \u0432\u0440\u0435\u043c\u0435",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u0427\u043e\u0458\u0431\u0430\u043b\u0441\u0430\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CST",
               "\u0427\u043e\u0458\u0431\u0430\u043b\u0441\u0430\u043d \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "CST",
               "\u0427\u043e\u0458\u0431\u0430\u043b\u0441\u0430\u043d \u0432\u0440\u0435\u043c\u0435",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u0458\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "BST",
               "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u0458\u0430 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "BST",
               "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u0458\u0430 \u0432\u0440\u0435\u043c\u0435",
               "BT",
            };
        final String[] China = new String[] {
               "\u041a\u0438\u043d\u0435\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CST",
               "\u041a\u0438\u043d\u0430 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "CDT",
               "\u041a\u0438\u043d\u0430 \u0432\u0440\u0435\u043c\u0435",
               "CT",
            };
        final String[] Armenia = new String[] {
               "\u0410\u0440\u043c\u0435\u043d\u0438\u0458\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AST",
               "\u0410\u0440\u043c\u0435\u043d\u0438\u0458\u0430 \u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "AST",
               "\u0410\u0440\u043c\u0435\u043d\u0438\u0458\u0430 \u0432\u0440\u0435\u043c\u0435",
               "AT",
            };
        final String[] India = new String[] {
               "\u0418\u043d\u0434\u0438\u0458\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "\u041a\u0443\u043a\u043e\u0432\u0430 \u043e\u0441\u0442\u0440\u0432\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CIST",
               "\u041a\u0443\u043a\u043e\u0432\u0430 \u043e\u0441\u0442\u0440\u0432\u0430 \u043f\u043e\u043b\u0443-\u043b\u0435\u0442\u045a\u0435 \u0440\u0430\u0447\u0443\u043d\u0430\u045a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430",
               "CIHST",
               "\u041a\u0443\u043a\u043e\u0432\u0430 \u043e\u0441\u0442\u0440\u0432\u0430 \u0432\u0440\u0435\u043c\u0435",
               "CIT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London", GMT },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", GMT },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "America/Ciudad_Juarez", America_Mountain },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", America_Mountain },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Samoa },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin", GMT },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Central },
            { "America/Ojinaga", America_Central },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
