/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.PackerImpl;
import com.sun.java.util.jar.pack.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

final class PropMap
implements SortedMap<String, String> {
    private final TreeMap<String, String> theMap = new TreeMap();
    private final List<Object> listenerList = new ArrayList<Object>(1);
    private static Map<String, String> defaultProps;

    void addListener(Object object) {
        assert (Beans.isPropertyChangeListener(object));
        this.listenerList.add(object);
    }

    void removeListener(Object object) {
        assert (Beans.isPropertyChangeListener(object));
        this.listenerList.remove(object);
    }

    @Override
    public String put(String string, String string2) {
        String string3 = this.theMap.put(string, string2);
        if (string2 != string3 && !this.listenerList.isEmpty()) {
            assert (Beans.isBeansPresent());
            Object object = Beans.newPropertyChangeEvent(this, string, string3, string2);
            for (Object object2 : this.listenerList) {
                Beans.invokePropertyChange(object2, object);
            }
        }
        return string3;
    }

    PropMap() {
        this.theMap.putAll(defaultProps);
    }

    SortedMap<String, String> prefixMap(String string) {
        int n = string.length();
        if (n == 0) {
            return this;
        }
        char c = (char)(string.charAt(n - 1) + '\u0001');
        String string2 = string.substring(0, n - 1) + c;
        return this.subMap(string, string2);
    }

    String getProperty(String string) {
        return this.get(string);
    }

    String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    String setProperty(String string, String string2) {
        return this.put(string, string2);
    }

    List<String> getProperties(String string) {
        Collection<String> collection = this.prefixMap(string).values();
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        arrayList.addAll(collection);
        while (arrayList.remove(null)) {
        }
        return arrayList;
    }

    private boolean toBoolean(String string) {
        return Boolean.valueOf(string);
    }

    boolean getBoolean(String string) {
        return this.toBoolean(this.getProperty(string));
    }

    boolean setBoolean(String string, boolean bl) {
        return this.toBoolean(this.setProperty(string, String.valueOf(bl)));
    }

    int toInteger(String string) {
        return this.toInteger(string, 0);
    }

    int toInteger(String string, int n) {
        if (string == null) {
            return n;
        }
        if ("true".equals(string)) {
            return 1;
        }
        if ("false".equals(string)) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    int getInteger(String string, int n) {
        return this.toInteger(this.getProperty(string), n);
    }

    int getInteger(String string) {
        return this.toInteger(this.getProperty(string));
    }

    int setInteger(String string, int n) {
        return this.toInteger(this.setProperty(string, String.valueOf(n)));
    }

    long toLong(String string) {
        try {
            return string == null ? 0L : Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid value");
        }
    }

    long getLong(String string) {
        return this.toLong(this.getProperty(string));
    }

    long setLong(String string, long l) {
        return this.toLong(this.setProperty(string, String.valueOf(l)));
    }

    int getTime(String string) {
        String string2 = this.getProperty(string, "0");
        if ("now".equals(string2)) {
            return (int)((System.currentTimeMillis() + 500L) / 1000L);
        }
        long l = this.toLong(string2);
        if (l < 10000000000L && !"0".equals(string2)) {
            Utils.log.warning("Supplied modtime appears to be seconds rather than milliseconds: " + string2);
        }
        return (int)((l + 500L) / 1000L);
    }

    void list(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream);
        this.list(printWriter);
        printWriter.flush();
    }

    void list(PrintWriter printWriter) {
        printWriter.println("#PACK200[");
        Set<Map.Entry<String, String>> set = defaultProps.entrySet();
        for (Map.Entry<String, String> entry : this.theMap.entrySet()) {
            if (set.contains(entry)) continue;
            printWriter.println("  " + entry.getKey() + " = " + entry.getValue());
        }
        printWriter.println("#]");
    }

    @Override
    public int size() {
        return this.theMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.theMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.theMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.theMap.containsValue(object);
    }

    @Override
    public String get(Object object) {
        return this.theMap.get(object);
    }

    @Override
    public String remove(Object object) {
        return this.theMap.remove(object);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        this.theMap.putAll(map);
    }

    @Override
    public void clear() {
        this.theMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.theMap.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.theMap.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.theMap.entrySet();
    }

    @Override
    public Comparator<? super String> comparator() {
        return this.theMap.comparator();
    }

    @Override
    public SortedMap<String, String> subMap(String string, String string2) {
        return this.theMap.subMap(string, string2);
    }

    @Override
    public SortedMap<String, String> headMap(String string) {
        return this.theMap.headMap(string);
    }

    @Override
    public SortedMap<String, String> tailMap(String string) {
        return this.theMap.tailMap(string);
    }

    @Override
    public String firstKey() {
        return this.theMap.firstKey();
    }

    @Override
    public String lastKey() {
        return this.theMap.lastKey();
    }

    static {
        HashMap<Object, Object> hashMap;
        Properties properties = new Properties();
        properties.put("com.sun.java.util.jar.pack.disable.native", String.valueOf(Boolean.getBoolean("com.sun.java.util.jar.pack.disable.native")));
        properties.put("com.sun.java.util.jar.pack.verbose", String.valueOf(Integer.getInteger("com.sun.java.util.jar.pack.verbose", 0)));
        properties.put("com.sun.java.util.jar.pack.default.timezone", String.valueOf(Boolean.getBoolean("com.sun.java.util.jar.pack.default.timezone")));
        properties.put("pack.segment.limit", "-1");
        properties.put("pack.keep.file.order", "true");
        properties.put("pack.modification.time", "keep");
        properties.put("pack.deflate.hint", "keep");
        properties.put("pack.unknown.attribute", "pass");
        properties.put("com.sun.java.util.jar.pack.class.format.error", System.getProperty("com.sun.java.util.jar.pack.class.format.error", "pass"));
        properties.put("pack.effort", "5");
        String string = "intrinsic.properties";
        try {
            hashMap = PackerImpl.class.getResourceAsStream(string);
            Throwable object = null;
            try {
                if (hashMap == null) {
                    throw new RuntimeException(string + " cannot be loaded");
                }
                properties.load((InputStream)((Object)hashMap));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throw throwable;
            }
            finally {
                if (hashMap != null) {
                    if (object != null) {
                        try {
                            ((InputStream)((Object)hashMap)).close();
                        }
                        catch (Throwable throwable) {
                            object.addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)((Object)hashMap)).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        for (Map.Entry entry : properties.entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            if (!string2.startsWith("attribute.")) continue;
            entry.setValue(Attribute.normalizeLayoutString(string3));
        }
        hashMap = new HashMap<Object, Object>(properties);
        defaultProps = hashMap;
    }

    private static class Beans {
        private static final Class<?> propertyChangeListenerClass = Beans.getClass("java.beans.PropertyChangeListener");
        private static final Class<?> propertyChangeEventClass = Beans.getClass("java.beans.PropertyChangeEvent");
        private static final Method propertyChangeMethod = Beans.getMethod(propertyChangeListenerClass, "propertyChange", propertyChangeEventClass);
        private static final Constructor<?> propertyEventCtor = Beans.getConstructor(propertyChangeEventClass, Object.class, String.class, Object.class, Object.class);

        private Beans() {
        }

        private static Class<?> getClass(String string) {
            try {
                return Class.forName(string, true, Beans.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        private static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... classArray) {
            try {
                return clazz == null ? null : clazz.getDeclaredConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError((Object)noSuchMethodException);
            }
        }

        private static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
            try {
                return clazz == null ? null : clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError((Object)noSuchMethodException);
            }
        }

        static boolean isBeansPresent() {
            return propertyChangeListenerClass != null && propertyChangeEventClass != null;
        }

        static boolean isPropertyChangeListener(Object object) {
            if (propertyChangeListenerClass == null) {
                return false;
            }
            return propertyChangeListenerClass.isInstance(object);
        }

        static Object newPropertyChangeEvent(Object object, String string, Object object2, Object object3) {
            try {
                return propertyEventCtor.newInstance(object, string, object2, object3);
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new AssertionError((Object)reflectiveOperationException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new AssertionError((Object)invocationTargetException);
            }
        }

        static void invokePropertyChange(Object object, Object object2) {
            try {
                propertyChangeMethod.invoke(object, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new AssertionError((Object)invocationTargetException);
            }
        }
    }
}

