/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.NoSuchElementException;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;

public final class OptionalDouble {
    private static final OptionalDouble EMPTY = new OptionalDouble();
    private final boolean isPresent;
    private final double value;

    private OptionalDouble() {
        this.isPresent = false;
        this.value = Double.NaN;
    }

    public static OptionalDouble empty() {
        return EMPTY;
    }

    private OptionalDouble(double d) {
        this.isPresent = true;
        this.value = d;
    }

    public static OptionalDouble of(double d) {
        return new OptionalDouble(d);
    }

    public double getAsDouble() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void ifPresent(DoubleConsumer doubleConsumer) {
        if (this.isPresent) {
            doubleConsumer.accept(this.value);
        }
    }

    public double orElse(double d) {
        return this.isPresent ? this.value : d;
    }

    public double orElseGet(DoubleSupplier doubleSupplier) {
        return this.isPresent ? this.value : doubleSupplier.getAsDouble();
    }

    public <X extends Throwable> double orElseThrow(Supplier<X> supplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)supplier.get();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OptionalDouble)) {
            return false;
        }
        OptionalDouble optionalDouble = (OptionalDouble)object;
        return this.isPresent && optionalDouble.isPresent ? Double.compare(this.value, optionalDouble.value) == 0 : this.isPresent == optionalDouble.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? Double.hashCode(this.value) : 0;
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalDouble[%s]", this.value) : "OptionalDouble.empty";
    }
}

