/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.gsskerb;

import com.sun.security.sasl.gsskerb.GssKrb5Client;
import com.sun.security.sasl.gsskerb.GssKrb5Server;
import com.sun.security.sasl.util.PolicyUtils;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public final class FactoryImpl
implements SaslClientFactory,
SaslServerFactory {
    private static final String[] myMechs = new String[]{"GSSAPI"};
    private static final int[] mechPolicies = new int[]{19};
    private static final int GSS_KERB_V5 = 0;

    @Override
    public SaslClient createSaslClient(String[] stringArray, String string, String string2, String string3, Map<String, ?> map, CallbackHandler callbackHandler) throws SaslException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(myMechs[0]) || !PolicyUtils.checkPolicy(mechPolicies[0], map)) continue;
            return new GssKrb5Client(string, string2, string3, map, callbackHandler);
        }
        return null;
    }

    @Override
    public SaslServer createSaslServer(String string, String string2, String string3, Map<String, ?> map, CallbackHandler callbackHandler) throws SaslException {
        if (string.equals(myMechs[0]) && PolicyUtils.checkPolicy(mechPolicies[0], map)) {
            if (callbackHandler == null) {
                throw new SaslException("Callback handler with support for AuthorizeCallback required");
            }
            return new GssKrb5Server(string2, string3, map, callbackHandler);
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> map) {
        return PolicyUtils.filterMechs(myMechs, mechPolicies, map);
    }
}

