/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.ARCFOURCipher;
import com.sun.crypto.provider.CipherCore;
import com.sun.crypto.provider.DESedeCrypt;
import com.sun.crypto.provider.RC2Crypt;
import com.sun.crypto.provider.SunJCE;
import com.sun.crypto.provider.SymmetricCipher;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class PKCS12PBECipherCore {
    private CipherCore cipher;
    private int blockSize;
    private int keySize;
    private String algo = null;
    private String pbeAlgo = null;
    private byte[] salt = null;
    private int iCount = 0;
    private static final int DEFAULT_SALT_LENGTH = 20;
    private static final int DEFAULT_COUNT = 1024;
    static final int CIPHER_KEY = 1;
    static final int CIPHER_IV = 2;
    static final int MAC_KEY = 3;

    static byte[] derive(char[] cArray, byte[] byArray, int n, int n2, int n3) {
        return PKCS12PBECipherCore.derive(cArray, byArray, n, n2, n3, "SHA-1", 64);
    }

    static byte[] derive(char[] cArray, byte[] byArray, int n, int n2, int n3, String string, int n4) {
        int n5 = cArray.length * 2;
        if (n5 == 2 && cArray[0] == '\u0000') {
            cArray = new char[]{};
            n5 = 0;
        } else {
            n5 += 2;
        }
        byte[] byArray2 = new byte[n5];
        int n6 = 0;
        int n7 = 0;
        while (n6 < cArray.length) {
            byArray2[n7] = (byte)(cArray[n6] >>> 8 & 0xFF);
            byArray2[n7 + 1] = (byte)(cArray[n6] & 0xFF);
            ++n6;
            n7 += 2;
        }
        byte[] byArray3 = new byte[n2];
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            int n8 = n4;
            int n9 = messageDigest.getDigestLength();
            int n10 = PKCS12PBECipherCore.roundup(n2, n9) / n9;
            byte[] byArray4 = new byte[n8];
            int n11 = PKCS12PBECipherCore.roundup(byArray.length, n8);
            int n12 = PKCS12PBECipherCore.roundup(byArray2.length, n8);
            byte[] byArray5 = new byte[n11 + n12];
            Arrays.fill(byArray4, (byte)n3);
            PKCS12PBECipherCore.concat(byArray, byArray5, 0, n11);
            PKCS12PBECipherCore.concat(byArray2, byArray5, n11, n12);
            Arrays.fill(byArray2, (byte)0);
            byte[] byArray6 = new byte[n8];
            byte[] byArray7 = new byte[n8];
            int n13 = 0;
            while (true) {
                messageDigest.update(byArray4);
                messageDigest.update(byArray5);
                byte[] byArray8 = messageDigest.digest();
                for (int i = 1; i < n; ++i) {
                    byArray8 = messageDigest.digest(byArray8);
                }
                System.arraycopy(byArray8, 0, byArray3, n9 * n13, Math.min(n2, n9));
                if (n13 + 1 != n10) {
                    PKCS12PBECipherCore.concat(byArray8, byArray6, 0, byArray6.length);
                    BigInteger bigInteger = new BigInteger(1, byArray6).add(BigInteger.ONE);
                    for (int i = 0; i < byArray5.length; i += n8) {
                        if (byArray7.length != n8) {
                            byArray7 = new byte[n8];
                        }
                        System.arraycopy(byArray5, i, byArray7, 0, n8);
                        BigInteger bigInteger2 = new BigInteger(1, byArray7);
                        bigInteger2 = bigInteger2.add(bigInteger);
                        byArray7 = bigInteger2.toByteArray();
                        int n14 = byArray7.length - n8;
                        if (n14 >= 0) {
                            System.arraycopy(byArray7, n14, byArray5, i, n8);
                            continue;
                        }
                        if (n14 >= 0) continue;
                        Arrays.fill(byArray5, i, i + -n14, (byte)0);
                        System.arraycopy(byArray7, 0, byArray5, i + -n14, byArray7.length);
                    }
                    ++n13;
                    n2 -= n9;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("internal error: " + exception);
        }
        return byArray3;
    }

    private static int roundup(int n, int n2) {
        return (n + (n2 - 1)) / n2 * n2;
    }

    private static void concat(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (byArray.length == 0) {
            return;
        }
        int n3 = n2 / byArray.length;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            System.arraycopy(byArray, 0, byArray2, n5 + n, byArray.length);
            ++n4;
            n5 += byArray.length;
        }
        System.arraycopy(byArray, 0, byArray2, n5 + n, n2 - n5);
    }

    PKCS12PBECipherCore(String string, int n) throws NoSuchAlgorithmException {
        this.algo = string;
        if (this.algo.equals("RC4")) {
            this.pbeAlgo = "PBEWithSHA1AndRC4_" + n * 8;
        } else {
            SymmetricCipher symmetricCipher = null;
            if (this.algo.equals("DESede")) {
                symmetricCipher = new DESedeCrypt();
                this.pbeAlgo = "PBEWithSHA1AndDESede";
            } else if (this.algo.equals("RC2")) {
                symmetricCipher = new RC2Crypt();
                this.pbeAlgo = "PBEWithSHA1AndRC2_" + n * 8;
            } else {
                throw new NoSuchAlgorithmException("No Cipher implementation for PBEWithSHA1And" + this.algo);
            }
            this.blockSize = symmetricCipher.getBlockSize();
            this.cipher = new CipherCore(symmetricCipher, this.blockSize);
            this.cipher.setMode("CBC");
            try {
                this.cipher.setPadding("PKCS5Padding");
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                // empty catch block
            }
        }
        this.keySize = n;
    }

    void implSetMode(String string) throws NoSuchAlgorithmException {
        if (string != null && !string.equalsIgnoreCase("CBC")) {
            throw new NoSuchAlgorithmException("Invalid cipher mode: " + string);
        }
    }

    void implSetPadding(String string) throws NoSuchPaddingException {
        if (string != null && !string.equalsIgnoreCase("PKCS5Padding")) {
            throw new NoSuchPaddingException("Invalid padding scheme: " + string);
        }
    }

    int implGetBlockSize() {
        return this.blockSize;
    }

    int implGetOutputSize(int n) {
        return this.cipher.getOutputSize(n);
    }

    byte[] implGetIV() {
        return this.cipher.getIV();
    }

    AlgorithmParameters implGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        if (this.salt == null) {
            this.salt = new byte[20];
            SunJCE.getRandom().nextBytes(this.salt);
            this.iCount = 1024;
        }
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(this.salt, this.iCount);
        try {
            algorithmParameters = AlgorithmParameters.getInstance(this.pbeAlgo, SunJCE.getInstance());
            algorithmParameters.init(pBEParameterSpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("SunJCE provider is not configured properly");
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException("PBEParameterSpec not supported");
        }
        return algorithmParameters;
    }

    void implInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.implInit(n, key, algorithmParameterSpec, secureRandom, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void implInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom, CipherSpi cipherSpi) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object;
        char[] cArray;
        block28: {
            block29: {
                block31: {
                    block30: {
                        block27: {
                            cArray = null;
                            this.salt = null;
                            this.iCount = 0;
                            if (!(key instanceof PBEKey)) break block27;
                            object = (PBEKey)key;
                            cArray = object.getPassword();
                            this.salt = object.getSalt();
                            this.iCount = object.getIterationCount();
                            break block28;
                        }
                        if (!(key instanceof SecretKey)) break block29;
                        if (!key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3)) break block30;
                        byte[] byArray = key.getEncoded();
                        object = byArray;
                        if (byArray != null) break block31;
                    }
                    throw new InvalidKeyException("Missing password");
                }
                cArray = new char[((Object)object).length];
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = (char)(object[i] & 0x7F);
                }
                Arrays.fill((byte[])object, (byte)0);
                break block28;
            }
            throw new InvalidKeyException("SecretKey of PBE type required");
        }
        try {
            if (!(n != 2 && n != 4 || algorithmParameterSpec != null || this.salt != null && this.iCount != 0)) {
                throw new InvalidAlgorithmParameterException("Parameters missing");
            }
            if (algorithmParameterSpec == null) {
                if (this.salt == null) {
                    this.salt = new byte[20];
                    if (secureRandom != null) {
                        secureRandom.nextBytes(this.salt);
                    } else {
                        SunJCE.getRandom().nextBytes(this.salt);
                    }
                }
                if (this.iCount == 0) {
                    this.iCount = 1024;
                }
            } else {
                if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("PBEParameterSpec type required");
                }
                object = (PBEParameterSpec)algorithmParameterSpec;
                if (this.salt != null) {
                    if (!Arrays.equals(this.salt, ((PBEParameterSpec)object).getSalt())) {
                        throw new InvalidAlgorithmParameterException("Inconsistent value of salt between key and params");
                    }
                } else {
                    this.salt = ((PBEParameterSpec)object).getSalt();
                }
                if (this.iCount != 0) {
                    if (this.iCount != ((PBEParameterSpec)object).getIterationCount()) {
                        throw new InvalidAlgorithmParameterException("Different iteration count between key and params");
                    }
                } else {
                    this.iCount = ((PBEParameterSpec)object).getIterationCount();
                }
            }
            if (this.salt.length < 8) {
                throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
            }
            if (this.iCount <= 0) {
                throw new InvalidAlgorithmParameterException("IterationCount must be a positive number");
            }
            object = PKCS12PBECipherCore.derive(cArray, this.salt, this.iCount, this.keySize, 1);
            SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, this.algo);
            if (cipherSpi != null && cipherSpi instanceof ARCFOURCipher) {
                ((ARCFOURCipher)cipherSpi).engineInit(n, secretKeySpec, secureRandom);
            } else {
                byte[] byArray = PKCS12PBECipherCore.derive(cArray, this.salt, this.iCount, 8, 2);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray, 0, 8);
                this.cipher.init(n, (Key)secretKeySpec, ivParameterSpec, secureRandom);
            }
        }
        finally {
            Arrays.fill(cArray, '\u0000');
        }
    }

    void implInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.implInit(n, key, algorithmParameters, secureRandom, null);
    }

    void implInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom, CipherSpi cipherSpi) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEParameterSpec pBEParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                pBEParameterSpec = algorithmParameters.getParameterSpec(PBEParameterSpec.class);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("requires PBE parameters");
            }
        }
        this.implInit(n, key, pBEParameterSpec, secureRandom, cipherSpi);
    }

    void implInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.implInit(n, key, secureRandom, null);
    }

    void implInit(int n, Key key, SecureRandom secureRandom, CipherSpi cipherSpi) throws InvalidKeyException {
        try {
            this.implInit(n, key, (AlgorithmParameterSpec)null, secureRandom, cipherSpi);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("requires PBE parameters");
        }
    }

    byte[] implUpdate(byte[] byArray, int n, int n2) {
        return this.cipher.update(byArray, n, n2);
    }

    int implUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.cipher.update(byArray, n, n2, byArray2, n3);
    }

    byte[] implDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(byArray, n, n2);
    }

    int implDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(byArray, n, n2, byArray2, n3);
    }

    int implGetKeySize(Key key) throws InvalidKeyException {
        return this.keySize;
    }

    byte[] implWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.cipher.wrap(key);
    }

    Key implUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.cipher.unwrap(byArray, string, n);
    }

    public static final class PBEWithSHA1AndRC4_128
    extends CipherSpi {
        private static final int RC4_KEYSIZE = 16;
        private final PKCS12PBECipherCore core = new PKCS12PBECipherCore("RC4", 16);
        private final ARCFOURCipher cipher = new ARCFOURCipher();

        @Override
        protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
            return this.cipher.engineDoFinal(byArray, n, n2);
        }

        @Override
        protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
            return this.cipher.engineDoFinal(byArray, n, n2, byArray2, n3);
        }

        @Override
        protected int engineGetBlockSize() {
            return this.cipher.engineGetBlockSize();
        }

        @Override
        protected byte[] engineGetIV() {
            return this.cipher.engineGetIV();
        }

        @Override
        protected int engineGetKeySize(Key key) throws InvalidKeyException {
            return 16;
        }

        @Override
        protected int engineGetOutputSize(int n) {
            return this.cipher.engineGetOutputSize(n);
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return this.core.implGetParameters();
        }

        @Override
        protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(n, key, algorithmParameterSpec, secureRandom, (CipherSpi)this.cipher);
        }

        @Override
        protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(n, key, algorithmParameters, secureRandom, (CipherSpi)this.cipher);
        }

        @Override
        protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
            this.core.implInit(n, key, secureRandom, this.cipher);
        }

        @Override
        protected void engineSetMode(String string) throws NoSuchAlgorithmException {
            if (!string.equalsIgnoreCase("ECB")) {
                throw new NoSuchAlgorithmException("Unsupported mode " + string);
            }
        }

        @Override
        protected void engineSetPadding(String string) throws NoSuchPaddingException {
            if (!string.equalsIgnoreCase("NoPadding")) {
                throw new NoSuchPaddingException("Padding must be NoPadding");
            }
        }

        @Override
        protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
            return this.cipher.engineUnwrap(byArray, string, n);
        }

        @Override
        protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
            return this.cipher.engineUpdate(byArray, n, n2);
        }

        @Override
        protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
            return this.cipher.engineUpdate(byArray, n, n2, byArray2, n3);
        }

        @Override
        protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            return this.cipher.engineWrap(key);
        }
    }

    public static final class PBEWithSHA1AndRC4_40
    extends CipherSpi {
        private static final int RC4_KEYSIZE = 5;
        private final PKCS12PBECipherCore core = new PKCS12PBECipherCore("RC4", 5);
        private final ARCFOURCipher cipher = new ARCFOURCipher();

        @Override
        protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
            return this.cipher.engineDoFinal(byArray, n, n2);
        }

        @Override
        protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
            return this.cipher.engineDoFinal(byArray, n, n2, byArray2, n3);
        }

        @Override
        protected int engineGetBlockSize() {
            return this.cipher.engineGetBlockSize();
        }

        @Override
        protected byte[] engineGetIV() {
            return this.cipher.engineGetIV();
        }

        @Override
        protected int engineGetKeySize(Key key) throws InvalidKeyException {
            return 5;
        }

        @Override
        protected int engineGetOutputSize(int n) {
            return this.cipher.engineGetOutputSize(n);
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return this.core.implGetParameters();
        }

        @Override
        protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(n, key, algorithmParameterSpec, secureRandom, (CipherSpi)this.cipher);
        }

        @Override
        protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(n, key, algorithmParameters, secureRandom, (CipherSpi)this.cipher);
        }

        @Override
        protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
            this.core.implInit(n, key, secureRandom, this.cipher);
        }

        @Override
        protected void engineSetMode(String string) throws NoSuchAlgorithmException {
            if (!string.equalsIgnoreCase("ECB")) {
                throw new NoSuchAlgorithmException("Unsupported mode " + string);
            }
        }

        @Override
        protected void engineSetPadding(String string) throws NoSuchPaddingException {
            if (!string.equalsIgnoreCase("NoPadding")) {
                throw new NoSuchPaddingException("Padding must be NoPadding");
            }
        }

        @Override
        protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
            return this.cipher.engineUnwrap(byArray, string, n);
        }

        @Override
        protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
            return this.cipher.engineUpdate(byArray, n, n2);
        }

        @Override
        protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
            return this.cipher.engineUpdate(byArray, n, n2, byArray2, n3);
        }

        @Override
        protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            return this.cipher.engineWrap(key);
        }
    }

    public static final class PBEWithSHA1AndRC2_128
    extends CipherSpi {
        private final PKCS12PBECipherCore core = new PKCS12PBECipherCore("RC2", 16);

        @Override
        protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
            return this.core.implDoFinal(byArray, n, n2);
        }

        @Override
        protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
            return this.core.implDoFinal(byArray, n, n2, byArray2, n3);
        }

        @Override
        protected int engineGetBlockSize() {
            return this.core.implGetBlockSize();
        }

        @Override
        protected byte[] engineGetIV() {
            return this.core.implGetIV();
        }

        @Override
        protected int engineGetKeySize(Key key) throws InvalidKeyException {
            return this.core.implGetKeySize(key);
        }

        @Override
        protected int engineGetOutputSize(int n) {
            return this.core.implGetOutputSize(n);
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return this.core.implGetParameters();
        }

        @Override
        protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(n, key, algorithmParameterSpec, secureRandom);
        }

        @Override
        protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(n, key, algorithmParameters, secureRandom);
        }

        @Override
        protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
            this.core.implInit(n, key, secureRandom);
        }

        @Override
        protected void engineSetMode(String string) throws NoSuchAlgorithmException {
            this.core.implSetMode(string);
        }

        @Override
        protected void engineSetPadding(String string) throws NoSuchPaddingException {
            this.core.implSetPadding(string);
        }

        @Override
        protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
            return this.core.implUnwrap(byArray, string, n);
        }

        @Override
        protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
            return this.core.implUpdate(byArray, n, n2);
        }

        @Override
        protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
            return this.core.implUpdate(byArray, n, n2, byArray2, n3);
        }

        @Override
        protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            return this.core.implWrap(key);
        }
    }

    public static final class PBEWithSHA1AndRC2_40
    extends CipherSpi {
        private final PKCS12PBECipherCore core = new PKCS12PBECipherCore("RC2", 5);

        @Override
        protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
            return this.core.implDoFinal(byArray, n, n2);
        }

        @Override
        protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
            return this.core.implDoFinal(byArray, n, n2, byArray2, n3);
        }

        @Override
        protected int engineGetBlockSize() {
            return this.core.implGetBlockSize();
        }

        @Override
        protected byte[] engineGetIV() {
            return this.core.implGetIV();
        }

        @Override
        protected int engineGetKeySize(Key key) throws InvalidKeyException {
            return this.core.implGetKeySize(key);
        }

        @Override
        protected int engineGetOutputSize(int n) {
            return this.core.implGetOutputSize(n);
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return this.core.implGetParameters();
        }

        @Override
        protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(n, key, algorithmParameterSpec, secureRandom);
        }

        @Override
        protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(n, key, algorithmParameters, secureRandom);
        }

        @Override
        protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
            this.core.implInit(n, key, secureRandom);
        }

        @Override
        protected void engineSetMode(String string) throws NoSuchAlgorithmException {
            this.core.implSetMode(string);
        }

        @Override
        protected void engineSetPadding(String string) throws NoSuchPaddingException {
            this.core.implSetPadding(string);
        }

        @Override
        protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
            return this.core.implUnwrap(byArray, string, n);
        }

        @Override
        protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
            return this.core.implUpdate(byArray, n, n2);
        }

        @Override
        protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
            return this.core.implUpdate(byArray, n, n2, byArray2, n3);
        }

        @Override
        protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            return this.core.implWrap(key);
        }
    }

    public static final class PBEWithSHA1AndDESede
    extends CipherSpi {
        private final PKCS12PBECipherCore core = new PKCS12PBECipherCore("DESede", 24);

        @Override
        protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
            return this.core.implDoFinal(byArray, n, n2);
        }

        @Override
        protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
            return this.core.implDoFinal(byArray, n, n2, byArray2, n3);
        }

        @Override
        protected int engineGetBlockSize() {
            return this.core.implGetBlockSize();
        }

        @Override
        protected byte[] engineGetIV() {
            return this.core.implGetIV();
        }

        @Override
        protected int engineGetKeySize(Key key) throws InvalidKeyException {
            return this.core.implGetKeySize(key);
        }

        @Override
        protected int engineGetOutputSize(int n) {
            return this.core.implGetOutputSize(n);
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return this.core.implGetParameters();
        }

        @Override
        protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(n, key, algorithmParameterSpec, secureRandom);
        }

        @Override
        protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(n, key, algorithmParameters, secureRandom);
        }

        @Override
        protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
            this.core.implInit(n, key, secureRandom);
        }

        @Override
        protected void engineSetMode(String string) throws NoSuchAlgorithmException {
            this.core.implSetMode(string);
        }

        @Override
        protected void engineSetPadding(String string) throws NoSuchPaddingException {
            this.core.implSetPadding(string);
        }

        @Override
        protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
            return this.core.implUnwrap(byArray, string, n);
        }

        @Override
        protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
            return this.core.implUpdate(byArray, n, n2);
        }

        @Override
        protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
            return this.core.implUpdate(byArray, n, n2, byArray2, n3);
        }

        @Override
        protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            return this.core.implWrap(key);
        }
    }
}

