/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import sun.security.ssl.JsseJce;

final class HKDF {
    private final String hmacAlg;
    private final Mac hmacObj;
    private final int hmacLen;

    HKDF(String string) throws NoSuchAlgorithmException {
        Objects.requireNonNull(string, "Must provide underlying HKDF Digest algorithm.");
        this.hmacAlg = "Hmac" + string.replace("-", "");
        this.hmacObj = JsseJce.getMac(this.hmacAlg);
        this.hmacLen = this.hmacObj.getMacLength();
    }

    SecretKey extract(SecretKey secretKey, SecretKey secretKey2, String string) throws InvalidKeyException {
        if (secretKey == null) {
            secretKey = new SecretKeySpec(new byte[this.hmacLen], "HKDF-Salt");
        }
        this.hmacObj.init(secretKey);
        return new SecretKeySpec(this.hmacObj.doFinal(secretKey2.getEncoded()), string);
    }

    SecretKey extract(byte[] byArray, SecretKey secretKey, String string) throws InvalidKeyException {
        if (byArray == null) {
            byArray = new byte[this.hmacLen];
        }
        return this.extract(new SecretKeySpec(byArray, "HKDF-Salt"), secretKey, string);
    }

    SecretKey expand(SecretKey secretKey, byte[] byArray, int n, String string) throws InvalidKeyException {
        Objects.requireNonNull(secretKey, "A null PRK is not allowed.");
        if (n > 255 * this.hmacLen) {
            throw new IllegalArgumentException("Requested output length exceeds maximum length allowed for HKDF expansion");
        }
        this.hmacObj.init(secretKey);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        int n2 = (n + this.hmacLen - 1) / this.hmacLen;
        byte[] byArray2 = new byte[n2 * this.hmacLen];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            try {
                this.hmacObj.update(byArray2, Math.max(0, n3 - this.hmacLen), n4);
                this.hmacObj.update(byArray);
                this.hmacObj.update((byte)(i + 1));
                this.hmacObj.doFinal(byArray2, n3);
                n4 = this.hmacLen;
                n3 += this.hmacLen;
                continue;
            }
            catch (ShortBufferException shortBufferException) {
                throw new RuntimeException(shortBufferException);
            }
        }
        return new SecretKeySpec(byArray2, 0, n, string);
    }
}

