/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthMenuItemLayoutHelper;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import sun.swing.MenuItemLayoutHelper;

public class SynthMenuItemUI
extends BasicMenuItemUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private SynthStyle accStyle;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthMenuItemUI();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        JComponent jComponent2 = MenuItemLayoutHelper.getMenuItemParent((JMenuItem)jComponent);
        if (jComponent2 != null) {
            jComponent2.putClientProperty(SynthMenuItemLayoutHelper.MAX_ACC_OR_ARROW_WIDTH, null);
        }
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.menuItem);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.menuItem.addPropertyChangeListener(this);
    }

    private void updateStyle(JMenuItem jMenuItem) {
        Object object;
        SynthContext synthContext = this.getContext((JComponent)jMenuItem, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (synthStyle != this.style) {
            object = this.getPropertyPrefix();
            Object object2 = this.style.get(synthContext, (String)object + ".textIconGap");
            if (object2 != null) {
                LookAndFeel.installProperty(jMenuItem, "iconTextGap", object2);
            }
            this.defaultTextIconGap = jMenuItem.getIconTextGap();
            if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
                Insets insets = (Insets)this.style.get(synthContext, (String)object + ".margin");
                if (insets == null) {
                    insets = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
                }
                this.menuItem.setMargin(insets);
            }
            this.acceleratorDelimiter = this.style.getString(synthContext, (String)object + ".acceleratorDelimiter", "+");
            this.arrowIcon = this.style.getIcon(synthContext, (String)object + ".arrowIcon");
            this.checkIcon = this.style.getIcon(synthContext, (String)object + ".checkIcon");
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
        object = this.getContext(jMenuItem, Region.MENU_ITEM_ACCELERATOR, 1);
        this.accStyle = SynthLookAndFeel.updateStyle((SynthContext)object, this);
        ((SynthContext)object).dispose();
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.menuItem, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        SynthContext synthContext2 = this.getContext(this.menuItem, Region.MENU_ITEM_ACCELERATOR, 1);
        this.accStyle.uninstallDefaults(synthContext2);
        synthContext2.dispose();
        this.accStyle = null;
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removePropertyChangeListener(this);
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(jComponent, this.style, n);
    }

    SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n) {
        return SynthContext.getContext(jComponent, region, this.accStyle, n);
    }

    private int getComponentState(JComponent jComponent) {
        int n = !jComponent.isEnabled() ? 8 : (this.menuItem.isArmed() ? 2 : SynthLookAndFeel.getComponentState(jComponent));
        if (this.menuItem.isSelected()) {
            n |= 0x200;
        }
        return n;
    }

    private int getComponentState(JComponent jComponent, Region region) {
        return this.getComponentState(jComponent);
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthContext synthContext2 = this.getContext(jComponent, Region.MENU_ITEM_ACCELERATOR);
        Dimension dimension = SynthGraphicsUtils.getPreferredMenuItemSize(synthContext, synthContext2, jComponent, icon, icon2, n, this.acceleratorDelimiter, MenuItemLayoutHelper.useCheckAndArrow(this.menuItem), this.getPropertyPrefix());
        synthContext.dispose();
        synthContext2.dispose();
        return dimension;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paintBackground(synthContext, graphics, jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        SynthContext synthContext2 = this.getContext((JComponent)this.menuItem, Region.MENU_ITEM_ACCELERATOR);
        String string = this.getPropertyPrefix();
        Icon icon = this.style.getIcon(synthContext, string + ".checkIcon");
        Icon icon2 = this.style.getIcon(synthContext, string + ".arrowIcon");
        SynthGraphicsUtils.paint(synthContext, synthContext2, graphics, icon, icon2, this.acceleratorDelimiter, this.defaultTextIconGap, this.getPropertyPrefix());
        synthContext2.dispose();
    }

    void paintBackground(SynthContext synthContext, Graphics graphics, JComponent jComponent) {
        SynthGraphicsUtils.paintBackground(synthContext, graphics, jComponent);
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintMenuItemBorder(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JMenuItem)propertyChangeEvent.getSource());
        }
    }
}

