/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.Date;
import sun.misc.HexDumpEncoder;
import sun.security.pkcs.SignerInfo;
import sun.security.pkcs.SigningCertificateInfo;
import sun.security.util.Debug;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.CertificateExtensions;

public class PKCS9Attribute
implements DerEncoder {
    private static final Debug debug = Debug.getInstance("jar");
    static final ObjectIdentifier[] PKCS9_OIDS = new ObjectIdentifier[18];
    private static final Class<?> BYTE_ARRAY_CLASS;
    public static final ObjectIdentifier EMAIL_ADDRESS_OID;
    public static final ObjectIdentifier UNSTRUCTURED_NAME_OID;
    public static final ObjectIdentifier CONTENT_TYPE_OID;
    public static final ObjectIdentifier MESSAGE_DIGEST_OID;
    public static final ObjectIdentifier SIGNING_TIME_OID;
    public static final ObjectIdentifier COUNTERSIGNATURE_OID;
    public static final ObjectIdentifier CHALLENGE_PASSWORD_OID;
    public static final ObjectIdentifier UNSTRUCTURED_ADDRESS_OID;
    public static final ObjectIdentifier EXTENDED_CERTIFICATE_ATTRIBUTES_OID;
    public static final ObjectIdentifier ISSUER_SERIALNUMBER_OID;
    public static final ObjectIdentifier EXTENSION_REQUEST_OID;
    public static final ObjectIdentifier SIGNING_CERTIFICATE_OID;
    public static final ObjectIdentifier SIGNATURE_TIMESTAMP_TOKEN_OID;
    private static final Byte[][] PKCS9_VALUE_TAGS;
    private static final Class<?>[] VALUE_CLASSES;
    private static final boolean[] SINGLE_VALUED;
    private ObjectIdentifier oid;
    private int index;
    private Object value;

    public PKCS9Attribute(ObjectIdentifier objectIdentifier, Object object) throws IllegalArgumentException {
        this.init(objectIdentifier, object);
    }

    private void init(ObjectIdentifier objectIdentifier, Object object) throws IllegalArgumentException {
        Class<?> clazz;
        this.oid = objectIdentifier;
        this.index = PKCS9Attribute.indexOf(objectIdentifier, PKCS9_OIDS, 1);
        Class<?> clazz2 = clazz = this.index == -1 ? BYTE_ARRAY_CLASS : VALUE_CLASSES[this.index];
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("Wrong value class  for attribute " + objectIdentifier + " constructing PKCS9Attribute; was " + object.getClass().toString() + ", should be " + clazz.toString());
        }
        this.value = object;
    }

    public PKCS9Attribute(DerValue derValue) throws IOException {
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derInputStream.available() != 0) {
            throw new IOException("Excess data parsing PKCS9Attribute");
        }
        if (derValueArray.length != 2) {
            throw new IOException("PKCS9Attribute doesn't have two components");
        }
        this.oid = derValueArray[0].getOID();
        byte[] byArray = derValueArray[1].toByteArray();
        DerValue[] derValueArray2 = new DerInputStream(byArray).getSet(1);
        this.index = PKCS9Attribute.indexOf(this.oid, PKCS9_OIDS, 1);
        if (this.index == -1) {
            if (debug != null) {
                debug.println("Unsupported signer attribute: " + this.oid);
            }
            this.value = byArray;
            return;
        }
        if (SINGLE_VALUED[this.index] && derValueArray2.length > 1) {
            this.throwSingleValuedException();
        }
        for (int i = 0; i < derValueArray2.length; ++i) {
            Byte by = new Byte(derValueArray2[i].tag);
            if (PKCS9Attribute.indexOf(by, PKCS9_VALUE_TAGS[this.index], 0) != -1) continue;
            this.throwTagException(by);
        }
        switch (this.index) {
            case 1: 
            case 2: 
            case 8: {
                String[] stringArray = new String[derValueArray2.length];
                for (int i = 0; i < derValueArray2.length; ++i) {
                    stringArray[i] = derValueArray2[i].getAsString();
                }
                this.value = stringArray;
                break;
            }
            case 3: {
                this.value = derValueArray2[0].getOID();
                break;
            }
            case 4: {
                this.value = derValueArray2[0].getOctetString();
                break;
            }
            case 5: {
                this.value = new DerInputStream(derValueArray2[0].toByteArray()).getUTCTime();
                break;
            }
            case 6: {
                SignerInfo[] signerInfoArray = new SignerInfo[derValueArray2.length];
                for (int i = 0; i < derValueArray2.length; ++i) {
                    signerInfoArray[i] = new SignerInfo(derValueArray2[i].toDerInputStream());
                }
                this.value = signerInfoArray;
                break;
            }
            case 7: {
                this.value = derValueArray2[0].getAsString();
                break;
            }
            case 9: {
                throw new IOException("PKCS9 extended-certificate attribute not supported.");
            }
            case 10: {
                throw new IOException("PKCS9 IssuerAndSerialNumberattribute not supported.");
            }
            case 11: 
            case 12: {
                throw new IOException("PKCS9 RSA DSI attributes11 and 12, not supported.");
            }
            case 13: {
                throw new IOException("PKCS9 attribute #13 not supported.");
            }
            case 14: {
                this.value = new CertificateExtensions(new DerInputStream(derValueArray2[0].toByteArray()));
                break;
            }
            case 15: {
                throw new IOException("PKCS9 SMIMECapability attribute not supported.");
            }
            case 16: {
                this.value = new SigningCertificateInfo(derValueArray2[0].toByteArray());
                break;
            }
            case 17: {
                this.value = derValueArray2[0].toByteArray();
                break;
            }
        }
    }

    @Override
    public void derEncode(OutputStream outputStream) throws IOException {
        String[] stringArray;
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOID(this.oid);
        switch (this.index) {
            case -1: {
                derOutputStream.write((byte[])this.value);
                break;
            }
            case 1: 
            case 2: {
                stringArray = (String[])this.value;
                DerEncoder[] derEncoderArray = new DerOutputStream[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    derEncoderArray[i] = new DerOutputStream();
                    ((DerOutputStream)derEncoderArray[i]).putIA5String(stringArray[i]);
                }
                derOutputStream.putOrderedSetOf((byte)49, derEncoderArray);
                break;
            }
            case 3: {
                stringArray = new DerOutputStream();
                stringArray.putOID((ObjectIdentifier)this.value);
                derOutputStream.write((byte)49, stringArray.toByteArray());
                break;
            }
            case 4: {
                stringArray = new DerOutputStream();
                stringArray.putOctetString((byte[])this.value);
                derOutputStream.write((byte)49, stringArray.toByteArray());
                break;
            }
            case 5: {
                stringArray = new DerOutputStream();
                stringArray.putUTCTime((Date)this.value);
                derOutputStream.write((byte)49, stringArray.toByteArray());
                break;
            }
            case 6: {
                derOutputStream.putOrderedSetOf((byte)49, (DerEncoder[])this.value);
                break;
            }
            case 7: {
                stringArray = new DerOutputStream();
                stringArray.putPrintableString((String)this.value);
                derOutputStream.write((byte)49, stringArray.toByteArray());
                break;
            }
            case 8: {
                stringArray = (String[])this.value;
                DerEncoder[] derEncoderArray = new DerOutputStream[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    derEncoderArray[i] = new DerOutputStream();
                    ((DerOutputStream)derEncoderArray[i]).putPrintableString(stringArray[i]);
                }
                derOutputStream.putOrderedSetOf((byte)49, derEncoderArray);
                break;
            }
            case 9: {
                throw new IOException("PKCS9 extended-certificate attribute not supported.");
            }
            case 10: {
                throw new IOException("PKCS9 IssuerAndSerialNumberattribute not supported.");
            }
            case 11: 
            case 12: {
                throw new IOException("PKCS9 RSA DSI attributes11 and 12, not supported.");
            }
            case 13: {
                throw new IOException("PKCS9 attribute #13 not supported.");
            }
            case 14: {
                stringArray = new DerOutputStream();
                CertificateExtensions certificateExtensions = (CertificateExtensions)this.value;
                try {
                    certificateExtensions.encode((OutputStream)stringArray, true);
                }
                catch (CertificateException certificateException) {
                    throw new IOException(certificateException.toString());
                }
                derOutputStream.write((byte)49, stringArray.toByteArray());
                break;
            }
            case 15: {
                throw new IOException("PKCS9 attribute #15 not supported.");
            }
            case 16: {
                throw new IOException("PKCS9 SigningCertificate attribute not supported.");
            }
            case 17: {
                derOutputStream.write((byte)49, (byte[])this.value);
                break;
            }
        }
        stringArray = new DerOutputStream();
        stringArray.write((byte)48, derOutputStream.toByteArray());
        outputStream.write(stringArray.toByteArray());
    }

    public boolean isKnown() {
        return this.index != -1;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isSingleValued() {
        return this.index == -1 || SINGLE_VALUED[this.index];
    }

    public ObjectIdentifier getOID() {
        return this.oid;
    }

    public String getName() {
        String string = this.oid.toString();
        KnownOIDs knownOIDs = KnownOIDs.findMatch(string);
        return knownOIDs == null ? string : knownOIDs.stdName();
    }

    public static ObjectIdentifier getOID(String string) {
        KnownOIDs knownOIDs = KnownOIDs.findMatch(string);
        if (knownOIDs != null) {
            return ObjectIdentifier.of(knownOIDs);
        }
        return null;
    }

    public static String getName(ObjectIdentifier objectIdentifier) {
        return KnownOIDs.findMatch(objectIdentifier.toString()).stdName();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("[");
        if (this.index == -1) {
            stringBuffer.append(this.oid.toString());
        } else {
            stringBuffer.append(PKCS9Attribute.getName(this.oid));
        }
        stringBuffer.append(": ");
        if (this.index == -1 || SINGLE_VALUED[this.index]) {
            if (this.value instanceof byte[]) {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                stringBuffer.append(hexDumpEncoder.encodeBuffer((byte[])this.value));
            } else {
                stringBuffer.append(this.value.toString());
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        boolean bl = true;
        Object[] objectArray = (Object[])this.value;
        for (int i = 0; i < objectArray.length; ++i) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(objectArray[i].toString());
        }
        return stringBuffer.toString();
    }

    static int indexOf(Object object, Object[] objectArray, int n) {
        for (int i = n; i < objectArray.length; ++i) {
            if (!object.equals(objectArray[i])) continue;
            return i;
        }
        return -1;
    }

    private void throwSingleValuedException() throws IOException {
        throw new IOException("Single-value attribute " + this.oid + " (" + this.getName() + ") has multiple values.");
    }

    private void throwTagException(Byte by) throws IOException {
        Byte[] byteArray = PKCS9_VALUE_TAGS[this.index];
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("Value of attribute ");
        stringBuffer.append(this.oid.toString());
        stringBuffer.append(" (");
        stringBuffer.append(this.getName());
        stringBuffer.append(") has wrong tag: ");
        stringBuffer.append(by.toString());
        stringBuffer.append(".  Expected tags: ");
        stringBuffer.append(byteArray[0].toString());
        for (int i = 1; i < byteArray.length; ++i) {
            stringBuffer.append(", ");
            stringBuffer.append(byteArray[i].toString());
        }
        stringBuffer.append(".");
        throw new IOException(stringBuffer.toString());
    }

    static {
        PKCS9Attribute.PKCS9_OIDS[15] = null;
        PKCS9Attribute.PKCS9_OIDS[13] = null;
        PKCS9Attribute.PKCS9_OIDS[12] = null;
        PKCS9Attribute.PKCS9_OIDS[11] = null;
        PKCS9Attribute.PKCS9_OIDS[0] = null;
        try {
            BYTE_ARRAY_CLASS = Class.forName("[B");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError(classNotFoundException.toString());
        }
        EMAIL_ADDRESS_OID = PKCS9Attribute.PKCS9_OIDS[1] = ObjectIdentifier.of(KnownOIDs.EmailAddress);
        UNSTRUCTURED_NAME_OID = PKCS9Attribute.PKCS9_OIDS[2] = ObjectIdentifier.of(KnownOIDs.UnstructuredName);
        CONTENT_TYPE_OID = PKCS9Attribute.PKCS9_OIDS[3] = ObjectIdentifier.of(KnownOIDs.ContentType);
        MESSAGE_DIGEST_OID = PKCS9Attribute.PKCS9_OIDS[4] = ObjectIdentifier.of(KnownOIDs.MessageDigest);
        SIGNING_TIME_OID = PKCS9Attribute.PKCS9_OIDS[5] = ObjectIdentifier.of(KnownOIDs.SigningTime);
        COUNTERSIGNATURE_OID = PKCS9Attribute.PKCS9_OIDS[6] = ObjectIdentifier.of(KnownOIDs.CounterSignature);
        CHALLENGE_PASSWORD_OID = PKCS9Attribute.PKCS9_OIDS[7] = ObjectIdentifier.of(KnownOIDs.ChallengePassword);
        UNSTRUCTURED_ADDRESS_OID = PKCS9Attribute.PKCS9_OIDS[8] = ObjectIdentifier.of(KnownOIDs.UnstructuredAddress);
        EXTENDED_CERTIFICATE_ATTRIBUTES_OID = PKCS9Attribute.PKCS9_OIDS[9] = ObjectIdentifier.of(KnownOIDs.ExtendedCertificateAttributes);
        ISSUER_SERIALNUMBER_OID = PKCS9Attribute.PKCS9_OIDS[10] = ObjectIdentifier.of(KnownOIDs.IssuerAndSerialNumber);
        EXTENSION_REQUEST_OID = PKCS9Attribute.PKCS9_OIDS[14] = ObjectIdentifier.of(KnownOIDs.ExtensionRequest);
        SIGNING_CERTIFICATE_OID = PKCS9Attribute.PKCS9_OIDS[16] = ObjectIdentifier.of(KnownOIDs.SigningCertificate);
        SIGNATURE_TIMESTAMP_TOKEN_OID = PKCS9Attribute.PKCS9_OIDS[17] = ObjectIdentifier.of(KnownOIDs.SignatureTimestampToken);
        PKCS9_VALUE_TAGS = new Byte[][]{null, {new Byte(22)}, {new Byte(22), new Byte(19)}, {new Byte(6)}, {new Byte(4)}, {new Byte(23)}, {new Byte(48)}, {new Byte(19), new Byte(20)}, {new Byte(19), new Byte(20)}, {new Byte(49)}, {new Byte(48)}, null, null, null, {new Byte(48)}, {new Byte(48)}, {new Byte(48)}, {new Byte(48)}};
        VALUE_CLASSES = new Class[18];
        try {
            Class<?> clazz = Class.forName("[Ljava.lang.String;");
            PKCS9Attribute.VALUE_CLASSES[0] = null;
            PKCS9Attribute.VALUE_CLASSES[1] = clazz;
            PKCS9Attribute.VALUE_CLASSES[2] = clazz;
            PKCS9Attribute.VALUE_CLASSES[3] = Class.forName("sun.security.util.ObjectIdentifier");
            PKCS9Attribute.VALUE_CLASSES[4] = BYTE_ARRAY_CLASS;
            PKCS9Attribute.VALUE_CLASSES[5] = Class.forName("java.util.Date");
            PKCS9Attribute.VALUE_CLASSES[6] = Class.forName("[Lsun.security.pkcs.SignerInfo;");
            PKCS9Attribute.VALUE_CLASSES[7] = Class.forName("java.lang.String");
            PKCS9Attribute.VALUE_CLASSES[8] = clazz;
            PKCS9Attribute.VALUE_CLASSES[9] = null;
            PKCS9Attribute.VALUE_CLASSES[10] = null;
            PKCS9Attribute.VALUE_CLASSES[11] = null;
            PKCS9Attribute.VALUE_CLASSES[12] = null;
            PKCS9Attribute.VALUE_CLASSES[13] = null;
            PKCS9Attribute.VALUE_CLASSES[14] = Class.forName("sun.security.x509.CertificateExtensions");
            PKCS9Attribute.VALUE_CLASSES[15] = null;
            PKCS9Attribute.VALUE_CLASSES[16] = null;
            PKCS9Attribute.VALUE_CLASSES[17] = BYTE_ARRAY_CLASS;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError(classNotFoundException.toString());
        }
        SINGLE_VALUED = new boolean[]{false, false, false, true, true, true, false, true, false, false, true, false, false, false, true, true, true, true};
    }
}

