/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import sun.jvm.hotspot.jdi.PrimitiveValueImpl;

public class ShortValueImpl
extends PrimitiveValueImpl
implements ShortValue {
    private short value;

    ShortValueImpl(VirtualMachine aVm, short aValue) {
        super(aVm);
        this.value = aValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ShortValue) {
            return this.value == ((ShortValue)obj).value() && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.intValue();
    }

    @Override
    public int compareTo(ShortValue shortVal) {
        return this.value() - shortVal.value();
    }

    @Override
    public Type type() {
        return this.vm.theShortType();
    }

    @Override
    public short value() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return this.value != 0;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public char charValue() {
        return (char)this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    byte checkedByteValue() throws InvalidTypeException {
        if (this.value > 127 || this.value < -128) {
            throw new InvalidTypeException("Can't convert " + this.value + " to byte");
        }
        return super.checkedByteValue();
    }

    @Override
    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535 || this.value < 0) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    @Override
    public String toString() {
        return "" + this.value;
    }
}

