/*
 * Decompiled with CFR 0.152.
 */
package javax.smartcardio;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class CommandAPDU
implements Serializable {
    private static final long serialVersionUID = 398698301286670877L;
    private static final int MAX_APDU_SIZE = 65544;
    private byte[] apdu;
    private transient int nc;
    private transient int ne;
    private transient int dataOffset;

    public CommandAPDU(byte[] byArray) {
        this.apdu = (byte[])byArray.clone();
        this.parse();
    }

    public CommandAPDU(byte[] byArray, int n, int n2) {
        this.checkArrayBounds(byArray, n, n2);
        this.apdu = new byte[n2];
        System.arraycopy(byArray, n, this.apdu, 0, n2);
        this.parse();
    }

    private void checkArrayBounds(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Offset and length must not be negative");
        }
        if (byArray == null) {
            if (n != 0 && n2 != 0) {
                throw new IllegalArgumentException("offset and length must be 0 if array is null");
            }
        } else if (n > byArray.length - n2) {
            throw new IllegalArgumentException("Offset plus length exceed array size");
        }
    }

    public CommandAPDU(ByteBuffer byteBuffer) {
        this.apdu = new byte[byteBuffer.remaining()];
        byteBuffer.get(this.apdu);
        this.parse();
    }

    public CommandAPDU(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null, 0, 0, 0);
    }

    public CommandAPDU(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, null, 0, 0, n5);
    }

    public CommandAPDU(int n, int n2, int n3, int n4, byte[] byArray) {
        this(n, n2, n3, n4, byArray, 0, CommandAPDU.arrayLength(byArray), 0);
    }

    public CommandAPDU(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        this(n, n2, n3, n4, byArray, n5, n6, 0);
    }

    public CommandAPDU(int n, int n2, int n3, int n4, byte[] byArray, int n5) {
        this(n, n2, n3, n4, byArray, 0, CommandAPDU.arrayLength(byArray), n5);
    }

    private static int arrayLength(byte[] byArray) {
        return byArray != null ? byArray.length : 0;
    }

    private void parse() {
        if (this.apdu.length < 4) {
            throw new IllegalArgumentException("apdu must be at least 4 bytes long");
        }
        if (this.apdu.length == 4) {
            return;
        }
        int n = this.apdu[4] & 0xFF;
        if (this.apdu.length == 5) {
            this.ne = n == 0 ? 256 : n;
            return;
        }
        if (n != 0) {
            if (this.apdu.length == 5 + n) {
                this.nc = n;
                this.dataOffset = 5;
                return;
            }
            if (this.apdu.length == 6 + n) {
                this.nc = n;
                this.dataOffset = 5;
                int n2 = this.apdu[this.apdu.length - 1] & 0xFF;
                this.ne = n2 == 0 ? 256 : n2;
                return;
            }
            throw new IllegalArgumentException("Invalid APDU: length=" + this.apdu.length + ", b1=" + n);
        }
        if (this.apdu.length < 7) {
            throw new IllegalArgumentException("Invalid APDU: length=" + this.apdu.length + ", b1=" + n);
        }
        int n3 = (this.apdu[5] & 0xFF) << 8 | this.apdu[6] & 0xFF;
        if (this.apdu.length == 7) {
            this.ne = n3 == 0 ? 65536 : n3;
            return;
        }
        if (n3 == 0) {
            throw new IllegalArgumentException("Invalid APDU: length=" + this.apdu.length + ", b1=" + n + ", b2||b3=" + n3);
        }
        if (this.apdu.length == 7 + n3) {
            this.nc = n3;
            this.dataOffset = 7;
            return;
        }
        if (this.apdu.length != 9 + n3) {
            throw new IllegalArgumentException("Invalid APDU: length=" + this.apdu.length + ", b1=" + n + ", b2||b3=" + n3);
        }
        this.nc = n3;
        this.dataOffset = 7;
        int n4 = this.apdu.length - 2;
        int n5 = (this.apdu[n4] & 0xFF) << 8 | this.apdu[n4 + 1] & 0xFF;
        this.ne = n5 == 0 ? 65536 : n5;
    }

    public CommandAPDU(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6, int n7) {
        this.checkArrayBounds(byArray, n5, n6);
        if (n6 > 65535) {
            throw new IllegalArgumentException("dataLength is too large");
        }
        if (n7 < 0) {
            throw new IllegalArgumentException("ne must not be negative");
        }
        if (n7 > 65536) {
            throw new IllegalArgumentException("ne is too large");
        }
        this.ne = n7;
        this.nc = n6;
        if (n6 == 0) {
            if (n7 == 0) {
                this.apdu = new byte[4];
                this.setHeader(n, n2, n3, n4);
            } else if (n7 <= 256) {
                byte by = n7 != 256 ? (byte)n7 : (byte)0;
                this.apdu = new byte[5];
                this.setHeader(n, n2, n3, n4);
                this.apdu[4] = by;
            } else {
                byte by;
                byte by2;
                if (n7 == 65536) {
                    by2 = 0;
                    by = 0;
                } else {
                    by2 = (byte)(n7 >> 8);
                    by = (byte)n7;
                }
                this.apdu = new byte[7];
                this.setHeader(n, n2, n3, n4);
                this.apdu[5] = by2;
                this.apdu[6] = by;
            }
        } else if (n7 == 0) {
            if (n6 <= 255) {
                this.apdu = new byte[5 + n6];
                this.setHeader(n, n2, n3, n4);
                this.apdu[4] = (byte)n6;
                this.dataOffset = 5;
                System.arraycopy(byArray, n5, this.apdu, 5, n6);
            } else {
                this.apdu = new byte[7 + n6];
                this.setHeader(n, n2, n3, n4);
                this.apdu[4] = 0;
                this.apdu[5] = (byte)(n6 >> 8);
                this.apdu[6] = (byte)n6;
                this.dataOffset = 7;
                System.arraycopy(byArray, n5, this.apdu, 7, n6);
            }
        } else if (n6 <= 255 && n7 <= 256) {
            this.apdu = new byte[6 + n6];
            this.setHeader(n, n2, n3, n4);
            this.apdu[4] = (byte)n6;
            this.dataOffset = 5;
            System.arraycopy(byArray, n5, this.apdu, 5, n6);
            this.apdu[this.apdu.length - 1] = n7 != 256 ? (byte)n7 : (byte)0;
        } else {
            this.apdu = new byte[9 + n6];
            this.setHeader(n, n2, n3, n4);
            this.apdu[4] = 0;
            this.apdu[5] = (byte)(n6 >> 8);
            this.apdu[6] = (byte)n6;
            this.dataOffset = 7;
            System.arraycopy(byArray, n5, this.apdu, 7, n6);
            if (n7 != 65536) {
                int n8 = this.apdu.length - 2;
                this.apdu[n8] = (byte)(n7 >> 8);
                this.apdu[n8 + 1] = (byte)n7;
            }
        }
    }

    private void setHeader(int n, int n2, int n3, int n4) {
        this.apdu[0] = (byte)n;
        this.apdu[1] = (byte)n2;
        this.apdu[2] = (byte)n3;
        this.apdu[3] = (byte)n4;
    }

    public int getCLA() {
        return this.apdu[0] & 0xFF;
    }

    public int getINS() {
        return this.apdu[1] & 0xFF;
    }

    public int getP1() {
        return this.apdu[2] & 0xFF;
    }

    public int getP2() {
        return this.apdu[3] & 0xFF;
    }

    public int getNc() {
        return this.nc;
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.nc];
        System.arraycopy(this.apdu, this.dataOffset, byArray, 0, this.nc);
        return byArray;
    }

    public int getNe() {
        return this.ne;
    }

    public byte[] getBytes() {
        return (byte[])this.apdu.clone();
    }

    public String toString() {
        return "CommmandAPDU: " + this.apdu.length + " bytes, nc=" + this.nc + ", ne=" + this.ne;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CommandAPDU)) {
            return false;
        }
        CommandAPDU commandAPDU = (CommandAPDU)object;
        return Arrays.equals(this.apdu, commandAPDU.apdu);
    }

    public int hashCode() {
        return Arrays.hashCode(this.apdu);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.apdu = (byte[])objectInputStream.readUnshared();
        this.parse();
    }
}

