/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.NoSuchElementException;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public final class OptionalInt {
    private static final OptionalInt EMPTY = new OptionalInt();
    private final boolean isPresent;
    private final int value;

    private OptionalInt() {
        this.isPresent = false;
        this.value = 0;
    }

    public static OptionalInt empty() {
        return EMPTY;
    }

    private OptionalInt(int n) {
        this.isPresent = true;
        this.value = n;
    }

    public static OptionalInt of(int n) {
        return new OptionalInt(n);
    }

    public int getAsInt() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void ifPresent(IntConsumer intConsumer) {
        if (this.isPresent) {
            intConsumer.accept(this.value);
        }
    }

    public int orElse(int n) {
        return this.isPresent ? this.value : n;
    }

    public int orElseGet(IntSupplier intSupplier) {
        return this.isPresent ? this.value : intSupplier.getAsInt();
    }

    public <X extends Throwable> int orElseThrow(Supplier<X> supplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)supplier.get();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OptionalInt)) {
            return false;
        }
        OptionalInt optionalInt = (OptionalInt)object;
        return this.isPresent && optionalInt.isPresent ? this.value == optionalInt.value : this.isPresent == optionalInt.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? Integer.hashCode(this.value) : 0;
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalInt[%s]", this.value) : "OptionalInt.empty";
    }
}

