/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelInstrumentComparator;
import com.sun.media.sound.ModelPatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;

public class SimpleSoundbank
implements Soundbank {
    String name = "";
    String version = "";
    String vendor = "";
    String description = "";
    List<SoundbankResource> resources = new ArrayList<SoundbankResource>();
    List<Instrument> instruments = new ArrayList<Instrument>();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setVendor(String string) {
        this.vendor = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    @Override
    public SoundbankResource[] getResources() {
        return this.resources.toArray(new SoundbankResource[this.resources.size()]);
    }

    @Override
    public Instrument[] getInstruments() {
        Instrument[] instrumentArray = this.instruments.toArray(new Instrument[this.resources.size()]);
        Arrays.sort(instrumentArray, new ModelInstrumentComparator());
        return instrumentArray;
    }

    @Override
    public Instrument getInstrument(Patch patch) {
        int n = patch.getProgram();
        int n2 = patch.getBank();
        boolean bl = false;
        if (patch instanceof ModelPatch) {
            bl = ((ModelPatch)patch).isPercussion();
        }
        for (Instrument instrument : this.instruments) {
            Patch patch2 = instrument.getPatch();
            int n3 = patch2.getProgram();
            int n4 = patch2.getBank();
            if (n != n3 || n2 != n4) continue;
            boolean bl2 = false;
            if (patch2 instanceof ModelPatch) {
                bl2 = ((ModelPatch)patch2).isPercussion();
            }
            if (bl != bl2) continue;
            return instrument;
        }
        return null;
    }

    public void addResource(SoundbankResource soundbankResource) {
        if (soundbankResource instanceof Instrument) {
            this.instruments.add((Instrument)soundbankResource);
        } else {
            this.resources.add(soundbankResource);
        }
    }

    public void removeResource(SoundbankResource soundbankResource) {
        if (soundbankResource instanceof Instrument) {
            this.instruments.remove((Instrument)soundbankResource);
        } else {
            this.resources.remove(soundbankResource);
        }
    }

    public void addInstrument(Instrument instrument) {
        this.instruments.add(instrument);
    }

    public void removeInstrument(Instrument instrument) {
        this.instruments.remove(instrument);
    }

    public void addAllInstruments(Soundbank soundbank) {
        for (Instrument instrument : soundbank.getInstruments()) {
            this.addInstrument(instrument);
        }
    }

    public void removeAllInstruments(Soundbank soundbank) {
        for (Instrument instrument : soundbank.getInstruments()) {
            this.removeInstrument(instrument);
        }
    }
}

