/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.opto;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.ci.ciMethod;
import sun.jvm.hotspot.ci.ciObjectFactory;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.opto.CallNode;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class CallJavaNode
extends CallNode {
    private static AddressField methodField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("CallJavaNode");
        methodField = type.getAddressField("_method");
    }

    public CallJavaNode(Address addr) {
        super(addr);
    }

    public ciMethod method() {
        return (ciMethod)ciObjectFactory.getMetadata(methodField.getValue(this.getAddress()));
    }

    @Override
    public void dumpSpec(PrintStream out) {
        if (this.method() != null) {
            out.print(" " + this.method().method().externalNameAndSignature());
        }
        super.dumpSpec(out);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                CallJavaNode.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

