/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

public abstract class AtomicIntegerFieldUpdater<T> {
    @CallerSensitive
    public static <U> AtomicIntegerFieldUpdater<U> newUpdater(Class<U> clazz, String string) {
        return new AtomicIntegerFieldUpdaterImpl<U>(clazz, string, Reflection.getCallerClass());
    }

    protected AtomicIntegerFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, int var2, int var3);

    public abstract boolean weakCompareAndSet(T var1, int var2, int var3);

    public abstract void set(T var1, int var2);

    public abstract void lazySet(T var1, int var2);

    public abstract int get(T var1);

    public int getAndSet(T t, int n) {
        int n2;
        while (!this.compareAndSet(t, n2 = this.get(t), n)) {
        }
        return n2;
    }

    public int getAndIncrement(T t) {
        int n;
        int n2;
        while (!this.compareAndSet(t, n2 = this.get(t), n = n2 + 1)) {
        }
        return n2;
    }

    public int getAndDecrement(T t) {
        int n;
        int n2;
        while (!this.compareAndSet(t, n2 = this.get(t), n = n2 - 1)) {
        }
        return n2;
    }

    public int getAndAdd(T t, int n) {
        int n2;
        int n3;
        while (!this.compareAndSet(t, n3 = this.get(t), n2 = n3 + n)) {
        }
        return n3;
    }

    public int incrementAndGet(T t) {
        int n;
        int n2;
        while (!this.compareAndSet(t, n2 = this.get(t), n = n2 + 1)) {
        }
        return n;
    }

    public int decrementAndGet(T t) {
        int n;
        int n2;
        while (!this.compareAndSet(t, n2 = this.get(t), n = n2 - 1)) {
        }
        return n;
    }

    public int addAndGet(T t, int n) {
        int n2;
        int n3;
        while (!this.compareAndSet(t, n3 = this.get(t), n2 = n3 + n)) {
        }
        return n2;
    }

    public final int getAndUpdate(T t, IntUnaryOperator intUnaryOperator) {
        int n;
        int n2;
        while (!this.compareAndSet(t, n2 = this.get(t), n = intUnaryOperator.applyAsInt(n2))) {
        }
        return n2;
    }

    public final int updateAndGet(T t, IntUnaryOperator intUnaryOperator) {
        int n;
        int n2;
        while (!this.compareAndSet(t, n2 = this.get(t), n = intUnaryOperator.applyAsInt(n2))) {
        }
        return n;
    }

    public final int getAndAccumulate(T t, int n, IntBinaryOperator intBinaryOperator) {
        int n2;
        int n3;
        while (!this.compareAndSet(t, n3 = this.get(t), n2 = intBinaryOperator.applyAsInt(n3, n))) {
        }
        return n3;
    }

    public final int accumulateAndGet(T t, int n, IntBinaryOperator intBinaryOperator) {
        int n2;
        int n3;
        while (!this.compareAndSet(t, n3 = this.get(t), n2 = intBinaryOperator.applyAsInt(n3, n))) {
        }
        return n2;
    }

    private static final class AtomicIntegerFieldUpdaterImpl<T>
    extends AtomicIntegerFieldUpdater<T> {
        private static final Unsafe U = Unsafe.getUnsafe();
        private final long offset;
        private final Class<?> cclass;
        private final Class<T> tclass;

        AtomicIntegerFieldUpdaterImpl(final Class<T> clazz, final String string, Class<?> clazz2) {
            int n;
            Field field;
            try {
                field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                    @Override
                    public Field run() throws NoSuchFieldException {
                        return clazz.getDeclaredField(string);
                    }
                });
                n = field.getModifiers();
                ReflectUtil.ensureMemberAccess(clazz2, clazz, null, n);
                ClassLoader classLoader = clazz.getClassLoader();
                ClassLoader classLoader2 = clazz2.getClassLoader();
                if (!(classLoader2 == null || classLoader2 == classLoader || classLoader != null && AtomicIntegerFieldUpdaterImpl.isAncestor(classLoader, classLoader2))) {
                    ReflectUtil.checkPackageAccess(clazz);
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException(privilegedActionException.getException());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            if (field.getType() != Integer.TYPE) {
                throw new IllegalArgumentException("Must be integer type");
            }
            if (!Modifier.isVolatile(n)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(n) && clazz.isAssignableFrom(clazz2) && !AtomicIntegerFieldUpdaterImpl.isSamePackage(clazz, clazz2) ? clazz2 : clazz;
            this.tclass = clazz;
            this.offset = U.objectFieldOffset(field);
        }

        private static boolean isAncestor(ClassLoader classLoader, ClassLoader classLoader2) {
            ClassLoader classLoader3 = classLoader;
            do {
                if (classLoader2 != (classLoader3 = classLoader3.getParent())) continue;
                return true;
            } while (classLoader3 != null);
            return false;
        }

        private static boolean isSamePackage(Class<?> clazz, Class<?> clazz2) {
            return clazz.getClassLoader() == clazz2.getClassLoader() && Objects.equals(AtomicIntegerFieldUpdaterImpl.getPackageName(clazz), AtomicIntegerFieldUpdaterImpl.getPackageName(clazz2));
        }

        private static String getPackageName(Class<?> clazz) {
            String string = clazz.getName();
            int n = string.lastIndexOf(46);
            return n != -1 ? string.substring(0, n) : "";
        }

        private final void accessCheck(T t) {
            if (!this.cclass.isInstance(t)) {
                this.throwAccessCheckException(t);
            }
        }

        private final void throwAccessCheckException(T t) {
            if (this.cclass == this.tclass) {
                throw new ClassCastException();
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + t.getClass().getName()));
        }

        @Override
        public final boolean compareAndSet(T t, int n, int n2) {
            this.accessCheck(t);
            return U.compareAndSwapInt(t, this.offset, n, n2);
        }

        @Override
        public final boolean weakCompareAndSet(T t, int n, int n2) {
            this.accessCheck(t);
            return U.compareAndSwapInt(t, this.offset, n, n2);
        }

        @Override
        public final void set(T t, int n) {
            this.accessCheck(t);
            U.putIntVolatile(t, this.offset, n);
        }

        @Override
        public final void lazySet(T t, int n) {
            this.accessCheck(t);
            U.putOrderedInt(t, this.offset, n);
        }

        @Override
        public final int get(T t) {
            this.accessCheck(t);
            return U.getIntVolatile(t, this.offset);
        }

        @Override
        public final int getAndSet(T t, int n) {
            this.accessCheck(t);
            return U.getAndSetInt(t, this.offset, n);
        }

        @Override
        public final int getAndAdd(T t, int n) {
            this.accessCheck(t);
            return U.getAndAddInt(t, this.offset, n);
        }

        @Override
        public final int getAndIncrement(T t) {
            return this.getAndAdd(t, 1);
        }

        @Override
        public final int getAndDecrement(T t) {
            return this.getAndAdd(t, -1);
        }

        @Override
        public final int incrementAndGet(T t) {
            return this.getAndAdd(t, 1) + 1;
        }

        @Override
        public final int decrementAndGet(T t) {
            return this.getAndAdd(t, -1) - 1;
        }

        @Override
        public final int addAndGet(T t, int n) {
            return this.getAndAdd(t, n) + n;
        }
    }
}

