/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms.implementations;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.transforms.implementations.XPath2NodeFilter;
import com.sun.org.apache.xml.internal.security.transforms.params.XPath2FilterContainer;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.XPathAPI;
import com.sun.org.apache.xml.internal.security.utils.XPathFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TransformXPath2Filter
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2002/06/xmldsig-filter2";

    @Override
    protected String engineGetURI() {
        return implementedTransformURI;
    }

    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, OutputStream outputStream, Transform transform) throws TransformationException {
        try {
            ArrayList<NodeList> arrayList = new ArrayList<NodeList>();
            ArrayList<NodeList> arrayList2 = new ArrayList<NodeList>();
            ArrayList<NodeList> arrayList3 = new ArrayList<NodeList>();
            Element[] elementArray = XMLUtils.selectNodes(transform.getElement().getFirstChild(), implementedTransformURI, "XPath");
            if (elementArray.length == 0) {
                Object[] objectArray = new Object[]{implementedTransformURI, "XPath"};
                throw new TransformationException("xml.WrongContent", objectArray);
            }
            Document document = null;
            document = xMLSignatureInput.getSubNode() != null ? XMLUtils.getOwnerDocument(xMLSignatureInput.getSubNode()) : XMLUtils.getOwnerDocument(xMLSignatureInput.getNodeSet());
            for (int i = 0; i < elementArray.length; ++i) {
                Element element = elementArray[i];
                XPath2FilterContainer xPath2FilterContainer = XPath2FilterContainer.newInstance(element, xMLSignatureInput.getSourceURI());
                String string = XMLUtils.getStrFromNode(xPath2FilterContainer.getXPathFilterTextNode());
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPathAPI xPathAPI = xPathFactory.newXPathAPI();
                NodeList nodeList = xPathAPI.selectNodeList(document, xPath2FilterContainer.getXPathFilterTextNode(), string, xPath2FilterContainer.getElement());
                if (xPath2FilterContainer.isIntersect()) {
                    arrayList3.add(nodeList);
                    continue;
                }
                if (xPath2FilterContainer.isSubtract()) {
                    arrayList2.add(nodeList);
                    continue;
                }
                if (!xPath2FilterContainer.isUnion()) continue;
                arrayList.add(nodeList);
            }
            xMLSignatureInput.addNodeFilter(new XPath2NodeFilter(arrayList, arrayList2, arrayList3));
            xMLSignatureInput.setNodeSet(true);
            return xMLSignatureInput;
        }
        catch (TransformerException transformerException) {
            throw new TransformationException(transformerException);
        }
        catch (DOMException dOMException) {
            throw new TransformationException(dOMException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new TransformationException(canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new TransformationException(invalidCanonicalizerException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new TransformationException(xMLSecurityException);
        }
        catch (SAXException sAXException) {
            throw new TransformationException(sAXException);
        }
        catch (IOException iOException) {
            throw new TransformationException(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformationException(parserConfigurationException);
        }
    }
}

