/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class ParagraphView
extends javax.swing.text.ParagraphView {
    private AttributeSet attr;
    private StyleSheet.BoxPainter painter;
    private CSS.LengthValue cssWidth;
    private CSS.LengthValue cssHeight;

    public ParagraphView(Element element) {
        super(element);
    }

    @Override
    public void setParent(View view) {
        super.setParent(view);
        if (view != null) {
            this.setPropertiesFromAttributes();
        }
    }

    @Override
    public AttributeSet getAttributes() {
        if (this.attr == null) {
            StyleSheet styleSheet = this.getStyleSheet();
            this.attr = styleSheet.getViewAttributes(this);
        }
        return this.attr;
    }

    @Override
    protected void setPropertiesFromAttributes() {
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.painter = styleSheet.getBoxPainter(this.attr);
        if (this.attr != null) {
            super.setPropertiesFromAttributes();
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
            Object object = this.attr.getAttribute(CSS.Attribute.TEXT_ALIGN);
            if (object != null) {
                String string = object.toString();
                if (string.equals("left")) {
                    this.setJustification(0);
                } else if (string.equals("center")) {
                    this.setJustification(1);
                } else if (string.equals("right")) {
                    this.setJustification(2);
                } else if (string.equals("justify")) {
                    this.setJustification(3);
                }
            }
            this.cssWidth = (CSS.LengthValue)this.attr.getAttribute(CSS.Attribute.WIDTH);
            this.cssHeight = (CSS.LengthValue)this.attr.getAttribute(CSS.Attribute.HEIGHT);
        }
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    @Override
    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        if (BlockView.spanSetFromAttributes(n, sizeRequirements = super.calculateMinorAxisRequirements(n, sizeRequirements), this.cssWidth, this.cssHeight)) {
            int n2 = n == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
            sizeRequirements.minimum -= n2;
            sizeRequirements.preferred -= n2;
            sizeRequirements.maximum -= n2;
        }
        return sizeRequirements;
    }

    @Override
    public boolean isVisible() {
        View view;
        Object object;
        int n;
        int n2 = this.getLayoutViewCount() - 1;
        for (n = 0; n < n2; ++n) {
            object = this.getLayoutView(n);
            if (!((View)object).isVisible()) continue;
            return true;
        }
        if (n2 > 0 && (view = this.getLayoutView(n2)).getEndOffset() - view.getStartOffset() == 1) {
            return false;
        }
        if (this.getStartOffset() == this.getDocument().getLength()) {
            n = 0;
            object = this.getContainer();
            if (object instanceof JTextComponent) {
                n = ((JTextComponent)object).isEditable() ? 1 : 0;
            }
            if (n == 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void paint(Graphics graphics, Shape shape) {
        if (shape == null) {
            return;
        }
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        super.paint(graphics, shape);
    }

    @Override
    public float getPreferredSpan(int n) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        return super.getPreferredSpan(n);
    }

    @Override
    public float getMinimumSpan(int n) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        return super.getMinimumSpan(n);
    }

    @Override
    public float getMaximumSpan(int n) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        return super.getMaximumSpan(n);
    }
}

