/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.AWTPermission;
import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Transparency;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.security.Permission;
import sun.awt.image.SurfaceManager;
import sun.font.FontUtilities;
import sun.java2d.DisposerTarget;
import sun.java2d.NullSurfaceData;
import sun.java2d.StateTrackable;
import sun.java2d.StateTrackableDelegate;
import sun.java2d.StateTracker;
import sun.java2d.SunGraphics2D;
import sun.java2d.Surface;
import sun.java2d.SurfaceDataProxy;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.DrawGlyphList;
import sun.java2d.loops.DrawGlyphListAA;
import sun.java2d.loops.DrawGlyphListLCD;
import sun.java2d.loops.DrawLine;
import sun.java2d.loops.DrawParallelogram;
import sun.java2d.loops.DrawPath;
import sun.java2d.loops.DrawPolygons;
import sun.java2d.loops.DrawRect;
import sun.java2d.loops.FillParallelogram;
import sun.java2d.loops.FillPath;
import sun.java2d.loops.FillRect;
import sun.java2d.loops.FillSpans;
import sun.java2d.loops.MaskFill;
import sun.java2d.loops.RenderCache;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.AAShapePipe;
import sun.java2d.pipe.AATextRenderer;
import sun.java2d.pipe.AlphaColorPipe;
import sun.java2d.pipe.AlphaPaintPipe;
import sun.java2d.pipe.CompositePipe;
import sun.java2d.pipe.DrawImage;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.GeneralCompositePipe;
import sun.java2d.pipe.LCDTextRenderer;
import sun.java2d.pipe.LoopBasedPipe;
import sun.java2d.pipe.LoopPipe;
import sun.java2d.pipe.OutlineTextRenderer;
import sun.java2d.pipe.ParallelogramPipe;
import sun.java2d.pipe.PixelToParallelogramConverter;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.SolidTextRenderer;
import sun.java2d.pipe.SpanClipRenderer;
import sun.java2d.pipe.SpanShapeRenderer;
import sun.java2d.pipe.TextPipe;
import sun.java2d.pipe.TextRenderer;

public abstract class SurfaceData
implements Transparency,
DisposerTarget,
StateTrackable,
Surface {
    private long pData;
    private boolean valid;
    private boolean surfaceLost;
    private SurfaceType surfaceType;
    private ColorModel colorModel;
    private Object disposerReferent = new Object();
    private Object blitProxyKey;
    private StateTrackableDelegate stateDelegate;
    protected static final LoopPipe colorPrimitives;
    public static final TextPipe outlineTextRenderer;
    public static final TextPipe solidTextRenderer;
    public static final TextPipe aaTextRenderer;
    public static final TextPipe lcdTextRenderer;
    protected static final AlphaColorPipe colorPipe;
    protected static final PixelToShapeConverter colorViaShape;
    protected static final PixelToParallelogramConverter colorViaPgram;
    protected static final TextPipe colorText;
    protected static final CompositePipe clipColorPipe;
    protected static final TextPipe clipColorText;
    protected static final AAShapePipe AAColorShape;
    protected static final PixelToParallelogramConverter AAColorViaShape;
    protected static final PixelToParallelogramConverter AAColorViaPgram;
    protected static final AAShapePipe AAClipColorShape;
    protected static final PixelToParallelogramConverter AAClipColorViaShape;
    protected static final CompositePipe paintPipe;
    protected static final SpanShapeRenderer paintShape;
    protected static final PixelToShapeConverter paintViaShape;
    protected static final TextPipe paintText;
    protected static final CompositePipe clipPaintPipe;
    protected static final TextPipe clipPaintText;
    protected static final AAShapePipe AAPaintShape;
    protected static final PixelToParallelogramConverter AAPaintViaShape;
    protected static final AAShapePipe AAClipPaintShape;
    protected static final PixelToParallelogramConverter AAClipPaintViaShape;
    protected static final CompositePipe compPipe;
    protected static final SpanShapeRenderer compShape;
    protected static final PixelToShapeConverter compViaShape;
    protected static final TextPipe compText;
    protected static final CompositePipe clipCompPipe;
    protected static final TextPipe clipCompText;
    protected static final AAShapePipe AACompShape;
    protected static final PixelToParallelogramConverter AACompViaShape;
    protected static final AAShapePipe AAClipCompShape;
    protected static final PixelToParallelogramConverter AAClipCompViaShape;
    protected static final DrawImagePipe imagepipe;
    static final int LOOP_UNKNOWN = 0;
    static final int LOOP_FOUND = 1;
    static final int LOOP_NOTFOUND = 2;
    int haveLCDLoop;
    int havePgramXORLoop;
    int havePgramSolidLoop;
    private static RenderCache loopcache;
    static Permission compPermission;

    private static native void initIDs();

    protected SurfaceData(SurfaceType surfaceType, ColorModel colorModel) {
        this(StateTrackable.State.STABLE, surfaceType, colorModel);
    }

    protected SurfaceData(StateTrackable.State state, SurfaceType surfaceType, ColorModel colorModel) {
        this(StateTrackableDelegate.createInstance(state), surfaceType, colorModel);
    }

    protected SurfaceData(StateTrackableDelegate stateTrackableDelegate, SurfaceType surfaceType, ColorModel colorModel) {
        this.stateDelegate = stateTrackableDelegate;
        this.colorModel = colorModel;
        this.surfaceType = surfaceType;
        this.valid = true;
    }

    protected SurfaceData(StateTrackable.State state) {
        this.stateDelegate = StateTrackableDelegate.createInstance(state);
        this.valid = true;
    }

    protected void setBlitProxyKey(Object object) {
        if (SurfaceDataProxy.isCachingAllowed()) {
            this.blitProxyKey = object;
        }
    }

    public SurfaceData getSourceSurfaceData(Image image, int n, CompositeType compositeType, Color color) {
        SurfaceManager surfaceManager = SurfaceManager.getManager(image);
        SurfaceData surfaceData = surfaceManager.getPrimarySurfaceData();
        if (image.getAccelerationPriority() > 0.0f && this.blitProxyKey != null) {
            SurfaceDataProxy surfaceDataProxy = (SurfaceDataProxy)surfaceManager.getCacheData(this.blitProxyKey);
            if (surfaceDataProxy == null || !surfaceDataProxy.isValid()) {
                surfaceDataProxy = surfaceData.getState() == StateTrackable.State.UNTRACKABLE ? SurfaceDataProxy.UNCACHED : this.makeProxyFor(surfaceData);
                surfaceManager.setCacheData(this.blitProxyKey, surfaceDataProxy);
            }
            surfaceData = surfaceDataProxy.replaceData(surfaceData, n, compositeType, color);
        }
        return surfaceData;
    }

    public SurfaceDataProxy makeProxyFor(SurfaceData surfaceData) {
        return SurfaceDataProxy.UNCACHED;
    }

    public static SurfaceData getPrimarySurfaceData(Image image) {
        SurfaceManager surfaceManager = SurfaceManager.getManager(image);
        return surfaceManager.getPrimarySurfaceData();
    }

    public static SurfaceData restoreContents(Image image) {
        SurfaceManager surfaceManager = SurfaceManager.getManager(image);
        return surfaceManager.restoreContents();
    }

    @Override
    public StateTrackable.State getState() {
        return this.stateDelegate.getState();
    }

    @Override
    public StateTracker getStateTracker() {
        return this.stateDelegate.getStateTracker();
    }

    public final void markDirty() {
        this.stateDelegate.markDirty();
    }

    public void setSurfaceLost(boolean bl) {
        this.surfaceLost = bl;
        this.stateDelegate.markDirty();
    }

    public boolean isSurfaceLost() {
        return this.surfaceLost;
    }

    public final boolean isValid() {
        return this.valid;
    }

    @Override
    public Object getDisposerReferent() {
        return this.disposerReferent;
    }

    public long getNativeOps() {
        return this.pData;
    }

    public void invalidate() {
        this.valid = false;
        this.stateDelegate.markDirty();
    }

    public abstract SurfaceData getReplacement();

    private static PixelToParallelogramConverter makeConverter(AAShapePipe aAShapePipe, ParallelogramPipe parallelogramPipe) {
        return new PixelToParallelogramConverter(aAShapePipe, parallelogramPipe, 0.125, 0.499, false);
    }

    private static PixelToParallelogramConverter makeConverter(AAShapePipe aAShapePipe) {
        return SurfaceData.makeConverter(aAShapePipe, aAShapePipe);
    }

    public boolean canRenderLCDText(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.compositeState <= 0 && sunGraphics2D.paintState <= 1 && sunGraphics2D.clipState <= 1 && sunGraphics2D.surfaceData.getTransparency() == 1) {
            if (this.haveLCDLoop == 0) {
                DrawGlyphListLCD drawGlyphListLCD = DrawGlyphListLCD.locate(SurfaceType.AnyColor, CompositeType.SrcNoEa, this.getSurfaceType());
                this.haveLCDLoop = drawGlyphListLCD != null ? 1 : 2;
            }
            return this.haveLCDLoop == 1;
        }
        return false;
    }

    public boolean canRenderParallelograms(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.paintState <= 1) {
            if (sunGraphics2D.compositeState == 2) {
                if (this.havePgramXORLoop == 0) {
                    FillParallelogram fillParallelogram = FillParallelogram.locate(SurfaceType.AnyColor, CompositeType.Xor, this.getSurfaceType());
                    this.havePgramXORLoop = fillParallelogram != null ? 1 : 2;
                }
                return this.havePgramXORLoop == 1;
            }
            if (sunGraphics2D.compositeState <= 0 && sunGraphics2D.antialiasHint != 2 && sunGraphics2D.clipState != 2) {
                if (this.havePgramSolidLoop == 0) {
                    FillParallelogram fillParallelogram = FillParallelogram.locate(SurfaceType.AnyColor, CompositeType.SrcNoEa, this.getSurfaceType());
                    this.havePgramSolidLoop = fillParallelogram != null ? 1 : 2;
                }
                return this.havePgramSolidLoop == 1;
            }
        }
        return false;
    }

    public void validatePipe(SunGraphics2D sunGraphics2D) {
        sunGraphics2D.imagepipe = imagepipe;
        if (sunGraphics2D.compositeState == 2) {
            if (sunGraphics2D.paintState > 1) {
                sunGraphics2D.drawpipe = paintViaShape;
                sunGraphics2D.fillpipe = paintViaShape;
                sunGraphics2D.shapepipe = paintShape;
                sunGraphics2D.textpipe = outlineTextRenderer;
            } else {
                PixelToShapeConverter pixelToShapeConverter;
                if (this.canRenderParallelograms(sunGraphics2D)) {
                    pixelToShapeConverter = colorViaPgram;
                    sunGraphics2D.shapepipe = colorViaPgram;
                } else {
                    pixelToShapeConverter = colorViaShape;
                    sunGraphics2D.shapepipe = colorPrimitives;
                }
                if (sunGraphics2D.clipState == 2) {
                    sunGraphics2D.drawpipe = pixelToShapeConverter;
                    sunGraphics2D.fillpipe = pixelToShapeConverter;
                    sunGraphics2D.textpipe = outlineTextRenderer;
                } else {
                    if (sunGraphics2D.transformState >= 3) {
                        sunGraphics2D.drawpipe = pixelToShapeConverter;
                        sunGraphics2D.fillpipe = pixelToShapeConverter;
                    } else {
                        sunGraphics2D.drawpipe = sunGraphics2D.strokeState != 0 ? pixelToShapeConverter : colorPrimitives;
                        sunGraphics2D.fillpipe = colorPrimitives;
                    }
                    sunGraphics2D.textpipe = solidTextRenderer;
                }
            }
        } else if (sunGraphics2D.compositeState == 3) {
            if (sunGraphics2D.antialiasHint == 2) {
                if (sunGraphics2D.clipState == 2) {
                    sunGraphics2D.drawpipe = AAClipCompViaShape;
                    sunGraphics2D.fillpipe = AAClipCompViaShape;
                    sunGraphics2D.shapepipe = AAClipCompViaShape;
                    sunGraphics2D.textpipe = clipCompText;
                } else {
                    sunGraphics2D.drawpipe = AACompViaShape;
                    sunGraphics2D.fillpipe = AACompViaShape;
                    sunGraphics2D.shapepipe = AACompViaShape;
                    sunGraphics2D.textpipe = compText;
                }
            } else {
                sunGraphics2D.drawpipe = compViaShape;
                sunGraphics2D.fillpipe = compViaShape;
                sunGraphics2D.shapepipe = compShape;
                sunGraphics2D.textpipe = sunGraphics2D.clipState == 2 ? clipCompText : compText;
            }
        } else if (sunGraphics2D.antialiasHint == 2) {
            sunGraphics2D.alphafill = this.getMaskFill(sunGraphics2D);
            if (sunGraphics2D.alphafill != null) {
                if (sunGraphics2D.clipState == 2) {
                    sunGraphics2D.drawpipe = AAClipColorViaShape;
                    sunGraphics2D.fillpipe = AAClipColorViaShape;
                    sunGraphics2D.shapepipe = AAClipColorViaShape;
                    sunGraphics2D.textpipe = clipColorText;
                } else {
                    PixelToParallelogramConverter pixelToParallelogramConverter = sunGraphics2D.alphafill.canDoParallelograms() ? AAColorViaPgram : AAColorViaShape;
                    sunGraphics2D.drawpipe = pixelToParallelogramConverter;
                    sunGraphics2D.fillpipe = pixelToParallelogramConverter;
                    sunGraphics2D.shapepipe = pixelToParallelogramConverter;
                    sunGraphics2D.textpipe = sunGraphics2D.paintState > 1 || sunGraphics2D.compositeState > 0 ? colorText : this.getTextPipe(sunGraphics2D, true);
                }
            } else if (sunGraphics2D.clipState == 2) {
                sunGraphics2D.drawpipe = AAClipPaintViaShape;
                sunGraphics2D.fillpipe = AAClipPaintViaShape;
                sunGraphics2D.shapepipe = AAClipPaintViaShape;
                sunGraphics2D.textpipe = clipPaintText;
            } else {
                sunGraphics2D.drawpipe = AAPaintViaShape;
                sunGraphics2D.fillpipe = AAPaintViaShape;
                sunGraphics2D.shapepipe = AAPaintViaShape;
                sunGraphics2D.textpipe = paintText;
            }
        } else if (sunGraphics2D.paintState > 1 || sunGraphics2D.compositeState > 0 || sunGraphics2D.clipState == 2) {
            sunGraphics2D.drawpipe = paintViaShape;
            sunGraphics2D.fillpipe = paintViaShape;
            sunGraphics2D.shapepipe = paintShape;
            sunGraphics2D.alphafill = this.getMaskFill(sunGraphics2D);
            sunGraphics2D.textpipe = sunGraphics2D.alphafill != null ? (sunGraphics2D.clipState == 2 ? clipColorText : colorText) : (sunGraphics2D.clipState == 2 ? clipPaintText : paintText);
        } else {
            PixelToShapeConverter pixelToShapeConverter;
            if (this.canRenderParallelograms(sunGraphics2D)) {
                pixelToShapeConverter = colorViaPgram;
                sunGraphics2D.shapepipe = colorViaPgram;
            } else {
                pixelToShapeConverter = colorViaShape;
                sunGraphics2D.shapepipe = colorPrimitives;
            }
            if (sunGraphics2D.transformState >= 3) {
                sunGraphics2D.drawpipe = pixelToShapeConverter;
                sunGraphics2D.fillpipe = pixelToShapeConverter;
            } else {
                sunGraphics2D.drawpipe = sunGraphics2D.strokeState != 0 ? pixelToShapeConverter : colorPrimitives;
                sunGraphics2D.fillpipe = colorPrimitives;
            }
            sunGraphics2D.textpipe = this.getTextPipe(sunGraphics2D, false);
        }
        if (sunGraphics2D.textpipe instanceof LoopBasedPipe || sunGraphics2D.shapepipe instanceof LoopBasedPipe || sunGraphics2D.fillpipe instanceof LoopBasedPipe || sunGraphics2D.drawpipe instanceof LoopBasedPipe || sunGraphics2D.imagepipe instanceof LoopBasedPipe) {
            sunGraphics2D.loops = this.getRenderLoops(sunGraphics2D);
        }
    }

    private TextPipe getTextPipe(SunGraphics2D sunGraphics2D, boolean bl) {
        switch (sunGraphics2D.textAntialiasHint) {
            case 0: {
                if (bl) {
                    return aaTextRenderer;
                }
                return solidTextRenderer;
            }
            case 1: {
                return solidTextRenderer;
            }
            case 2: {
                return aaTextRenderer;
            }
        }
        switch (sunGraphics2D.getFontInfo().aaHint) {
            case 4: 
            case 6: {
                return lcdTextRenderer;
            }
            case 2: {
                return aaTextRenderer;
            }
            case 1: {
                return solidTextRenderer;
            }
        }
        if (bl) {
            return aaTextRenderer;
        }
        return solidTextRenderer;
    }

    private static SurfaceType getPaintSurfaceType(SunGraphics2D sunGraphics2D) {
        switch (sunGraphics2D.paintState) {
            case 0: {
                return SurfaceType.OpaqueColor;
            }
            case 1: {
                return SurfaceType.AnyColor;
            }
            case 2: {
                if (sunGraphics2D.paint.getTransparency() == 1) {
                    return SurfaceType.OpaqueGradientPaint;
                }
                return SurfaceType.GradientPaint;
            }
            case 3: {
                if (sunGraphics2D.paint.getTransparency() == 1) {
                    return SurfaceType.OpaqueLinearGradientPaint;
                }
                return SurfaceType.LinearGradientPaint;
            }
            case 4: {
                if (sunGraphics2D.paint.getTransparency() == 1) {
                    return SurfaceType.OpaqueRadialGradientPaint;
                }
                return SurfaceType.RadialGradientPaint;
            }
            case 5: {
                if (sunGraphics2D.paint.getTransparency() == 1) {
                    return SurfaceType.OpaqueTexturePaint;
                }
                return SurfaceType.TexturePaint;
            }
        }
        return SurfaceType.AnyPaint;
    }

    private static CompositeType getFillCompositeType(SunGraphics2D sunGraphics2D) {
        CompositeType compositeType = sunGraphics2D.imageComp;
        if (sunGraphics2D.compositeState == 0) {
            compositeType = compositeType == CompositeType.SrcOverNoEa ? CompositeType.OpaqueSrcOverNoEa : CompositeType.SrcNoEa;
        }
        return compositeType;
    }

    protected MaskFill getMaskFill(SunGraphics2D sunGraphics2D) {
        SurfaceType surfaceType = SurfaceData.getPaintSurfaceType(sunGraphics2D);
        CompositeType compositeType = SurfaceData.getFillCompositeType(sunGraphics2D);
        SurfaceType surfaceType2 = this.getSurfaceType();
        return MaskFill.getFromCache(surfaceType, compositeType, surfaceType2);
    }

    public RenderLoops getRenderLoops(SunGraphics2D sunGraphics2D) {
        SurfaceType surfaceType;
        CompositeType compositeType;
        SurfaceType surfaceType2 = SurfaceData.getPaintSurfaceType(sunGraphics2D);
        Object object = loopcache.get(surfaceType2, compositeType = SurfaceData.getFillCompositeType(sunGraphics2D), surfaceType = sunGraphics2D.getSurfaceData().getSurfaceType());
        if (object != null) {
            return (RenderLoops)object;
        }
        RenderLoops renderLoops = SurfaceData.makeRenderLoops(surfaceType2, compositeType, surfaceType);
        loopcache.put(surfaceType2, compositeType, surfaceType, renderLoops);
        return renderLoops;
    }

    public static RenderLoops makeRenderLoops(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        RenderLoops renderLoops = new RenderLoops();
        renderLoops.drawLineLoop = DrawLine.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.fillRectLoop = FillRect.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.drawRectLoop = DrawRect.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.drawPolygonsLoop = DrawPolygons.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.drawPathLoop = DrawPath.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.fillPathLoop = FillPath.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.fillSpansLoop = FillSpans.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.fillParallelogramLoop = FillParallelogram.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.drawParallelogramLoop = DrawParallelogram.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.drawGlyphListLoop = DrawGlyphList.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.drawGlyphListAALoop = DrawGlyphListAA.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.drawGlyphListLCDLoop = DrawGlyphListLCD.locate(surfaceType, compositeType, surfaceType2);
        return renderLoops;
    }

    public abstract GraphicsConfiguration getDeviceConfiguration();

    public final SurfaceType getSurfaceType() {
        return this.surfaceType;
    }

    public final ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public int getTransparency() {
        return this.getColorModel().getTransparency();
    }

    public abstract Raster getRaster(int var1, int var2, int var3, int var4);

    public boolean useTightBBoxes() {
        return true;
    }

    public int pixelFor(int n) {
        return this.surfaceType.pixelFor(n, this.colorModel);
    }

    public int pixelFor(Color color) {
        return this.pixelFor(color.getRGB());
    }

    public int rgbFor(int n) {
        return this.surfaceType.rgbFor(n, this.colorModel);
    }

    public abstract Rectangle getBounds();

    protected void checkCustomComposite() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (compPermission == null) {
                compPermission = new AWTPermission("readDisplayPixels");
            }
            securityManager.checkPermission(compPermission);
        }
    }

    protected static native boolean isOpaqueGray(IndexColorModel var0);

    public static boolean isNull(SurfaceData surfaceData) {
        return surfaceData == null || surfaceData == NullSurfaceData.theInstance;
    }

    public boolean copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        return false;
    }

    public void flush() {
    }

    public abstract Object getDestination();

    public int getDefaultScale() {
        return 1;
    }

    static {
        SurfaceData.initIDs();
        colorPrimitives = new LoopPipe();
        outlineTextRenderer = new OutlineTextRenderer();
        aaTextRenderer = new AATextRenderer();
        solidTextRenderer = FontUtilities.isMacOSX14 ? aaTextRenderer : new SolidTextRenderer();
        lcdTextRenderer = new LCDTextRenderer();
        colorPipe = new AlphaColorPipe();
        colorViaShape = new PixelToShapeLoopConverter(colorPrimitives);
        colorViaPgram = new PixelToPgramLoopConverter(colorPrimitives, colorPrimitives, 1.0, 0.25, true);
        colorText = new TextRenderer(colorPipe);
        clipColorPipe = new SpanClipRenderer(colorPipe);
        clipColorText = new TextRenderer(clipColorPipe);
        AAColorShape = new AAShapePipe(colorPipe);
        AAColorViaShape = SurfaceData.makeConverter(AAColorShape);
        AAColorViaPgram = SurfaceData.makeConverter(AAColorShape, colorPipe);
        AAClipColorShape = new AAShapePipe(clipColorPipe);
        AAClipColorViaShape = SurfaceData.makeConverter(AAClipColorShape);
        paintPipe = new AlphaPaintPipe();
        paintShape = new SpanShapeRenderer.Composite(paintPipe);
        paintViaShape = new PixelToShapeConverter(paintShape);
        paintText = new TextRenderer(paintPipe);
        clipPaintPipe = new SpanClipRenderer(paintPipe);
        clipPaintText = new TextRenderer(clipPaintPipe);
        AAPaintShape = new AAShapePipe(paintPipe);
        AAPaintViaShape = SurfaceData.makeConverter(AAPaintShape);
        AAClipPaintShape = new AAShapePipe(clipPaintPipe);
        AAClipPaintViaShape = SurfaceData.makeConverter(AAClipPaintShape);
        compPipe = new GeneralCompositePipe();
        compShape = new SpanShapeRenderer.Composite(compPipe);
        compViaShape = new PixelToShapeConverter(compShape);
        compText = new TextRenderer(compPipe);
        clipCompPipe = new SpanClipRenderer(compPipe);
        clipCompText = new TextRenderer(clipCompPipe);
        AACompShape = new AAShapePipe(compPipe);
        AACompViaShape = SurfaceData.makeConverter(AACompShape);
        AAClipCompShape = new AAShapePipe(clipCompPipe);
        AAClipCompViaShape = SurfaceData.makeConverter(AAClipCompShape);
        imagepipe = new DrawImage();
        loopcache = new RenderCache(30);
    }

    static class PixelToPgramLoopConverter
    extends PixelToParallelogramConverter
    implements LoopBasedPipe {
        public PixelToPgramLoopConverter(ShapeDrawPipe shapeDrawPipe, ParallelogramPipe parallelogramPipe, double d, double d2, boolean bl) {
            super(shapeDrawPipe, parallelogramPipe, d, d2, bl);
        }
    }

    static class PixelToShapeLoopConverter
    extends PixelToShapeConverter
    implements LoopBasedPipe {
        public PixelToShapeLoopConverter(ShapeDrawPipe shapeDrawPipe) {
            super(shapeDrawPipe);
        }
    }
}

