/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.PropertyPermission;

final class PropertyPermissionCollection
extends PermissionCollection
implements Serializable {
    private transient Map<String, PropertyPermission> perms = new HashMap<String, PropertyPermission>(32);
    private boolean all_allowed = false;
    private static final long serialVersionUID = 7015263904581634791L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Hashtable.class), new ObjectStreamField("all_allowed", Boolean.TYPE)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof PropertyPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        PropertyPermission propertyPermission = (PropertyPermission)permission;
        String string = propertyPermission.getName();
        PropertyPermissionCollection propertyPermissionCollection = this;
        synchronized (propertyPermissionCollection) {
            PropertyPermission propertyPermission2 = this.perms.get(string);
            if (propertyPermission2 != null) {
                int n;
                int n2 = propertyPermission2.getMask();
                if (n2 != (n = propertyPermission.getMask())) {
                    int n3 = n2 | n;
                    String string2 = PropertyPermission.getActions(n3);
                    this.perms.put(string, new PropertyPermission(string, string2));
                }
            } else {
                this.perms.put(string, propertyPermission);
            }
        }
        if (!this.all_allowed && string.equals("*")) {
            this.all_allowed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        int n;
        PropertyPermission propertyPermission;
        Object object;
        if (!(permission instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission propertyPermission2 = (PropertyPermission)permission;
        int n2 = propertyPermission2.getMask();
        int n3 = 0;
        if (this.all_allowed) {
            object = this;
            synchronized (object) {
                propertyPermission = this.perms.get("*");
            }
            if (propertyPermission != null && ((n3 |= propertyPermission.getMask()) & n2) == n2) {
                return true;
            }
        }
        object = propertyPermission2.getName();
        PropertyPermissionCollection propertyPermissionCollection = this;
        synchronized (propertyPermissionCollection) {
            propertyPermission = this.perms.get(object);
        }
        if (propertyPermission != null && ((n3 |= propertyPermission.getMask()) & n2) == n2) {
            return true;
        }
        int n4 = ((String)object).length() - 1;
        while ((n = ((String)object).lastIndexOf(".", n4)) != -1) {
            object = ((String)object).substring(0, n + 1) + "*";
            PropertyPermissionCollection propertyPermissionCollection2 = this;
            synchronized (propertyPermissionCollection2) {
                propertyPermission = this.perms.get(object);
            }
            if (propertyPermission != null && ((n3 |= propertyPermission.getMask()) & n2) == n2) {
                return true;
            }
            n4 = n - 1;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Permission> elements() {
        PropertyPermissionCollection propertyPermissionCollection = this;
        synchronized (propertyPermissionCollection) {
            return Collections.enumeration(this.perms.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable<String, PropertyPermission> hashtable = new Hashtable<String, PropertyPermission>(this.perms.size() * 2);
        Object object = this;
        synchronized (object) {
            hashtable.putAll(this.perms);
        }
        object = objectOutputStream.putFields();
        ((ObjectOutputStream.PutField)object).put("all_allowed", this.all_allowed);
        ((ObjectOutputStream.PutField)object).put("permissions", hashtable);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.all_allowed = getField.get("all_allowed", false);
        Hashtable hashtable = (Hashtable)getField.get("permissions", null);
        this.perms = new HashMap<String, PropertyPermission>(hashtable.size() * 2);
        this.perms.putAll(hashtable);
    }
}

