/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.util.concurrent.atomic.AtomicLong;
import jdk.jfr.events.ErrorThrownEvent;
import jdk.jfr.events.ExceptionThrownEvent;

public final class ThrowableTracer {
    private static AtomicLong numThrowables = new AtomicLong(0L);

    public static void traceError(Error error, String string) {
        if (error instanceof OutOfMemoryError) {
            return;
        }
        ErrorThrownEvent errorThrownEvent = new ErrorThrownEvent();
        errorThrownEvent.message = string;
        errorThrownEvent.thrownClass = error.getClass();
        errorThrownEvent.commit();
        ExceptionThrownEvent exceptionThrownEvent = new ExceptionThrownEvent();
        exceptionThrownEvent.message = string;
        exceptionThrownEvent.thrownClass = error.getClass();
        exceptionThrownEvent.commit();
        numThrowables.incrementAndGet();
    }

    public static void traceThrowable(Throwable throwable, String string) {
        ExceptionThrownEvent exceptionThrownEvent = new ExceptionThrownEvent();
        exceptionThrownEvent.message = string;
        exceptionThrownEvent.thrownClass = throwable.getClass();
        exceptionThrownEvent.commit();
        numThrowables.incrementAndGet();
    }

    public static long numThrowables() {
        return numThrowables.get();
    }
}

