/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.zh;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_zh extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Falkland = new String[] {
               "\u798f\u514b\u5170\u7fa4\u5c9b\u6807\u51c6\u65f6\u95f4",
               "FIST",
               "\u798f\u514b\u5170\u7fa4\u5c9b\u590f\u4ee4\u65f6\u95f4",
               "FIST",
               "\u798f\u514b\u5170\u7fa4\u5c9b\u65f6\u95f4",
               "FIT",
            };
        final String[] Iran = new String[] {
               "\u4f0a\u6717\u6807\u51c6\u65f6\u95f4",
               "IST",
               "\u4f0a\u6717\u590f\u4ee4\u65f6\u95f4",
               "IDT",
               "\u4f0a\u6717\u65f6\u95f4",
               "IT",
            };
        final String[] Cape_Verde = new String[] {
               "\u4f5b\u5f97\u89d2\u6807\u51c6\u65f6\u95f4",
               "CVST",
               "\u4f5b\u5f97\u89d2\u590f\u4ee4\u65f6\u95f4",
               "CVST",
               "\u4f5b\u5f97\u89d2\u65f6\u95f4",
               "CVT",
            };
        final String[] GMT = new String[] {
               "\u683c\u6797\u5c3c\u6cbb\u6807\u51c6\u65f6\u95f4",
               "\u683c\u6797\u5c3c\u6cbb\u6807\u51c6\u65f6\u95f4",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Ponape = new String[] {
               "\u6ce2\u7eb3\u4f69\u65f6\u95f4",
               "PT",
               "Ponape Summer Time",
               "PST",
               "Ponape Time",
               "PT",
            };
        final String[] Omsk = new String[] {
               "\u9102\u6728\u65af\u514b\u6807\u51c6\u65f6\u95f4",
               "OST",
               "\u9102\u6728\u65af\u514b\u590f\u4ee4\u65f6\u95f4",
               "OST",
               "\u9102\u6728\u65af\u514b\u65f6\u95f4",
               "OT",
            };
        final String[] Kosrae = new String[] {
               "\u79d1\u65af\u96f7\u65f6\u95f4",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u590f\u5a01\u5937\u2014\u963f\u7559\u7533\u6807\u51c6\u65f6\u95f4",
               "HAST",
               "\u590f\u5a01\u5937\u2014\u963f\u7559\u7533\u590f\u4ee4\u65f6\u95f4",
               "HADT",
               "\u590f\u5a01\u5937\u2014\u963f\u7559\u7533\u65f6\u95f4",
               "HAT",
            };
        final String[] Myanmar = new String[] {
               "\u7f05\u7538\u65f6\u95f4",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Sakhalin = new String[] {
               "\u5e93\u9875\u5c9b\u6807\u51c6\u65f6\u95f4",
               "SST",
               "\u5e93\u9875\u5c9b\u590f\u4ee4\u65f6\u95f4",
               "SST",
               "\u5e93\u9875\u5c9b\u65f6\u95f4",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "\u96c5\u5e93\u8328\u514b\u6807\u51c6\u65f6\u95f4",
               "YST",
               "\u96c5\u5e93\u8328\u514b\u590f\u4ee4\u65f6\u95f4",
               "YST",
               "\u96c5\u5e93\u8328\u514b\u65f6\u95f4",
               "YT",
            };
        final String[] Gambier = new String[] {
               "\u7518\u6bd4\u5c14\u7fa4\u5c9b\u65f6\u95f4",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Paraguay = new String[] {
               "\u5df4\u62c9\u572d\u6807\u51c6\u65f6\u95f4",
               "PST",
               "\u5df4\u62c9\u572d\u590f\u4ee4\u65f6\u95f4",
               "PST",
               "\u5df4\u62c9\u572d\u65f6\u95f4",
               "PT",
            };
        final String[] Nepal = new String[] {
               "\u5c3c\u6cca\u5c14\u65f6\u95f4",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Maldives = new String[] {
               "\u9a6c\u5c14\u4ee3\u592b\u65f6\u95f4",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Turkmenistan = new String[] {
               "\u571f\u5e93\u66fc\u65af\u5766\u6807\u51c6\u65f6\u95f4",
               "TST",
               "\u571f\u5e93\u66fc\u65af\u5766\u590f\u4ee4\u65f6\u95f4",
               "TST",
               "\u571f\u5e93\u66fc\u65af\u5766\u65f6\u95f4",
               "TT",
            };
        final String[] Truk = new String[] {
               "\u7279\u9c81\u514b\u65f6\u95f4",
               "CT",
               "Chuuk Summer Time",
               "CST",
               "Chuuk Time",
               "CT",
            };
        final String[] Japan = new String[] {
               "\u65e5\u672c\u6807\u51c6\u65f6\u95f4",
               "JST",
               "\u65e5\u672c\u590f\u4ee4\u65f6\u95f4",
               "JDT",
               "\u65e5\u672c\u65f6\u95f4",
               "JT",
            };
        final String[] Vladivostok = new String[] {
               "\u6d77\u53c2\u5d34\u6807\u51c6\u65f6\u95f4",
               "VST",
               "\u6d77\u53c2\u5d34\u590f\u4ee4\u65f6\u95f4",
               "VST",
               "\u6d77\u53c2\u5d34\u65f6\u95f4",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "\u6b27\u6d32\u897f\u90e8\u6807\u51c6\u65f6\u95f4",
               "WEST",
               "\u6b27\u6d32\u897f\u90e8\u590f\u4ee4\u65f6\u95f4",
               "WEST",
               "\u6b27\u6d32\u897f\u90e8\u65f6\u95f4",
               "WET",
            };
        final String[] Bangladesh = new String[] {
               "\u5b5f\u52a0\u62c9\u6807\u51c6\u65f6\u95f4",
               "BST",
               "\u5b5f\u52a0\u62c9\u590f\u4ee4\u65f6\u95f4",
               "BST",
               "\u5b5f\u52a0\u62c9\u65f6\u95f4",
               "BT",
            };
        final String[] East_Timor = new String[] {
               "\u4e1c\u5e1d\u6c76\u6807\u51c6\u65f6\u95f4",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Greenland_Western = new String[] {
               "\u683c\u6797\u5170\u897f\u90e8\u6807\u51c6\u65f6\u95f4",
               "WGST",
               "\u683c\u6797\u5170\u897f\u90e8\u590f\u4ee4\u65f6\u95f4",
               "WGST",
               "\u683c\u6797\u5170\u897f\u90e8\u65f6\u95f4",
               "WGT",
            };
        final String[] Marquesas = new String[] {
               "\u9a6c\u514b\u8428\u65af\u7fa4\u5c9b\u65f6\u95f4",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Colombia = new String[] {
               "\u54e5\u4f26\u6bd4\u4e9a\u65f6\u95f4",
               "CST",
               "\u54e5\u4f26\u6bd4\u4e9a\u590f\u4ee4\u65f6\u95f4",
               "CST",
               "\u54e5\u4f26\u6bd4\u4e9a\u65f6\u95f4",
               "CT",
            };
        final String[] Wake = new String[] {
               "\u5a01\u514b\u5c9b\u65f6\u95f4",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Suriname = new String[] {
               "\u82cf\u91cc\u5357\u6807\u51c6\u65f6\u95f4",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Gulf = new String[] {
               "\u6d77\u6e7e\u6807\u51c6\u65f6\u95f4",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Singapore = new String[] {
               "\u65b0\u52a0\u5761\u6807\u51c6\u65f6\u95f4",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Hovd = new String[] {
               "\u79d1\u5e03\u591a\u6807\u51c6\u65f6\u95f4",
               "HST",
               "\u79d1\u5e03\u591a\u590f\u4ee4\u65f6\u95f4",
               "HST",
               "\u79d1\u5e03\u591a\u65f6\u95f4",
               "HT",
            };
        final String[] Amazon = new String[] {
               "\u4e9a\u9a6c\u900a\u6807\u51c6\u65f6\u95f4",
               "AST",
               "\u4e9a\u9a6c\u900a\u590f\u4ee4\u65f6\u95f4",
               "AST",
               "\u4e9a\u9a6c\u900a\u65f6\u95f4",
               "AT",
            };
        final String[] Tokelau = new String[] {
               "\u6258\u514b\u52b3\u65f6\u95f4",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u5409\u5c14\u67cf\u7279\u7fa4\u5c9b\u65f6\u95f4",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] Pakistan = new String[] {
               "\u5df4\u57fa\u65af\u5766\u6807\u51c6\u65f6\u95f4",
               "PST",
               "\u5df4\u57fa\u65af\u5766\u590f\u4ee4\u65f6\u95f4",
               "PST",
               "\u5df4\u57fa\u65af\u5766\u65f6\u95f4",
               "PT",
            };
        final String[] Mongolia = new String[] {
               "\u4e4c\u5170\u5df4\u6258\u6807\u51c6\u65f6\u95f4",
               "UBST",
               "\u4e4c\u5170\u5df4\u6258\u590f\u4ee4\u65f6\u95f4",
               "UBST",
               "\u4e4c\u5170\u5df4\u6258\u65f6\u95f4",
               "UBT",
            };
        final String[] Palau = new String[] {
               "\u5e15\u52b3\u65f6\u95f4",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] New_Caledonia = new String[] {
               "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a\u6807\u51c6\u65f6\u95f4",
               "NCST",
               "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a\u590f\u4ee4\u65f6\u95f4",
               "NCST",
               "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a\u65f6\u95f4",
               "NCT",
            };
        final String[] Nauru = new String[] {
               "\u7459\u9c81\u65f6\u95f4",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] America_Pacific = new String[] {
               "\u592a\u5e73\u6d0b\u6807\u51c6\u65f6\u95f4",
               "PST",
               "\u592a\u5e73\u6d0b\u590f\u4ee4\u65f6\u95f4",
               "PDT",
               "\u7f8e\u56fd\u592a\u5e73\u6d0b\u65f6\u95f4",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "\u963f\u6839\u5ef7\u897f\u90e8\u6807\u51c6\u65f6\u95f4",
               "WAST",
               "\u963f\u6839\u5ef7\u897f\u90e8\u590f\u4ee4\u65f6\u95f4",
               "WAST",
               "\u963f\u6839\u5ef7\u897f\u90e8\u65f6\u95f4",
               "WAT",
            };
        final String[] Galapagos = new String[] {
               "\u52a0\u62c9\u5e15\u6208\u65af\u65f6\u95f4",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] French_Guiana = new String[] {
               "\u6cd5\u5c5e\u572d\u4e9a\u90a3\u65f6\u95f4",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u683c\u6797\u5170\u4e1c\u90e8\u6807\u51c6\u65f6\u95f4",
               "EGST",
               "\u683c\u6797\u5170\u4e1c\u90e8\u590f\u4ee4\u65f6\u95f4",
               "EGST",
               "\u683c\u6797\u5170\u4e1c\u90e8\u65f6\u95f4",
               "EGT",
            };
        final String[] Christmas = new String[] {
               "\u5723\u8bde\u5c9b\u65f6\u95f4",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Volgograd = new String[] {
               "\u4f0f\u5c14\u52a0\u683c\u52d2\u6807\u51c6\u65f6\u95f4",
               "VST",
               "\u4f0f\u5c14\u52a0\u683c\u52d2\u590f\u4ee4\u65f6\u95f4",
               "VST",
               "\u4f0f\u5c14\u52a0\u683c\u52d2\u65f6\u95f4",
               "VT",
            };
        final String[] Korea = new String[] {
               "\u97e9\u56fd\u6807\u51c6\u65f6\u95f4",
               "KST",
               "\u97e9\u56fd\u590f\u4ee4\u65f6\u95f4",
               "KDT",
               "\u97e9\u56fd\u65f6\u95f4",
               "KT",
            };
        final String[] Vanuatu = new String[] {
               "\u74e6\u52aa\u963f\u56fe\u6807\u51c6\u65f6\u95f4",
               "VST",
               "\u74e6\u52aa\u963f\u56fe\u590f\u4ee4\u65f6\u95f4",
               "VST",
               "\u74e6\u52aa\u963f\u56fe\u65f6\u95f4",
               "VT",
            };
        final String[] Argentina = new String[] {
               "\u963f\u6839\u5ef7\u6807\u51c6\u65f6\u95f4",
               "AST",
               "\u963f\u6839\u5ef7\u590f\u4ee4\u65f6\u95f4",
               "AST",
               "\u963f\u6839\u5ef7\u65f6\u95f4",
               "AT",
            };
        final String[] Lord_Howe = new String[] {
               "\u7f57\u5fb7\u6beb\u5c9b\u6807\u51c6\u65f6\u95f4",
               "LHST",
               "\u7f57\u5fb7\u6beb\u5c9b\u590f\u4ee4\u65f6\u95f4",
               "LHDT",
               "\u7f57\u5fb7\u6beb\u5c9b\u65f6\u95f4",
               "LHT",
            };
        final String[] Syowa = new String[] {
               "\u662d\u548c\u65f6\u95f4",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Kyrgystan = new String[] {
               "\u5409\u5c14\u5409\u65af\u65af\u5766\u6807\u51c6\u65f6\u95f4",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Arabian = new String[] {
               "\u963f\u62c9\u4f2f\u6807\u51c6\u65f6\u95f4",
               "AST",
               "\u963f\u62c9\u4f2f\u590f\u4ee4\u65f6\u95f4",
               "ADT",
               "\u963f\u62c9\u4f2f\u65f6\u95f4",
               "AT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u6fb3\u5927\u5229\u4e9a\u4e1c\u90e8\u6807\u51c6\u65f6\u95f4",
               "AEST",
               "\u6fb3\u5927\u5229\u4e9a\u4e1c\u90e8\u590f\u4ee4\u65f6\u95f4",
               "AEDT",
               "\u6fb3\u5927\u5229\u4e9a\u4e1c\u90e8\u65f6\u95f4",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "\u4f0a\u5c14\u5e93\u8328\u514b\u6807\u51c6\u65f6\u95f4",
               "IST",
               "\u4f0a\u5c14\u5e93\u8328\u514b\u590f\u4ee4\u65f6\u95f4",
               "IST",
               "\u4f0a\u5c14\u5e93\u8328\u514b\u65f6\u95f4",
               "IT",
            };
        final String[] Mauritius = new String[] {
               "\u6bdb\u91cc\u6c42\u65af\u6807\u51c6\u65f6\u95f4",
               "MST",
               "\u6bdb\u91cc\u6c42\u65af\u590f\u4ee4\u65f6\u95f4",
               "MST",
               "\u6bdb\u91cc\u6c42\u65af\u65f6\u95f4",
               "MT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u5370\u5ea6\u6d0b\u65f6\u95f4",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Choibalsan = new String[] {
               "\u4e54\u5df4\u5c71\u6807\u51c6\u65f6\u95f4",
               "CST",
               "\u4e54\u5df4\u5c71\u590f\u4ee4\u65f6\u95f4",
               "CST",
               "\u4e54\u5df4\u5c71\u65f6\u95f4",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "\u4e1c\u90e8\u6807\u51c6\u65f6\u95f4",
               "EST",
               "\u4e1c\u90e8\u590f\u4ee4\u65f6\u95f4",
               "EDT",
               "\u7f8e\u56fd\u4e1c\u90e8\u65f6\u95f4",
               "ET",
            };
        final String[] Australia_Western = new String[] {
               "\u6fb3\u5927\u5229\u4e9a\u897f\u90e8\u6807\u51c6\u65f6\u95f4",
               "AWST",
               "\u6fb3\u5927\u5229\u4e9a\u897f\u90e8\u590f\u4ee4\u65f6\u95f4",
               "AWDT",
               "\u6fb3\u5927\u5229\u4e9a\u897f\u90e8\u65f6\u95f4",
               "WAT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u6fb3\u5927\u5229\u4e9a\u4e2d\u897f\u90e8\u6807\u51c6\u65f6\u95f4",
               "ACWST",
               "\u6fb3\u5927\u5229\u4e9a\u4e2d\u897f\u90e8\u590f\u4ee4\u65f6\u95f4",
               "ACWDT",
               "\u6fb3\u5927\u5229\u4e9a\u4e2d\u897f\u90e8\u65f6\u95f4",
               "ACWT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u514b\u62c9\u65af\u8bfa\u4e9a\u5c14\u65af\u514b\u6807\u51c6\u65f6\u95f4",
               "KST",
               "\u514b\u62c9\u65af\u8bfa\u4e9a\u5c14\u65af\u514b\u590f\u4ee4\u65f6\u95f4",
               "KST",
               "\u514b\u62c9\u65af\u8bfa\u4e9a\u5c14\u65af\u514b\u65f6\u95f4",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u5370\u5ea6\u5c3c\u897f\u4e9a\u4e1c\u90e8\u65f6\u95f4",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Venezuela = new String[] {
               "\u59d4\u5185\u745e\u62c9\u65f6\u95f4",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Pitcairn = new String[] {
               "\u76ae\u7279\u51ef\u6069\u65f6\u95f4",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Bhutan = new String[] {
               "\u4e0d\u4e39\u6807\u51c6\u65f6\u95f4",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Noronha = new String[] {
               "\u8d39\u5c14\u5357\u591a-\u8fea\u8bfa\u7f57\u5c3c\u4e9a\u5c9b\u6807\u51c6\u65f6\u95f4",
               "FNST",
               "\u8d39\u5c14\u5357\u591a-\u8fea\u8bfa\u7f57\u5c3c\u4e9a\u5c9b\u590f\u4ee4\u65f6\u95f4",
               "FNST",
               "\u8d39\u5c14\u5357\u591a-\u8fea\u8bfa\u7f57\u5c3c\u4e9a\u5c9b\u65f6\u95f4",
               "FNT",
            };
        final String[] Malaysia = new String[] {
               "\u9a6c\u6765\u897f\u4e9a\u6807\u51c6\u65f6\u95f4",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] Novosibirsk = new String[] {
               "\u65b0\u897f\u4f2f\u5229\u4e9a\u6807\u51c6\u65f6\u95f4",
               "NST",
               "\u65b0\u897f\u4f2f\u5229\u4e9a\u590f\u4ee4\u65f6\u95f4",
               "NST",
               "\u65b0\u897f\u4f2f\u5229\u4e9a\u65f6\u95f4",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "\u5c71\u533a\u6807\u51c6\u65f6\u95f4",
               "MST",
               "\u5c71\u533a\u590f\u4ee4\u65f6\u95f4",
               "MDT",
               "\u7f8e\u56fd\u5c71\u533a\u65f6\u95f4",
               "MT",
            };
        final String[] Norfolk = new String[] {
               "\u8bfa\u798f\u514b\u5c9b\u65f6\u95f4",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Niue = new String[] {
               "\u7ebd\u57c3\u65f6\u95f4",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Vostok = new String[] {
               "\u6c83\u65af\u6258\u514b\u65f6\u95f4",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Alaska = new String[] {
               "\u963f\u62c9\u65af\u52a0\u6807\u51c6\u65f6\u95f4",
               "AKST",
               "\u963f\u62c9\u65af\u52a0\u590f\u4ee4\u65f6\u95f4",
               "AKDT",
               "\u963f\u62c9\u65af\u52a0\u65f6\u95f4",
               "AKT",
            };
        final String[] Armenia = new String[] {
               "\u4e9a\u7f8e\u5c3c\u4e9a\u6807\u51c6\u65f6\u95f4",
               "AST",
               "\u4e9a\u7f8e\u5c3c\u4e9a\u590f\u4ee4\u65f6\u95f4",
               "AST",
               "\u4e9a\u7f8e\u5c3c\u4e9a\u65f6\u95f4",
               "AT",
            };
        final String[] Marshall_Islands = new String[] {
               "\u9a6c\u7ecd\u5c14\u7fa4\u5c9b\u65f6\u95f4",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Australia_Central = new String[] {
               "\u6fb3\u5927\u5229\u4e9a\u4e2d\u90e8\u6807\u51c6\u65f6\u95f4",
               "ACST",
               "\u6fb3\u5927\u5229\u4e9a\u4e2d\u90e8\u590f\u4ee4\u65f6\u95f4",
               "ACDT",
               "\u6fb3\u5927\u5229\u4e9a\u4e2d\u90e8\u65f6\u95f4",
               "CAT",
            };
        final String[] Azores = new String[] {
               "\u4e9a\u8ff0\u5c14\u7fa4\u5c9b\u6807\u51c6\u65f6\u95f4",
               "AST",
               "\u4e9a\u8ff0\u5c14\u7fa4\u5c9b\u590f\u4ee4\u65f6\u95f4",
               "AST",
               "\u4e9a\u8ff0\u5c14\u7fa4\u5c9b\u65f6\u95f4",
               "AT",
            };
        final String[] Reunion = new String[] {
               "\u7559\u5c3c\u65fa\u5c9b\u65f6\u95f4",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Indochina = new String[] {
               "\u5370\u5ea6\u652f\u90a3\u65f6\u95f4",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Ecuador = new String[] {
               "\u5384\u74dc\u591a\u5c14\u6807\u51c6\u65f6\u95f4",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Magadan = new String[] {
               "\u9a6c\u52a0\u4e39\u6807\u51c6\u65f6\u95f4",
               "MST",
               "\u9a6c\u52a0\u4e39\u590f\u4ee4\u65f6\u95f4",
               "MST",
               "\u9a6c\u52a0\u4e39\u65f6\u95f4",
               "MT",
            };
        final String[] Chatham = new String[] {
               "\u67e5\u5766\u6807\u51c6\u65f6\u95f4",
               "CST",
               "\u67e5\u5766\u590f\u4ee4\u65f6\u95f4",
               "CDT",
               "\u67e5\u5766\u65f6\u95f4",
               "CT",
            };
        final String[] Davis = new String[] {
               "\u6234\u7ef4\u65af\u65f6\u95f4",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "\u53e4\u5df4\u6807\u51c6\u65f6\u95f4",
               "CST",
               "\u53e4\u5df4\u590f\u4ee4\u65f6\u95f4",
               "CDT",
               "\u53e4\u5df4\u65f6\u95f4",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\u897f\u90e8\u975e\u6d32\u6807\u51c6\u65f6\u95f4",
               "WAST",
               "\u897f\u90e8\u975e\u6d32\u590f\u4ee4\u65f6\u95f4",
               "WAST",
               "\u897f\u90e8\u975e\u6d32\u65f6\u95f4",
               "WAT",
            };
        final String[] Moscow = new String[] {
               "\u83ab\u65af\u79d1\u6807\u51c6\u65f6\u95f4",
               "MST",
               "\u83ab\u65af\u79d1\u590f\u4ee4\u65f6\u95f4",
               "MST",
               "\u83ab\u65af\u79d1\u65f6\u95f4",
               "MT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a\u65f6\u95f4",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u54c8\u8428\u514b\u65af\u5766\u4e1c\u90e8\u65f6\u95f4",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] New_Zealand = new String[] {
               "\u65b0\u897f\u5170\u6807\u51c6\u65f6\u95f4",
               "NZST",
               "\u65b0\u897f\u5170\u590f\u4ee4\u65f6\u95f4",
               "NZDT",
               "\u65b0\u897f\u5170\u65f6\u95f4",
               "NZT",
            };
        final String[] Hong_Kong = new String[] {
               "\u9999\u6e2f\u6807\u51c6\u65f6\u95f4",
               "HKST",
               "\u9999\u6e2f\u590f\u4ee4\u65f6\u95f4",
               "HKST",
               "\u9999\u6e2f\u65f6\u95f4",
               "HKT",
            };
        final String[] Brasilia = new String[] {
               "\u5df4\u897f\u5229\u4e9a\u6807\u51c6\u65f6\u95f4",
               "BST",
               "\u5df4\u897f\u5229\u4e9a\u590f\u4ee4\u65f6\u95f4",
               "BST",
               "\u5df4\u897f\u5229\u4e9a\u65f6\u95f4",
               "BT",
            };
        final String[] Taipei = new String[] {
               "\u53f0\u5317\u6807\u51c6\u65f6\u95f4",
               "TST",
               "\u53f0\u5317\u590f\u4ee4\u65f6\u95f4",
               "TDT",
               "\u53f0\u5317\u65f6\u95f4",
               "TT",
            };
        final String[] Cocos = new String[] {
               "\u79d1\u79d1\u65af\u5c9b\u65f6\u95f4",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Afghanistan = new String[] {
               "\u963f\u5bcc\u6c57\u65f6\u95f4",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u5370\u5ea6\u5c3c\u897f\u4e9a\u897f\u90e8\u65f6\u95f4",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Brunei = new String[] {
               "\u6587\u83b1\u8fbe\u9c81\u8428\u5170\u65f6\u95f4",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u51e4\u51f0\u5c9b\u65f6\u95f4",
               "PIT",
               "Phoenix Islands Summer Time",
               "PIST",
               "Phoenix Islands Time",
               "PIT",
            };
        final String[] Seychelles = new String[] {
               "\u585e\u820c\u5c14\u65f6\u95f4",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Africa_Central = new String[] {
               "\u4e2d\u90e8\u975e\u6d32\u6807\u51c6\u65f6\u95f4",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Easter = new String[] {
               "\u590d\u6d3b\u5c9b\u6807\u51c6\u65f6\u95f4",
               "EIST",
               "\u590d\u6d3b\u5c9b\u590f\u4ee4\u65f6\u95f4",
               "EIST",
               "\u590d\u6d3b\u5c9b\u65f6\u95f4",
               "EIT",
            };
        final String[] South_Georgia = new String[] {
               "\u5357\u4e54\u6cbb\u4e9a\u65f6\u95f4",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u5370\u5ea6\u5c3c\u897f\u4e9a\u4e2d\u90e8\u65f6\u95f4",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Philippines = new String[] {
               "\u83f2\u5f8b\u5bbe\u6807\u51c6\u65f6\u95f4",
               "PST",
               "\u83f2\u5f8b\u5bbe\u590f\u4ee4\u65f6\u95f4",
               "PST",
               "\u83f2\u5f8b\u5bbe\u65f6\u95f4",
               "PT",
            };
        final String[] Georgia = new String[] {
               "\u683c\u9c81\u5409\u4e9a\u6807\u51c6\u65f6\u95f4",
               "GST",
               "\u683c\u9c81\u5409\u4e9a\u590f\u4ee4\u65f6\u95f4",
               "GST",
               "\u683c\u9c81\u5409\u4e9a\u65f6\u95f4",
               "GT",
            };
        final String[] Bolivia = new String[] {
               "\u73bb\u5229\u7ef4\u4e9a\u65f6\u95f4",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Peru = new String[] {
               "\u79d8\u9c81\u65f6\u95f4",
               "PST",
               "\u79d8\u9c81\u590f\u4ee4\u65f6\u95f4",
               "PST",
               "\u79d8\u9c81\u65f6\u95f4",
               "PT",
            };
        final String[] Chamorro = new String[] {
               "\u67e5\u83ab\u7f57\u65f6\u95f4",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Newfoundland = new String[] {
               "\u7ebd\u82ac\u5170\u6807\u51c6\u65f6\u95f4",
               "NST",
               "\u7ebd\u82ac\u5170\u590f\u4ee4\u65f6\u95f4",
               "NDT",
               "\u7ebd\u82ac\u5170\u65f6\u95f4",
               "NT",
            };
        final String[] Line_Islands = new String[] {
               "\u83b1\u6069\u7fa4\u5c9b\u65f6\u95f4",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Cook = new String[] {
               "\u5e93\u514b\u7fa4\u5c9b\u65f6\u95f4",
               "CIST",
               "\u5e93\u514b\u7fa4\u5c9b\u4ef2\u590f\u65f6\u95f4",
               "CIHST",
               "\u5e93\u514b\u7fa4\u5c9b\u65f6\u95f4",
               "CIT",
            };
        final String[] America_Central = new String[] {
               "\u4e2d\u90e8\u6807\u51c6\u65f6\u95f4",
               "CST",
               "\u4e2d\u90e8\u590f\u4ee4\u65f6\u95f4",
               "CDT",
               "\u7f8e\u56fd\u4e2d\u90e8\u65f6\u95f4",
               "CT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u4e1c\u90e8\u975e\u6d32\u6807\u51c6\u65f6\u95f4",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Azerbaijan = new String[] {
               "\u963f\u585e\u62dc\u7586\u6807\u51c6\u65f6\u95f4",
               "AST",
               "\u963f\u585e\u62dc\u7586\u590f\u4ee4\u65f6\u95f4",
               "AST",
               "\u963f\u585e\u62dc\u7586\u65f6\u95f4",
               "AT",
            };
        final String[] Guyana = new String[] {
               "\u76d6\u4e9a\u90a3\u65f6\u95f4",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u53f6\u5361\u6377\u7433\u5821\u6807\u51c6\u65f6\u95f4",
               "YST",
               "\u53f6\u5361\u6377\u7433\u5821\u590f\u4ee4\u65f6\u95f4",
               "YST",
               "\u53f6\u5361\u6377\u7433\u5821\u65f6\u95f4",
               "YT",
            };
        final String[] China = new String[] {
               "\u4e2d\u56fd\u6807\u51c6\u65f6\u95f4",
               "CST",
               "\u4e2d\u56fd\u590f\u4ee4\u65f6\u95f4",
               "CDT",
               "\u4e2d\u56fd\u65f6\u95f4",
               "CT",
            };
        final String[] Samoa = new String[] {
               "\u8428\u6469\u4e9a\u6807\u51c6\u65f6\u95f4",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Tonga = new String[] {
               "\u6c64\u52a0\u6807\u51c6\u65f6\u95f4",
               "TST",
               "\u6c64\u52a0\u590f\u4ee4\u65f6\u95f4",
               "TST",
               "\u6c64\u52a0\u65f6\u95f4",
               "TT",
            };
        final String[] Solomon = new String[] {
               "\u6240\u7f57\u95e8\u7fa4\u5c9b\u65f6\u95f4",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Africa_Southern = new String[] {
               "\u5357\u90e8\u975e\u6d32\u51c6\u65f6\u95f4",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Macquarie = new String[] {
               "\u9ea6\u52a0\u5229\u65f6\u95f4",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] French_Southern = new String[] {
               "\u6cd5\u5c5e\u5357\u90e8\u548c\u5357\u6781\u6d32\u65f6\u95f4",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] Chile = new String[] {
               "\u667a\u5229\u6807\u51c6\u65f6\u95f4",
               "CST",
               "\u667a\u5229\u590f\u4ee4\u65f6\u95f4",
               "CST",
               "\u667a\u5229\u65f6\u95f4",
               "CT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u54c8\u8428\u514b\u65af\u5766\u897f\u90e8\u65f6\u95f4",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Israel = new String[] {
               "\u4ee5\u8272\u5217\u6807\u51c6\u65f6\u95f4",
               "IST",
               "\u4ee5\u8272\u5217\u590f\u4ee4\u65f6\u95f4",
               "IDT",
               "\u4ee5\u8272\u5217\u65f6\u95f4",
               "IT",
            };
        final String[] Tajikistan = new String[] {
               "\u5854\u5409\u514b\u65af\u5766\u6807\u51c6\u65f6\u95f4",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Tahiti = new String[] {
               "\u5927\u6eaa\u5730\u65f6\u95f4",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Mawson = new String[] {
               "\u83ab\u68ee\u65f6\u95f4",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u5f7c\u5f97\u5c9b\u548c\u7c73\u514b\u9686\u5c9b\u6807\u51c6\u65f6\u95f4",
               "PMST",
               "\u5f7c\u5f97\u5c9b\u548c\u7c73\u514b\u9686\u5c9b\u590f\u4ee4\u65f6\u95f4",
               "PMDT",
               "\u5f7c\u5f97\u5c9b\u548c\u7c73\u514b\u9686\u5c9b\u65f6\u95f4",
               "PMT",
            };
        final String[] Fiji = new String[] {
               "\u6590\u6d4e\u6807\u51c6\u65f6\u95f4",
               "FST",
               "\u6590\u6d4e\u590f\u4ee4\u65f6\u95f4",
               "FST",
               "\u6590\u6d4e\u65f6\u95f4",
               "FT",
            };
        final String[] Rothera = new String[] {
               "\u7f57\u745f\u62c9\u65f6\u95f4",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Europe_Central = new String[] {
               "\u4e2d\u6b27\u6807\u51c6\u65f6\u95f4",
               "CEST",
               "\u4e2d\u6b27\u590f\u4ee4\u65f6\u95f4",
               "CEST",
               "\u4e2d\u6b27\u65f6\u95f4",
               "CET",
            };
        final String[] India = new String[] {
               "\u5370\u5ea6\u6807\u51c6\u65f6\u95f4",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] DumontDUrville = new String[] {
               "\u675c\u8499\u7279\u2027\u675c\u7ef4\u5c14\u65f6\u95f4",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Wallis = new String[] {
               "\u74e6\u5229\u65af\u5bcc\u56fe\u7eb3\u65f6\u95f4",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Tuvalu = new String[] {
               "\u5410\u74e6\u9c81\u65f6\u95f4",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Uzbekistan = new String[] {
               "\u4e4c\u5179\u522b\u514b\u65af\u5766\u6807\u51c6\u65f6\u95f4",
               "UST",
               "\u4e4c\u5179\u522b\u514b\u65af\u5766\u590f\u4ee4\u65f6\u95f4",
               "UST",
               "\u4e4c\u5179\u522b\u514b\u65af\u5766\u65f6\u95f4",
               "UT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u4e1c\u6b27\u6807\u51c6\u65f6\u95f4",
               "EEST",
               "\u4e1c\u6b27\u590f\u4ee4\u65f6\u95f4",
               "EEST",
               "\u4e1c\u6b27\u65f6\u95f4",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "\u5927\u897f\u6d0b\u6807\u51c6\u65f6\u95f4",
               "AST",
               "\u5927\u897f\u6d0b\u590f\u4ee4\u65f6\u95f4",
               "ADT",
               "\u5927\u897f\u6d0b\u65f6\u95f4",
               "AT",
            };
        final String[] Uruguay = new String[] {
               "\u4e4c\u62c9\u572d\u65f6\u95f4",
               "UST",
               "\u4e4c\u62c9\u572d\u590f\u4ee4\u65f6\u95f4",
               "UST",
               "Uruguay Time",
               "UT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Douala", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "Asia/Yerevan", Armenia },
            { "Asia/Bangkok", Indochina },
            { "America/Bogota", Colombia },
            { "Asia/Colombo", India },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Blantyre", Africa_Central },
            { "Europe/Volgograd", Volgograd },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Africa/Malabo", Africa_Western },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Katmandu", Nepal },
            { "America/Resolute", America_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "Indian/Kerguelen", French_Southern },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Bahia_Banderas", America_Central },
            { "Pacific/Rarotonga", Cook },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "PST8PDT", America_Pacific },
            { "Antarctica/Casey", Australia_Western },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Bamako", GMT },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Guam", Chamorro },
            { "Africa/Maseru", Africa_Southern },
            { "America/Asuncion", Paraguay },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vientiane", Indochina },
            { "Africa/Niamey", Africa_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Asia/Brunei", Brunei },
            { "Africa/Djibouti", Africa_Eastern },
            { "Asia/Tbilisi", Georgia },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "Indian/Reunion", Reunion },
            { "Asia/Oral", Kazakhstan_Western },
            { "Africa/Lusaka", Africa_Central },
            { "America/Tortola", Atlantic },
            { "Africa/Ouagadougou", GMT },
            { "Asia/Kuching", Malaysia },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Europe/Vilnius", Europe_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "America/Moncton", Atlantic },
            { "America/Maceio", Brasilia },
            { "Africa/Dakar", GMT },
            { "America/Belize", America_Central },
            { "America/Cuiaba", Amazon },
            { "Asia/Tashkent", Uzbekistan },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "Antarctica/Rothera", Rothera },
            { "Indian/Cocos", Cocos },
            { "America/Glace_Bay", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "America/Cambridge_Bay", America_Mountain },
            { "Indian/Mauritius", Mauritius },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Antarctica/Vostok", Vostok },
            { "Pacific/Auckland", New_Zealand },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Africa/Nairobi", Africa_Eastern },
            { "Pacific/Norfolk", Norfolk },
            { "Asia/Irkutsk", Irkutsk },
            { "Pacific/Apia", Samoa },
            { "Pacific/Chatham", Chatham },
            { "America/Caracas", Venezuela },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Maputo", Africa_Central },
            { "America/Metlakatla", America_Pacific },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Asia/Baghdad", Arabian },
            { "Pacific/Saipan", Chamorro },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Singapore", Singapore },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "Pacific/Funafuti", Tuvalu },
            { "Africa/Bissau", GMT },
            { "Asia/Taipei", Taipei },
            { "Pacific/Majuro", Marshall_Islands },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Dili", East_Timor },
            { "America/Indiana/Marengo", America_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Indian/Chagos", Indian_Ocean },
            { "Europe/Luxembourg", Europe_Central },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Phnom_Penh", Indochina },
            { "Australia/Currie", Australia_Eastern },
            { "America/Cancun", America_Central },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Seoul", Korea },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Lima", Peru },
            { "Atlantic/Stanley", Falkland },
            { "Europe/Rome", Europe_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Asia/Anadyr", Magadan },
            { "Europe/Helsinki", Europe_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Hermosillo", America_Mountain },
            { "America/Boise", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/St_Kitts", Atlantic },
            { "Europe/Guernsey", GMT },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Tehran", Iran },
            { "America/Santa_Isabel", America_Pacific },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Araguaina", Brasilia },
            { "America/St_Lucia", Atlantic },
            { "Pacific/Kiritimati", Line_Islands },
            { "Asia/Yakutsk", Yakutsk },
            { "Indian/Mahe", Seychelles },
            { "America/Panama", America_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "Asia/Muscat", Gulf },
            { "Africa/Freetown", GMT },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Paramaribo", Suriname },
            { "Australia/Lindeman", Australia_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "Pacific/Guadalcanal", Solomon },
            { "America/Ciudad_Juarez", America_Mountain },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Pago_Pago", Samoa },
            { "America/Edmonton", America_Mountain },
            { "Antarctica/Syowa", Syowa },
            { "America/Creston", America_Mountain },
            { "Africa/Nouakchott", GMT },
            { "America/Noronha", Noronha },
            { "America/La_Paz", Bolivia },
            { "America/Dominica", Atlantic },
            { "Asia/Saigon", Indochina },
            { "Antarctica/Macquarie", Macquarie },
            { "MST7MDT", America_Mountain },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Luanda", Africa_Western },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Nauru", Nauru },
            { "Africa/Brazzaville", Africa_Western },
            { "America/Guadeloupe", Atlantic },
            { "Africa/Bangui", Africa_Western },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/Eirunepe", Amazon },
            { "Africa/Lubumbashi", Africa_Central },
            { "Antarctica/Palmer", Chile },
            { "Pacific/Galapagos", Galapagos },
            { "America/Monterrey", America_Central },
            { "Europe/London", GMT },
            { "Europe/Samara", Moscow },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "Indian/Christmas", Christmas },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "America/Yakutat", Alaska },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Pacific/Niue", Niue },
            { "Asia/Qatar", Arabian },
            { "Africa/Gaborone", Africa_Central },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Lisbon", Europe_Western },
            { "America/Montevideo", Uruguay },
            { "Europe/Zurich", Europe_Central },
            { "America/Winnipeg", America_Central },
            { "America/Guyana", Guyana },
            { "America/Santarem", Brasilia },
            { "Asia/Macau", China },
            { "Europe/Dublin", GMT },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Monrovia", GMT },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "Europe/Copenhagen", Europe_Central },
            { "Asia/Thimphu", Bhutan },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Chihuahua", America_Central },
            { "America/Yellowknife", America_Mountain },
            { "Africa/Windhoek", Africa_Western },
            { "America/Cayman", America_Eastern },
            { "Antarctica/Davis", Davis },
            { "Europe/Berlin", Europe_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Omsk", Omsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "Asia/Choibalsan", Choibalsan },
            { "Europe/Jersey", GMT },
            { "Europe/Prague", Europe_Central },
            { "Africa/Harare", Africa_Central },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "America/Miquelon", Pierre_Miquelon },
            { "Africa/Sao_Tome", GMT },
            { "Asia/Pyongyang", Korea },
            { "America/Porto_Velho", Amazon },
            { "Pacific/Truk", Truk },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "Europe/Kaliningrad", GMT },
            { "Asia/Kashgar", China },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Port_of_Spain", Atlantic },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "Asia/Karachi", Pakistan },
            { "EST5EDT", America_Eastern },
            { "America/Managua", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Pacific/Wallis", Wallis },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Nome", Alaska },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Rio_Branco", Amazon },
            { "Europe/Podgorica", Europe_Central },
            { "America/Santiago", Chile },
            { "America/Vancouver", America_Pacific },
            { "Asia/Bahrain", Arabian },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Wake", Wake },
            { "Europe/Oslo", Europe_Central },
            { "America/Guatemala", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Asia/Dubai", Gulf },
            { "Asia/Harbin", China },
            { "Africa/Johannesburg", Africa_Southern },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Ojinaga", America_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Barbados", Atlantic },
            { "Asia/Urumqi", China },
            { "Asia/Gaza", Europe_Eastern },
            { "America/Louisville", America_Eastern },
            { "Atlantic/Azores", Azores },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Africa/Accra", GMT },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Juba", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Dushanbe", Tajikistan },
            { "Europe/Isle_of_Man", GMT },
            { "America/Jamaica", America_Eastern },
            { "Indian/Maldives", Maldives },
            { "Africa/Abidjan", GMT },
            { "Pacific/Pitcairn", Pitcairn },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Asia/Magadan", Magadan },
            { "Asia/Kabul", Afghanistan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Mbabane", Africa_Southern },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Banjul", GMT },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "Asia/Rangoon", Myanmar },
            { "America/Jujuy", Argentina },
            { "Asia/Calcutta", India },
            { "America/Buenos_Aires", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Havana", Cuba },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "Pacific/Gambier", Gambier },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "Pacific/Easter", Easter },
            { "America/Menominee", America_Central },
            { "America/Juneau", Alaska },
            { "Pacific/Fakaofo", Tokelau },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "Africa/Conakry", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Godthab", Greenland_Western },
            { "Africa/Libreville", Africa_Western },
            { "Pacific/Kosrae", Kosrae },
            { "America/St_Thomas", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "America/Shiprock", America_Mountain },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Pacific/Tongatapu", Tonga },
            { "Europe/Riga", Europe_Eastern },
            { "America/Guayaquil", Ecuador },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Manila", Philippines },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Kigali", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Antarctica/Mawson", Mawson },
            { "America/Goose_Bay", Atlantic },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "Asia/Chongqing", China },
            { "America/Cayenne", French_Guiana },
            { "Asia/Samarkand", Uzbekistan },
            { "Pacific/Fiji", Fiji },
            { "Australia/Darwin", Australia_Central },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Asia/Riyadh", Arabian },
            { "Asia/Aden", Arabian },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Midway", Samoa },
            { "Pacific/Palau", Palau },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Africa/Lome", GMT },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
