/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.html.ParagraphView;

class LineView
extends ParagraphView {
    int tabBase;

    public LineView(Element element) {
        super(element);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public float getMinimumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    @Override
    public int getResizeWeight(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    @Override
    public float getAlignment(int n) {
        if (n == 0) {
            return 0.0f;
        }
        return super.getAlignment(n);
    }

    @Override
    protected void layout(int n, int n2) {
        super.layout(0x7FFFFFFE, n2);
    }

    @Override
    public float nextTabStop(float f, int n) {
        if (this.getTabSet() == null && StyleConstants.getAlignment(this.getAttributes()) == 0) {
            return this.getPreTab(f, n);
        }
        return super.nextTabStop(f, n);
    }

    protected float getPreTab(float f, int n) {
        Document document = this.getDocument();
        View view = this.getViewAtPosition(n, null);
        if (document instanceof StyledDocument && view != null) {
            Font font = ((StyledDocument)document).getFont(view.getAttributes());
            Container container = this.getContainer();
            FontMetrics fontMetrics = container != null ? container.getFontMetrics(font) : Toolkit.getDefaultToolkit().getFontMetrics(font);
            int n2 = this.getCharactersPerTab() * fontMetrics.charWidth('W');
            int n3 = (int)this.getTabBase();
            return (((int)f - n3) / n2 + 1) * n2 + n3;
        }
        return 10.0f + f;
    }

    protected int getCharactersPerTab() {
        return 8;
    }
}

