/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.internal.platform.CgroupInfo;
import jdk.internal.platform.CgroupMetrics;
import jdk.internal.platform.CgroupSubsystem;
import jdk.internal.platform.CgroupUtil;
import jdk.internal.platform.CgroupV1MetricsImpl;
import jdk.internal.platform.cgroupv1.CgroupV1Subsystem;
import jdk.internal.platform.cgroupv2.CgroupV2Subsystem;

public class CgroupSubsystemFactory {
    private static final String CPU_CTRL = "cpu";
    private static final String CPUACCT_CTRL = "cpuacct";
    private static final String CPUSET_CTRL = "cpuset";
    private static final String BLKIO_CTRL = "blkio";
    private static final String MEMORY_CTRL = "memory";
    private static final Pattern MOUNTINFO_PATTERN = Pattern.compile("^[^\\s]+\\s+[^\\s]+\\s+[^\\s]+\\s+([^\\s]+)\\s+([^\\s]+)\\s+[^-]+-\\s+([^\\s]+)\\s+.*$");

    static CgroupMetrics create() {
        Optional<CgroupTypeResult> optional = null;
        try {
            optional = CgroupSubsystemFactory.determineType("/proc/self/mountinfo", "/proc/cgroups", "/proc/self/cgroup");
        }
        catch (IOException iOException) {
            return null;
        }
        catch (UncheckedIOException uncheckedIOException) {
            return null;
        }
        if (optional.equals(Optional.empty())) {
            return null;
        }
        CgroupTypeResult cgroupTypeResult = optional.get();
        if (!cgroupTypeResult.isAnyControllersEnabled()) {
            return null;
        }
        if (cgroupTypeResult.isAnyCgroupV1Controllers() && cgroupTypeResult.isAnyCgroupV2Controllers()) {
            return null;
        }
        Map<String, CgroupInfo> map = cgroupTypeResult.getInfos();
        if (cgroupTypeResult.isCgroupV2()) {
            CgroupInfo cgroupInfo = map.get(MEMORY_CTRL);
            CgroupSubsystem cgroupSubsystem = CgroupV2Subsystem.getInstance(cgroupInfo);
            return cgroupSubsystem != null ? new CgroupMetrics(cgroupSubsystem) : null;
        }
        CgroupV1Subsystem cgroupV1Subsystem = CgroupV1Subsystem.getInstance(map);
        return cgroupV1Subsystem != null ? new CgroupV1MetricsImpl(cgroupV1Subsystem) : null;
    }

    public static Optional<CgroupTypeResult> determineType(String string2, String string3, String string4) throws IOException {
        Object object222;
        HashMap<String, CgroupInfo> hashMap = new HashMap<String, CgroupInfo>();
        List<String> list = CgroupUtil.readAllLinesPrivileged(Paths.get(string3, new String[0]));
        for (String string5 : list) {
            if (string5.startsWith("#")) continue;
            CgroupInfo cgroupInfo = CgroupInfo.fromCgroupsLine(string5);
            switch (cgroupInfo.getName()) {
                case "cpu": {
                    hashMap.put(CPU_CTRL, cgroupInfo);
                    break;
                }
                case "cpuacct": {
                    hashMap.put(CPUACCT_CTRL, cgroupInfo);
                    break;
                }
                case "cpuset": {
                    hashMap.put(CPUSET_CTRL, cgroupInfo);
                    break;
                }
                case "memory": {
                    hashMap.put(MEMORY_CTRL, cgroupInfo);
                    break;
                }
                case "blkio": {
                    hashMap.put(BLKIO_CTRL, cgroupInfo);
                }
            }
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (Object object222 : hashMap.values()) {
            bl4 = bl4 || ((CgroupInfo)object222).getHierarchyId() != 0;
            bl3 = bl3 || ((CgroupInfo)object222).getHierarchyId() == 0;
            bl = bl && ((CgroupInfo)object222).getHierarchyId() == 0;
            bl2 = bl2 || ((CgroupInfo)object222).isEnabled();
        }
        list = CgroupUtil.readAllLinesPrivileged(Paths.get(string2, new String[0]));
        boolean bl5 = false;
        for (String object3 : list) {
            boolean throwable = CgroupSubsystemFactory.amendCgroupInfos(object3, hashMap, bl);
            bl5 = bl5 || throwable;
        }
        if (!bl5) {
            return Optional.empty();
        }
        object222 = CgroupUtil.readFilePrivileged(Paths.get(string4, new String[0]));
        Throwable throwable = null;
        try {
            Consumer<String[]> throwable2 = stringArray -> CgroupSubsystemFactory.setCgroupV1Path(hashMap, stringArray);
            if (bl) {
                throwable2 = stringArray -> CgroupSubsystemFactory.setCgroupV2Path(hashMap, stringArray);
            }
            object222.map(string -> string.split(":", 3)).forEach(throwable2);
        }
        catch (Throwable throwable3) {
            Throwable throwable4 = throwable3;
            throw throwable3;
        }
        finally {
            if (object222 != null) {
                if (throwable != null) {
                    try {
                        object222.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    object222.close();
                }
            }
        }
        object222 = new CgroupTypeResult(bl, bl2, bl3, bl4, Collections.unmodifiableMap(hashMap));
        return Optional.of(object222);
    }

    private static void setCgroupV2Path(Map<String, CgroupInfo> map, String[] stringArray) {
        String string = stringArray[1];
        if (!string.equals("")) {
            assert (map.get(string) == null);
            return;
        }
        int n = Integer.parseInt(stringArray[0]);
        String string2 = stringArray[2];
        for (CgroupInfo cgroupInfo : map.values()) {
            assert (n == cgroupInfo.getHierarchyId() && n == 0);
            cgroupInfo.setCgroupPath(string2);
        }
    }

    private static void setCgroupV1Path(Map<String, CgroupInfo> map, String[] stringArray) {
        String string = stringArray[1];
        String string2 = stringArray[2];
        if (string != null && string2 != null) {
            String[] stringArray2 = string.split(",");
            int n = stringArray2.length;
            block10: for (int i = 0; i < n; ++i) {
                String string3;
                switch (string3 = stringArray2[i]) {
                    case "memory": 
                    case "cpuset": 
                    case "cpuacct": 
                    case "cpu": 
                    case "blkio": {
                        CgroupInfo cgroupInfo = map.get(string3);
                        cgroupInfo.setCgroupPath(string2);
                        continue block10;
                    }
                }
            }
        }
    }

    private static boolean amendCgroupInfos(String string, Map<String, CgroupInfo> map, boolean bl) {
        Matcher matcher = MOUNTINFO_PATTERN.matcher(string.trim());
        boolean bl2 = false;
        boolean bl3 = false;
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            if (string4.equals("cgroup")) {
                String[] stringArray;
                Path path = Paths.get(string3, new String[0]);
                String[] stringArray2 = stringArray = path.getFileName().toString().split(",");
                int n = stringArray2.length;
                block10: for (int i = 0; i < n; ++i) {
                    String string5;
                    switch (string5 = stringArray2[i]) {
                        case "memory": 
                        case "cpu": 
                        case "cpuacct": 
                        case "cpuset": 
                        case "blkio": {
                            CgroupInfo cgroupInfo = map.get(string5);
                            CgroupSubsystemFactory.setMountPoints(cgroupInfo, string3, string2);
                            bl2 = true;
                            continue block10;
                        }
                    }
                }
            } else if (string4.equals("cgroup2")) {
                if (bl) {
                    for (CgroupInfo cgroupInfo : map.values()) {
                        CgroupSubsystemFactory.setMountPoints(cgroupInfo, string3, string2);
                    }
                }
                bl3 = true;
            }
        }
        return bl2 || bl3;
    }

    private static void setMountPoints(CgroupInfo cgroupInfo, String string, String string2) {
        if (cgroupInfo.getMountPoint() != null) {
            if (!cgroupInfo.getMountPoint().startsWith("/sys/fs/cgroup")) {
                cgroupInfo.setMountPoint(string);
                cgroupInfo.setMountRoot(string2);
            }
        } else {
            cgroupInfo.setMountPoint(string);
            cgroupInfo.setMountRoot(string2);
        }
    }

    public static final class CgroupTypeResult {
        private final boolean isCgroupV2;
        private final boolean anyControllersEnabled;
        private final boolean anyCgroupV2Controllers;
        private final boolean anyCgroupV1Controllers;
        private final Map<String, CgroupInfo> infos;

        private CgroupTypeResult(boolean bl, boolean bl2, boolean bl3, boolean bl4, Map<String, CgroupInfo> map) {
            this.isCgroupV2 = bl;
            this.anyControllersEnabled = bl2;
            this.anyCgroupV1Controllers = bl4;
            this.anyCgroupV2Controllers = bl3;
            this.infos = map;
        }

        public boolean isCgroupV2() {
            return this.isCgroupV2;
        }

        public boolean isAnyControllersEnabled() {
            return this.anyControllersEnabled;
        }

        public boolean isAnyCgroupV2Controllers() {
            return this.anyCgroupV2Controllers;
        }

        public boolean isAnyCgroupV1Controllers() {
            return this.anyCgroupV1Controllers;
        }

        public Map<String, CgroupInfo> getInfos() {
            return this.infos;
        }
    }
}

