/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

public abstract class AtomicReferenceFieldUpdater<T, V> {
    @CallerSensitive
    public static <U, W> AtomicReferenceFieldUpdater<U, W> newUpdater(Class<U> clazz, Class<W> clazz2, String string) {
        return new AtomicReferenceFieldUpdaterImpl<U, W>(clazz, clazz2, string, Reflection.getCallerClass());
    }

    protected AtomicReferenceFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, V var2, V var3);

    public abstract boolean weakCompareAndSet(T var1, V var2, V var3);

    public abstract void set(T var1, V var2);

    public abstract void lazySet(T var1, V var2);

    public abstract V get(T var1);

    public V getAndSet(T t, V v) {
        V v2;
        while (!this.compareAndSet(t, v2 = this.get(t), v)) {
        }
        return v2;
    }

    public final V getAndUpdate(T t, UnaryOperator<V> unaryOperator) {
        Object r;
        V v;
        while (!this.compareAndSet(t, v = this.get(t), r = unaryOperator.apply(v))) {
        }
        return v;
    }

    public final V updateAndGet(T t, UnaryOperator<V> unaryOperator) {
        Object r;
        V v;
        while (!this.compareAndSet(t, v = this.get(t), r = unaryOperator.apply(v))) {
        }
        return (V)r;
    }

    public final V getAndAccumulate(T t, V v, BinaryOperator<V> binaryOperator) {
        Object r;
        V v2;
        while (!this.compareAndSet(t, v2 = this.get(t), r = binaryOperator.apply(v2, v))) {
        }
        return v2;
    }

    public final V accumulateAndGet(T t, V v, BinaryOperator<V> binaryOperator) {
        Object r;
        V v2;
        while (!this.compareAndSet(t, v2 = this.get(t), r = binaryOperator.apply(v2, v))) {
        }
        return (V)r;
    }

    private static final class AtomicReferenceFieldUpdaterImpl<T, V>
    extends AtomicReferenceFieldUpdater<T, V> {
        private static final Unsafe U = Unsafe.getUnsafe();
        private final long offset;
        private final Class<?> cclass;
        private final Class<T> tclass;
        private final Class<V> vclass;

        AtomicReferenceFieldUpdaterImpl(final Class<T> clazz, Class<V> clazz2, final String string, Class<?> clazz3) {
            Class<?> clazz4;
            int n;
            Field field;
            try {
                field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                    @Override
                    public Field run() throws NoSuchFieldException {
                        return clazz.getDeclaredField(string);
                    }
                });
                n = field.getModifiers();
                ReflectUtil.ensureMemberAccess(clazz3, clazz, null, n);
                ClassLoader classLoader = clazz.getClassLoader();
                ClassLoader classLoader2 = clazz3.getClassLoader();
                if (!(classLoader2 == null || classLoader2 == classLoader || classLoader != null && AtomicReferenceFieldUpdaterImpl.isAncestor(classLoader, classLoader2))) {
                    ReflectUtil.checkPackageAccess(clazz);
                }
                clazz4 = field.getType();
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException(privilegedActionException.getException());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            if (clazz2 != clazz4) {
                throw new ClassCastException();
            }
            if (clazz2.isPrimitive()) {
                throw new IllegalArgumentException("Must be reference type");
            }
            if (!Modifier.isVolatile(n)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(n) && clazz.isAssignableFrom(clazz3) && !AtomicReferenceFieldUpdaterImpl.isSamePackage(clazz, clazz3) ? clazz3 : clazz;
            this.tclass = clazz;
            this.vclass = clazz2;
            this.offset = U.objectFieldOffset(field);
        }

        private static boolean isAncestor(ClassLoader classLoader, ClassLoader classLoader2) {
            ClassLoader classLoader3 = classLoader;
            do {
                if (classLoader2 != (classLoader3 = classLoader3.getParent())) continue;
                return true;
            } while (classLoader3 != null);
            return false;
        }

        private static boolean isSamePackage(Class<?> clazz, Class<?> clazz2) {
            return clazz.getClassLoader() == clazz2.getClassLoader() && Objects.equals(AtomicReferenceFieldUpdaterImpl.getPackageName(clazz), AtomicReferenceFieldUpdaterImpl.getPackageName(clazz2));
        }

        private static String getPackageName(Class<?> clazz) {
            String string = clazz.getName();
            int n = string.lastIndexOf(46);
            return n != -1 ? string.substring(0, n) : "";
        }

        private final void accessCheck(T t) {
            if (!this.cclass.isInstance(t)) {
                this.throwAccessCheckException(t);
            }
        }

        private final void throwAccessCheckException(T t) {
            if (this.cclass == this.tclass) {
                throw new ClassCastException();
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + t.getClass().getName()));
        }

        private final void valueCheck(V v) {
            if (v != null && !this.vclass.isInstance(v)) {
                AtomicReferenceFieldUpdaterImpl.throwCCE();
            }
        }

        static void throwCCE() {
            throw new ClassCastException();
        }

        @Override
        public final boolean compareAndSet(T t, V v, V v2) {
            this.accessCheck(t);
            this.valueCheck(v2);
            return U.compareAndSwapObject(t, this.offset, v, v2);
        }

        @Override
        public final boolean weakCompareAndSet(T t, V v, V v2) {
            this.accessCheck(t);
            this.valueCheck(v2);
            return U.compareAndSwapObject(t, this.offset, v, v2);
        }

        @Override
        public final void set(T t, V v) {
            this.accessCheck(t);
            this.valueCheck(v);
            U.putObjectVolatile(t, this.offset, v);
        }

        @Override
        public final void lazySet(T t, V v) {
            this.accessCheck(t);
            this.valueCheck(v);
            U.putOrderedObject(t, this.offset, v);
        }

        @Override
        public final V get(T t) {
            this.accessCheck(t);
            return (V)U.getObjectVolatile(t, this.offset);
        }

        @Override
        public final V getAndSet(T t, V v) {
            this.accessCheck(t);
            this.valueCheck(v);
            return (V)U.getAndSetObject(t, this.offset, v);
        }
    }
}

