/*
 * Decompiled with CFR 0.152.
 */
package com.sun.naming.internal;

import com.sun.naming.internal.NamedWeakReference;
import java.util.List;
import javax.naming.NamingException;

public final class FactoryEnumeration {
    private List<NamedWeakReference<Object>> factories;
    private int posn = 0;
    private ClassLoader loader;

    FactoryEnumeration(List<NamedWeakReference<Object>> list, ClassLoader classLoader) {
        this.factories = list;
        this.loader = classLoader;
    }

    public Object next() throws NamingException {
        List<NamedWeakReference<Object>> list = this.factories;
        synchronized (list) {
            NamedWeakReference<Object> namedWeakReference = this.factories.get(this.posn++);
            Object object = namedWeakReference.get();
            if (object != null && !(object instanceof Class)) {
                return object;
            }
            String string = namedWeakReference.getName();
            try {
                if (object == null) {
                    Class<?> clazz = Class.forName(string, true, this.loader);
                    object = clazz;
                }
                object = ((Class)object).newInstance();
                namedWeakReference = new NamedWeakReference(object, string);
                this.factories.set(this.posn - 1, namedWeakReference);
                return object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                NamingException namingException = new NamingException("No longer able to load " + string);
                namingException.setRootCause(classNotFoundException);
                throw namingException;
            }
            catch (InstantiationException instantiationException) {
                NamingException namingException = new NamingException("Cannot instantiate " + object);
                namingException.setRootCause(instantiationException);
                throw namingException;
            }
            catch (IllegalAccessException illegalAccessException) {
                NamingException namingException = new NamingException("Cannot access " + object);
                namingException.setRootCause(illegalAccessException);
                throw namingException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMore() {
        List<NamedWeakReference<Object>> list = this.factories;
        synchronized (list) {
            return this.posn < this.factories.size();
        }
    }
}

