/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import sun.security.util.Cache;

public abstract class CertStoreHelper {
    private static final int NUM_TYPES = 2;
    private static final Map<String, String> classMap = new HashMap<String, String>(2);
    private static Cache<String, CertStoreHelper> cache;

    public static CertStoreHelper getInstance(final String string) throws NoSuchAlgorithmException {
        CertStoreHelper certStoreHelper = cache.get(string);
        if (certStoreHelper != null) {
            return certStoreHelper;
        }
        final String string2 = classMap.get(string);
        if (string2 == null) {
            throw new NoSuchAlgorithmException(string + " not available");
        }
        try {
            certStoreHelper = AccessController.doPrivileged(new PrivilegedExceptionAction<CertStoreHelper>(){

                @Override
                public CertStoreHelper run() throws ClassNotFoundException {
                    try {
                        Class<?> clazz = Class.forName(string2, true, null);
                        CertStoreHelper certStoreHelper = (CertStoreHelper)clazz.newInstance();
                        cache.put(string, certStoreHelper);
                        return certStoreHelper;
                    }
                    catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                        throw new AssertionError((Object)reflectiveOperationException);
                    }
                }
            });
            return certStoreHelper;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new NoSuchAlgorithmException(string + " not available", privilegedActionException.getException());
        }
    }

    static boolean isCausedByNetworkIssue(String string, CertStoreException certStoreException) {
        switch (string) {
            case "LDAP": 
            case "SSLServer": {
                try {
                    CertStoreHelper certStoreHelper = CertStoreHelper.getInstance(string);
                    return certStoreHelper.isCausedByNetworkIssue(certStoreException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    return false;
                }
            }
            case "URI": {
                Throwable throwable = certStoreException.getCause();
                return throwable != null && throwable instanceof IOException;
            }
        }
        return false;
    }

    public abstract CertStore getCertStore(URI var1) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public abstract X509CertSelector wrap(X509CertSelector var1, X500Principal var2, String var3) throws IOException;

    public abstract X509CRLSelector wrap(X509CRLSelector var1, Collection<X500Principal> var2, String var3) throws IOException;

    public abstract boolean isCausedByNetworkIssue(CertStoreException var1);

    static {
        classMap.put("LDAP", "sun.security.provider.certpath.ldap.LDAPCertStoreHelper");
        classMap.put("SSLServer", "sun.security.provider.certpath.ssl.SSLServerCertStoreHelper");
        cache = Cache.newSoftMemoryCache(2);
    }
}

