/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.ProviderException;
import sun.security.jca.JCAUtil;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.SessionKeyRef;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class NativeKeyHolder {
    private static long nativeKeyWrapperKeyID = 0L;
    private static CK_MECHANISM nativeKeyWrapperMechanism = null;
    private static long nativeKeyWrapperRefCount = 0L;
    private static Session nativeKeyWrapperSession = null;
    private final P11Key p11Key;
    private final byte[] nativeKeyInfo;
    private boolean wrapperKeyUsed;
    private long keyID;
    private SessionKeyRef ref;
    private int refCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createNativeKeyWrapper(Token token) throws PKCS11Exception {
        assert (nativeKeyWrapperKeyID == 0L);
        assert (nativeKeyWrapperRefCount == 0L);
        assert (nativeKeyWrapperSession == null);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = token.getAttributes("generate", 4L, 31L, new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(353L, 32L)});
        Session session = null;
        try {
            session = token.getObjSession();
            nativeKeyWrapperKeyID = token.p11.C_GenerateKey(session.id(), new CK_MECHANISM(4224L), cK_ATTRIBUTEArray);
            nativeKeyWrapperSession = session;
            nativeKeyWrapperSession.addObject();
            byte[] byArray = new byte[16];
            JCAUtil.getSecureRandom().nextBytes(byArray);
            nativeKeyWrapperMechanism = new CK_MECHANISM(4229L, byArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
        }
        finally {
            token.releaseSession(session);
        }
    }

    private static void deleteNativeKeyWrapper() {
        Token token = NativeKeyHolder.nativeKeyWrapperSession.token;
        if (token.isValid()) {
            Session session = null;
            try {
                session = token.getOpSession();
                token.p11.C_DestroyObject(session.id(), nativeKeyWrapperKeyID);
                nativeKeyWrapperSession.removeObject();
            }
            catch (PKCS11Exception pKCS11Exception) {
            }
            finally {
                token.releaseSession(session);
            }
        }
        nativeKeyWrapperKeyID = 0L;
        nativeKeyWrapperMechanism = null;
        nativeKeyWrapperSession = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void decWrapperKeyRef() {
        Class<NativeKeyHolder> clazz = NativeKeyHolder.class;
        synchronized (NativeKeyHolder.class) {
            assert (nativeKeyWrapperKeyID != 0L);
            assert (nativeKeyWrapperRefCount > 0L);
            if (--nativeKeyWrapperRefCount == 0L) {
                NativeKeyHolder.deleteNativeKeyWrapper();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    NativeKeyHolder(P11Key p11Key, long l, Session session, boolean bl, boolean bl2) {
        this.p11Key = p11Key;
        this.keyID = l;
        this.refCount = -1;
        byte[] byArray = null;
        if (bl2) {
            this.ref = null;
        } else {
            Token token = p11Key.token;
            if (bl) {
                try {
                    Object object;
                    if (p11Key.sensitive) {
                        object = NativeKeyHolder.class;
                        // MONITORENTER : sun.security.pkcs11.NativeKeyHolder.class
                        if (nativeKeyWrapperKeyID == 0L) {
                            NativeKeyHolder.createNativeKeyWrapper(token);
                        }
                        if (nativeKeyWrapperKeyID != 0L) {
                            ++nativeKeyWrapperRefCount;
                            this.wrapperKeyUsed = true;
                        }
                        // MONITOREXIT : object
                    }
                    object = null;
                    try {
                        object = token.getOpSession();
                        byArray = p11Key.token.p11.getNativeKeyInfo(((Session)object).id(), l, nativeKeyWrapperKeyID, nativeKeyWrapperMechanism);
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                    }
                    finally {
                        token.releaseSession((Session)object);
                    }
                }
                catch (PKCS11Exception pKCS11Exception) {
                    // empty catch block
                }
            }
            this.ref = new SessionKeyRef(p11Key, l, this.wrapperKeyUsed, session);
        }
        this.nativeKeyInfo = byArray == null || byArray.length == 0 ? null : byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getKeyID() throws ProviderException {
        if (this.nativeKeyInfo == null) return this.keyID;
        byte[] byArray = this.nativeKeyInfo;
        synchronized (this.nativeKeyInfo) {
            if (this.refCount == -1) {
                this.refCount = 0;
            }
            int n = this.refCount++;
            if (this.keyID == 0L) {
                if (n != 0) {
                    throw new RuntimeException("Error: null keyID with non-zero refCount " + n);
                }
                Token token = this.p11Key.token;
                Session session = null;
                try {
                    session = token.getObjSession();
                    this.keyID = token.p11.createNativeKey(session.id(), this.nativeKeyInfo, nativeKeyWrapperKeyID, nativeKeyWrapperMechanism);
                    this.ref.registerNativeKey(this.keyID, session);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    --this.refCount;
                    throw new ProviderException("Error recreating native key", pKCS11Exception);
                }
                finally {
                    token.releaseSession(session);
                }
            } else {
                if (n >= 0) return this.keyID;
                throw new RuntimeException("ERROR: negative refCount");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.keyID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void releaseKeyID() {
        if (this.nativeKeyInfo == null) return;
        byte[] byArray = this.nativeKeyInfo;
        synchronized (this.nativeKeyInfo) {
            int n;
            if (this.refCount == -1) {
                throw new RuntimeException("Error: miss match getKeyID call");
            }
            if ((n = --this.refCount) == 0) {
                if (this.keyID == 0L) {
                    throw new RuntimeException("ERROR: null keyID can't be destroyed");
                }
                this.keyID = 0L;
                this.ref.removeNativeKey();
            } else {
                if (n >= 0) return;
                throw new RuntimeException("wrong refCount value: " + n);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

