/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.c14n.implementations;

import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;

class XmlAttrStack {
    private static final Logger LOG = LoggerFactory.getLogger(XmlAttrStack.class);
    private int currentLevel = 0;
    private int lastlevel = 0;
    private XmlsStackElement cur;
    private List<XmlsStackElement> levels = new ArrayList<XmlsStackElement>();
    private boolean c14n11;

    public XmlAttrStack(boolean bl) {
        this.c14n11 = bl;
    }

    void push(int n) {
        this.currentLevel = n;
        if (this.currentLevel == -1) {
            return;
        }
        this.cur = null;
        while (this.lastlevel >= this.currentLevel) {
            this.levels.remove(this.levels.size() - 1);
            int n2 = this.levels.size();
            if (n2 == 0) {
                this.lastlevel = 0;
                return;
            }
            this.lastlevel = this.levels.get((int)(n2 - 1)).level;
        }
    }

    void addXmlnsAttr(Attr attr) {
        if (this.cur == null) {
            this.cur = new XmlsStackElement();
            this.cur.level = this.currentLevel;
            this.levels.add(this.cur);
            this.lastlevel = this.currentLevel;
        }
        this.cur.nodes.add(attr);
    }

    void getXmlnsAttr(Collection<Attr> collection) {
        HashMap<String, Object> hashMap;
        block17: {
            XmlsStackElement xmlsStackElement;
            int n;
            block16: {
                Object object;
                Iterator<Attr> iterator;
                n = this.levels.size() - 1;
                if (this.cur == null) {
                    this.cur = new XmlsStackElement();
                    this.cur.level = this.currentLevel;
                    this.lastlevel = this.currentLevel;
                    this.levels.add(this.cur);
                }
                boolean bl = false;
                xmlsStackElement = null;
                if (n == -1) {
                    bl = true;
                } else {
                    xmlsStackElement = this.levels.get(n);
                    if (xmlsStackElement.rendered && xmlsStackElement.level + 1 == this.currentLevel) {
                        bl = true;
                    }
                }
                if (bl) {
                    collection.addAll(this.cur.nodes);
                    this.cur.rendered = true;
                    return;
                }
                hashMap = new HashMap<String, Object>();
                if (!this.c14n11) break block16;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                boolean bl2 = true;
                while (n >= 0) {
                    xmlsStackElement = this.levels.get(n);
                    if (xmlsStackElement.rendered) {
                        bl2 = false;
                    }
                    iterator = xmlsStackElement.nodes.iterator();
                    while (iterator.hasNext() && bl2) {
                        object = iterator.next();
                        if (object.getLocalName().equals("base") && !xmlsStackElement.rendered) {
                            arrayList.add(object);
                            continue;
                        }
                        if (hashMap.containsKey(object.getName())) continue;
                        hashMap.put(object.getName(), object);
                    }
                    --n;
                }
                if (arrayList.isEmpty()) break block17;
                iterator = collection.iterator();
                object = null;
                Attr attr = null;
                while (iterator.hasNext()) {
                    Attr attr2 = iterator.next();
                    if (!attr2.getLocalName().equals("base")) continue;
                    object = attr2.getValue();
                    attr = attr2;
                    break;
                }
                for (Attr attr2 : arrayList) {
                    if (object == null) {
                        object = attr2.getValue();
                        attr = attr2;
                        continue;
                    }
                    try {
                        object = XmlAttrStack.joinURI(attr2.getValue(), (String)object);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        LOG.debug(uRISyntaxException.getMessage(), uRISyntaxException);
                    }
                }
                if (object == null || ((String)object).length() == 0) break block17;
                attr.setValue((String)object);
                collection.add(attr);
                break block17;
            }
            while (n >= 0) {
                xmlsStackElement = this.levels.get(n);
                for (Attr attr : xmlsStackElement.nodes) {
                    if (hashMap.containsKey(attr.getName())) continue;
                    hashMap.put(attr.getName(), attr);
                }
                --n;
            }
        }
        this.cur.rendered = true;
        collection.addAll(hashMap.values());
    }

    private static String joinURI(String string, String string2) throws URISyntaxException {
        String string3;
        String string4;
        String string5;
        String string6;
        URI uRI;
        String string7 = null;
        String string8 = null;
        String string9 = "";
        String string10 = null;
        if (string != null) {
            if (string.endsWith("..")) {
                string = string + "/";
            }
            uRI = new URI(string);
            string7 = uRI.getScheme();
            string8 = uRI.getAuthority();
            string9 = uRI.getPath();
            string10 = uRI.getQuery();
        }
        uRI = new URI(string2);
        String string11 = uRI.getScheme();
        String string12 = uRI.getAuthority();
        String string13 = uRI.getPath();
        String string14 = uRI.getQuery();
        if (string11 != null && string11.equals(string7)) {
            string11 = null;
        }
        if (string11 != null) {
            string6 = string11;
            string5 = string12;
            string4 = XmlAttrStack.removeDotSegments(string13);
            string3 = string14;
        } else {
            if (string12 != null) {
                string5 = string12;
                string4 = XmlAttrStack.removeDotSegments(string13);
                string3 = string14;
            } else {
                if (string13.length() == 0) {
                    string4 = string9;
                    string3 = string14 != null ? string14 : string10;
                } else {
                    if (string13.startsWith("/")) {
                        string4 = XmlAttrStack.removeDotSegments(string13);
                    } else {
                        int n;
                        string4 = string8 != null && string9.length() == 0 ? "/" + string13 : ((n = string9.lastIndexOf(47)) == -1 ? string13 : string9.substring(0, n + 1) + string13);
                        string4 = XmlAttrStack.removeDotSegments(string4);
                    }
                    string3 = string14;
                }
                string5 = string8;
            }
            string6 = string7;
        }
        return new URI(string6, string5, string4, string3, null).toString();
    }

    private static String removeDotSegments(String string) {
        LOG.debug("STEP OUTPUT BUFFER\t\tINPUT BUFFER");
        String string2 = string;
        while (string2.indexOf("//") > -1) {
            string2 = string2.replaceAll("//", "/");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string2.charAt(0) == '/') {
            stringBuilder.append("/");
            string2 = string2.substring(1);
        }
        XmlAttrStack.printStep("1 ", stringBuilder.toString(), string2);
        while (string2.length() != 0) {
            String string3;
            int n;
            if (string2.startsWith("./")) {
                string2 = string2.substring(2);
                XmlAttrStack.printStep("2A", stringBuilder.toString(), string2);
                continue;
            }
            if (string2.startsWith("../")) {
                string2 = string2.substring(3);
                if (!stringBuilder.toString().equals("/")) {
                    stringBuilder.append("../");
                }
                XmlAttrStack.printStep("2A", stringBuilder.toString(), string2);
                continue;
            }
            if (string2.startsWith("/./")) {
                string2 = string2.substring(2);
                XmlAttrStack.printStep("2B", stringBuilder.toString(), string2);
                continue;
            }
            if (string2.equals("/.")) {
                string2 = string2.replaceFirst("/.", "/");
                XmlAttrStack.printStep("2B", stringBuilder.toString(), string2);
                continue;
            }
            if (string2.startsWith("/../")) {
                string2 = string2.substring(3);
                if (stringBuilder.length() == 0) {
                    stringBuilder.append("/");
                } else if (stringBuilder.toString().endsWith("../")) {
                    stringBuilder.append("..");
                } else if (stringBuilder.toString().endsWith("..")) {
                    stringBuilder.append("/..");
                } else {
                    n = stringBuilder.lastIndexOf("/");
                    if (n == -1) {
                        stringBuilder = new StringBuilder();
                        if (string2.charAt(0) == '/') {
                            string2 = string2.substring(1);
                        }
                    } else {
                        stringBuilder = stringBuilder.delete(n, stringBuilder.length());
                    }
                }
                XmlAttrStack.printStep("2C", stringBuilder.toString(), string2);
                continue;
            }
            if (string2.equals("/..")) {
                string2 = string2.replaceFirst("/..", "/");
                if (stringBuilder.length() == 0) {
                    stringBuilder.append("/");
                } else if (stringBuilder.toString().endsWith("../")) {
                    stringBuilder.append("..");
                } else if (stringBuilder.toString().endsWith("..")) {
                    stringBuilder.append("/..");
                } else {
                    n = stringBuilder.lastIndexOf("/");
                    if (n == -1) {
                        stringBuilder = new StringBuilder();
                        if (string2.charAt(0) == '/') {
                            string2 = string2.substring(1);
                        }
                    } else {
                        stringBuilder = stringBuilder.delete(n, stringBuilder.length());
                    }
                }
                XmlAttrStack.printStep("2C", stringBuilder.toString(), string2);
                continue;
            }
            if (string2.equals(".")) {
                string2 = "";
                XmlAttrStack.printStep("2D", stringBuilder.toString(), string2);
                continue;
            }
            if (string2.equals("..")) {
                if (!stringBuilder.toString().equals("/")) {
                    stringBuilder.append("..");
                }
                string2 = "";
                XmlAttrStack.printStep("2D", stringBuilder.toString(), string2);
                continue;
            }
            n = -1;
            int n2 = string2.indexOf(47);
            if (n2 == 0) {
                n = string2.indexOf(47, 1);
            } else {
                n = n2;
                n2 = 0;
            }
            if (n == -1) {
                string3 = string2.substring(n2);
                string2 = "";
            } else {
                string3 = string2.substring(n2, n);
                string2 = string2.substring(n);
            }
            stringBuilder.append(string3);
            XmlAttrStack.printStep("2E", stringBuilder.toString(), string2);
        }
        if (stringBuilder.toString().endsWith("..")) {
            stringBuilder.append("/");
            XmlAttrStack.printStep("3 ", stringBuilder.toString(), string2);
        }
        return stringBuilder.toString();
    }

    private static void printStep(String string, String string2, String string3) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" " + string + ":   " + string2);
            if (string2.length() == 0) {
                LOG.debug("\t\t\t\t" + string3);
            } else {
                LOG.debug("\t\t\t" + string3);
            }
        }
    }

    static class XmlsStackElement {
        int level;
        boolean rendered = false;
        List<Attr> nodes = new ArrayList<Attr>();

        XmlsStackElement() {
        }
    }
}

