/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.font.GlyphJustificationInfo;

class TextJustifier {
    private GlyphJustificationInfo[] info;
    private int start;
    private int limit;
    static boolean DEBUG = false;
    public static final int MAX_PRIORITY = 3;

    TextJustifier(GlyphJustificationInfo[] glyphJustificationInfoArray, int n, int n2) {
        this.info = glyphJustificationInfoArray;
        this.start = n;
        this.limit = n2;
        if (DEBUG) {
            System.out.println("start: " + n + ", limit: " + n2);
            for (int i = n; i < n2; ++i) {
                GlyphJustificationInfo glyphJustificationInfo = glyphJustificationInfoArray[i];
                System.out.println("w: " + glyphJustificationInfo.weight + ", gp: " + glyphJustificationInfo.growPriority + ", gll: " + glyphJustificationInfo.growLeftLimit + ", grl: " + glyphJustificationInfo.growRightLimit);
            }
        }
    }

    public float[] justify(float f) {
        int n;
        boolean bl;
        float[] fArray = new float[this.info.length * 2];
        boolean bl2 = bl = f > 0.0f;
        if (DEBUG) {
            System.out.println("delta: " + f);
        }
        int n2 = -1;
        int n3 = 0;
        while (f != 0.0f) {
            int n4;
            int n5 = n = n3 > 3 ? 1 : 0;
            if (n != 0) {
                n3 = n2;
            }
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            for (n4 = this.start; n4 < this.limit; ++n4) {
                GlyphJustificationInfo glyphJustificationInfo = this.info[n4];
                if ((bl ? glyphJustificationInfo.growPriority : glyphJustificationInfo.shrinkPriority) != n3) continue;
                if (n2 == -1) {
                    n2 = n3;
                }
                if (n4 != this.start) {
                    f2 += glyphJustificationInfo.weight;
                    if (bl) {
                        f3 += glyphJustificationInfo.growLeftLimit;
                        if (glyphJustificationInfo.growAbsorb) {
                            f4 += glyphJustificationInfo.weight;
                        }
                    } else {
                        f3 += glyphJustificationInfo.shrinkLeftLimit;
                        if (glyphJustificationInfo.shrinkAbsorb) {
                            f4 += glyphJustificationInfo.weight;
                        }
                    }
                }
                if (n4 + 1 == this.limit) continue;
                f2 += glyphJustificationInfo.weight;
                if (bl) {
                    f3 += glyphJustificationInfo.growRightLimit;
                    if (!glyphJustificationInfo.growAbsorb) continue;
                    f4 += glyphJustificationInfo.weight;
                    continue;
                }
                f3 += glyphJustificationInfo.shrinkRightLimit;
                if (!glyphJustificationInfo.shrinkAbsorb) continue;
                f4 += glyphJustificationInfo.weight;
            }
            if (!bl) {
                f3 = -f3;
            }
            n4 = f2 == 0.0f || n == 0 && f < 0.0f == f < f3 ? 1 : 0;
            boolean bl3 = n4 != 0 && f4 > 0.0f;
            float f5 = f / f2;
            float f6 = 0.0f;
            if (n4 != 0 && f4 > 0.0f) {
                f6 = (f - f3) / f4;
            }
            if (DEBUG) {
                System.out.println("pass: " + n3 + ", d: " + f + ", l: " + f3 + ", w: " + f2 + ", aw: " + f4 + ", wd: " + f5 + ", wa: " + f6 + ", hit: " + (n4 != 0 ? "y" : "n"));
            }
            int n6 = this.start * 2;
            for (int i = this.start; i < this.limit; ++i) {
                GlyphJustificationInfo glyphJustificationInfo = this.info[i];
                if ((bl ? glyphJustificationInfo.growPriority : glyphJustificationInfo.shrinkPriority) == n3) {
                    float f7;
                    if (i != this.start) {
                        if (n4 != 0) {
                            float f8 = f7 = bl ? glyphJustificationInfo.growLeftLimit : -glyphJustificationInfo.shrinkLeftLimit;
                            if (bl3) {
                                f7 += glyphJustificationInfo.weight * f6;
                            }
                        } else {
                            f7 = glyphJustificationInfo.weight * f5;
                        }
                        int n7 = n6;
                        fArray[n7] = fArray[n7] + f7;
                    }
                    ++n6;
                    if (i + 1 != this.limit) {
                        if (n4 != 0) {
                            float f9 = f7 = bl ? glyphJustificationInfo.growRightLimit : -glyphJustificationInfo.shrinkRightLimit;
                            if (bl3) {
                                f7 += glyphJustificationInfo.weight * f6;
                            }
                        } else {
                            f7 = glyphJustificationInfo.weight * f5;
                        }
                        int n8 = n6;
                        fArray[n8] = fArray[n8] + f7;
                    }
                    ++n6;
                    continue;
                }
                n6 += 2;
            }
            f = n == 0 && n4 != 0 && !bl3 ? (f -= f3) : 0.0f;
            ++n3;
        }
        if (DEBUG) {
            float f10 = 0.0f;
            for (n = 0; n < fArray.length; ++n) {
                f10 += fArray[n];
                System.out.print(fArray[n] + ", ");
                if (n % 20 != 9) continue;
                System.out.println();
            }
            System.out.println("\ntotal: " + f10);
            System.out.println();
        }
        return fArray;
    }
}

