/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import jdk.test.lib.Asserts;
import jdk.test.lib.Platform;
import jdk.test.lib.process.OutputAnalyzer;
import jdk.test.lib.process.ProcessTools;
import jtreg.SkippedException;

public class CoreUtils {
    private static final String RUN_SHELL_NO_LIMIT = "ulimit -c unlimited && ";
    private static final String CORE_PATTERN_FILE_NAME = "/proc/sys/kernel/core_pattern";
    private static final String LOCATION_STRING = "location: ";

    private static String getCoreUlimitCommand() {
        String result = null;
        try {
            OutputAnalyzer output = ProcessTools.executeProcess("sh", "-c", "ulimit -c unlimited && ulimit -c");
            result = output.getExitValue() != 0 ? null : (!output.getStdout().contains("unlimited") ? null : RUN_SHELL_NO_LIMIT);
        }
        catch (Throwable t) {
            System.out.println("Exception in getCoreUlimitCommand(): " + t.toString());
            result = null;
        }
        System.out.println("Run test with ulimit -c: " + (result == null ? "default" : "unlimited"));
        return result;
    }

    public static ProcessBuilder addCoreUlimitCommand(ProcessBuilder pb) {
        String cmd = ProcessTools.getCommandLine(pb);
        String ulimitCmd = CoreUtils.getCoreUlimitCommand();
        if (ulimitCmd == null) {
            return pb;
        }
        if (Platform.isWindows()) {
            cmd = cmd.replace('\\', '/').replace(";", "\\;").replace("|", "\\|");
        }
        return new ProcessBuilder("sh", "-c", ulimitCmd + cmd);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCoreFileLocation(String crashOutputString, long pid) throws IOException {
        CoreUtils.unzipCores(new File("."));
        String coreFileLocation = CoreUtils.parseCoreFileLocationFromOutput(crashOutputString);
        if (coreFileLocation != null) {
            long coreFileSize = new File(coreFileLocation).length();
            System.out.println("Found core file " + coreFileLocation + ", size = " + coreFileSize / 1024L / 1024L + "mb");
            Asserts.assertGT(coreFileSize, 0L, "Unexpected core size");
            Path corePath = Paths.get(coreFileLocation, new String[0]);
            File parent = new File(coreFileLocation).getParentFile();
            File cwdParent = new File(".").getAbsoluteFile().getParentFile();
            if (parent == null) return coreFileLocation;
            if (parent.equals(cwdParent)) return coreFileLocation;
            Path coreFileName = corePath.getFileName();
            System.out.println("Moving core file to cwd: " + String.valueOf(coreFileName));
            long startTime = System.currentTimeMillis();
            Files.move(corePath, coreFileName, new CopyOption[0]);
            System.out.println("Core file move took " + (System.currentTimeMillis() - startTime) + "ms");
            return coreFileName.toString();
        }
        System.out.println("Core file not found. Trying to find a reason why...");
        if (Platform.isOSX()) {
            File coresDir = new File("/cores");
            if (!coresDir.isDirectory()) {
                throw new RuntimeException(String.valueOf(coresDir) + " is not a directory");
            }
            if (!coresDir.canWrite()) {
                throw new SkippedException("Directory \"" + String.valueOf(coresDir) + "\" is not writable");
            }
            if (Platform.isHardenedOSX()) {
                if (Platform.getOsVersionMajor() > 10) throw new SkippedException("Cannot produce core file with hardened binary on OSX 10.15 and later");
                if (Platform.getOsVersionMajor() != 10) throw new RuntimeException("Couldn't find core file location in: '" + crashOutputString + "'");
                if (Platform.getOsVersionMinor() < 15) throw new RuntimeException("Couldn't find core file location in: '" + crashOutputString + "'");
                throw new SkippedException("Cannot produce core file with hardened binary on OSX 10.15 and later");
            }
            if (Platform.hasOSXPlistEntries()) throw new RuntimeException("Couldn't find core file location in: '" + crashOutputString + "'");
            throw new SkippedException("Cannot produce core file with binary having no plist entitlement entries");
        }
        if (!Platform.isLinux()) throw new RuntimeException("Couldn't find core file location in: '" + crashOutputString + "'");
        File corePatternFile = new File(CORE_PATTERN_FILE_NAME);
        try (Scanner scanner = new Scanner(corePatternFile);){
            String line;
            do {
                if (!scanner.hasNextLine()) throw new RuntimeException("Couldn't find core file location in: '" + crashOutputString + "'");
                line = scanner.nextLine();
                line = line.trim();
                System.out.println(line);
            } while (!line.startsWith("|"));
            if (line.split(" ", 2)[0].endsWith("systemd-coredump")) {
                System.out.println("Running systemd-coredump: trying coredumpctl command");
                String core = "core";
                try {
                    for (int i = 0; i < 10; ++i) {
                        Thread.sleep(5000L);
                        OutputAnalyzer out = ProcessTools.executeProcess("coredumpctl", "dump", "-1", "-o", core, String.valueOf(pid));
                        if (out.getOutput().contains("output may be incomplete")) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable i) {
                    // empty catch block
                }
                File coreFile = new File(core);
                if (coreFile.exists()) {
                    Asserts.assertGT(coreFile.length(), 0L, "Unexpected core size");
                    System.out.println("coredumpctl succeeded");
                    String string = core;
                    return string;
                }
            }
            System.out.println("\nThis system uses a crash report tool ($cat /proc/sys/kernel/core_pattern).\nCore files might not be generated. Please reset /proc/sys/kernel/core_pattern\nto enable core generation. Skipping this test.");
            throw new SkippedException("This system uses a crash report tool");
        }
    }

    private static String parseCoreFileLocationFromOutput(String crashOutputString) {
        String coreWithoutPid;
        String coreWithPid;
        System.out.println("crashOutputString = [" + crashOutputString + "]");
        Asserts.assertTrue(crashOutputString.contains(LOCATION_STRING), "Output doesn't contain the location of core file.");
        String stringWithLocation = Arrays.stream(crashOutputString.split("\\r?\\n")).filter(str -> str.contains(LOCATION_STRING)).findFirst().get();
        stringWithLocation = stringWithLocation.substring(stringWithLocation.indexOf(LOCATION_STRING) + LOCATION_STRING.length());
        System.out.println("getCoreFileLocation found stringWithLocation = " + stringWithLocation);
        if (stringWithLocation.contains("or ") && !Platform.isWindows()) {
            Matcher m = Pattern.compile("or.* ([^ ]+[^\\)])\\)?").matcher(stringWithLocation);
            if (!m.find()) {
                throw new RuntimeException("Couldn't find path to core inside location string");
            }
            coreWithPid = m.group(1);
        } else {
            coreWithPid = stringWithLocation.trim();
        }
        if (new File(coreWithPid).exists()) {
            return coreWithPid;
        }
        String justCore = Paths.get("core", new String[0]).toString();
        if (new File(justCore).exists()) {
            return justCore;
        }
        Path coreWithPidPath = Paths.get(coreWithPid, new String[0]);
        String justFile = coreWithPidPath.getFileName().toString();
        if (new File(justFile).exists()) {
            return justFile;
        }
        Path parent = coreWithPidPath.getParent();
        if (parent != null && new File(coreWithoutPid = parent.resolve("core").toString()).exists()) {
            return coreWithoutPid;
        }
        return null;
    }

    private static void unzipCores(File dir) {
        File[] gzCores;
        for (File gzCore : gzCores = dir.listFiles((directory, name) -> name.matches("core(\\.\\d+)?\\.gz"))) {
            String coreFileName = gzCore.getName().replace(".gz", "");
            System.out.println("Unzipping core into " + coreFileName);
            try (GZIPInputStream gzis = new GZIPInputStream(Files.newInputStream(gzCore.toPath(), new OpenOption[0]));){
                Files.copy(gzis, Paths.get(coreFileName, new String[0]), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new SkippedException("Not able to unzip file: " + gzCore.getAbsolutePath(), e);
            }
        }
    }

    public static String getAlwaysPretouchArg(boolean withCore) {
        if (withCore && Platform.isOSX() && Platform.isAArch64()) {
            return "-XX:+AlwaysPreTouch";
        }
        return "-XX:-AlwaysPreTouch";
    }
}

