/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jdk.test.lib.compiler.CompilerUtils;

public class ClassTransformer {
    private final List<String> lines;
    private String fileName;
    private String workDir = "ver{0}";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private ClassTransformer(List<String> lines) {
        this.lines = lines;
    }

    public ClassTransformer setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public ClassTransformer setWorkDir(String dir) {
        this.workDir = dir;
        return this;
    }

    public static ClassTransformer fromString(String content) {
        return new ClassTransformer(Arrays.asList(content.split("\\R")));
    }

    public static ClassTransformer fromFile(Path filePath) {
        try {
            return new ClassTransformer(Files.readAllLines(filePath)).setFileName(filePath.getFileName().toString());
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read " + String.valueOf(filePath), e);
        }
    }

    public static ClassTransformer fromFile(String filePath) {
        return ClassTransformer.fromFile(Paths.get(filePath, new String[0]));
    }

    public static ClassTransformer fromTestSource(String fileName) {
        return ClassTransformer.fromFile(Paths.get(System.getProperty("test.src"), new String[0]).resolve(fileName));
    }

    public String transform(int id, String className, String ... compilerOptions) {
        Path subdir = Paths.get(".", new String[0]).resolve(MessageFormat.format(this.workDir, id));
        Path transformedSrc = subdir.resolve(this.fileName);
        try {
            Files.createDirectories(subdir, new FileAttribute[0]);
            Files.write(transformedSrc, this.transform(id).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to write transformed " + String.valueOf(transformedSrc), e);
        }
        try {
            LinkedList<String> args = new LinkedList<String>(Arrays.asList(compilerOptions));
            args.add("-cp");
            args.add(System.getProperty("java.class.path"));
            CompilerUtils.compile(subdir, subdir, false, args.toArray(new String[args.size()]));
        }
        catch (IOException e) {
            throw new RuntimeException("failed to compile " + String.valueOf(transformedSrc), e);
        }
        return subdir.resolve(className + ".class").toString();
    }

    public String transform(int id) {
        Pattern delete = Pattern.compile("@" + id + " *delete");
        Pattern uncomment = Pattern.compile("// *@" + id + " *uncomment (.*)");
        Pattern commentout = Pattern.compile(".* @" + id + " *commentout");
        Pattern newline = Pattern.compile("(.*) @" + id + " *newline (.*)");
        Pattern replace = Pattern.compile("@" + id + " *replace (.*)");
        return this.lines.stream().filter(s -> !delete.matcher((CharSequence)s).find()).map(s -> {
            Matcher m = uncomment.matcher((CharSequence)s);
            return m.find() ? m.group(1) : s;
        }).map(s -> {
            Matcher m = commentout.matcher((CharSequence)s);
            return m.find() ? "//" + s : s;
        }).map(s -> {
            Matcher m = newline.matcher((CharSequence)s);
            return m.find() ? m.group(1) + LINE_SEPARATOR + m.group(2) : s;
        }).map(s -> {
            Matcher m = replace.matcher((CharSequence)s);
            return m.find() ? m.group(1) : s;
        }).collect(Collectors.joining(LINE_SEPARATOR));
    }
}

