/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;

public class Compiler {
    private final Map<String, String> input;
    private List<String> options;

    public Compiler(Map<String, String> input) {
        this.input = input;
    }

    public Compiler setRelease(int release) {
        String target = String.valueOf(release);
        this.options = Arrays.asList("-source", target, "-target", target, "-classpath", "");
        return this;
    }

    public Map<String, byte[]> compile() {
        CustomFileManager jfm;
        List<SourceFileObject> cunits = this.createCompilationUnits();
        Map<String, ClassFileObject> cfos = this.createClassFileObjects();
        JavaCompiler jc = ToolProvider.getSystemJavaCompiler();
        if (!jc.getTask(null, jfm = new CustomFileManager(jc.getStandardFileManager(null, null, null), cfos), null, this.options, null, cunits).call().booleanValue()) {
            throw new RuntimeException("Compilation failed");
        }
        return this.createOutput(cfos);
    }

    private List<SourceFileObject> createCompilationUnits() {
        return this.input.entrySet().stream().map(e -> new SourceFileObject((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    private Map<String, ClassFileObject> createClassFileObjects() {
        return this.input.keySet().stream().collect(Collectors.toMap(k -> k, k -> new ClassFileObject((String)k)));
    }

    private Map<String, byte[]> createOutput(Map<String, ClassFileObject> cfos) {
        return cfos.keySet().stream().collect(Collectors.toMap(k -> k, k -> ((ClassFileObject)cfos.get(k)).getBytes()));
    }

    private static class CustomFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        private final Map<String, ClassFileObject> cfos;

        CustomFileManager(JavaFileManager jfm, Map<String, ClassFileObject> cfos) {
            super(jfm);
            this.cfos = cfos;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location loc, String name, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            ClassFileObject cfo = this.cfos.get(name);
            return cfo;
        }
    }

    private static class ClassFileObject
    extends SimpleJavaFileObject {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        ClassFileObject(String className) {
            super(URI.create(className), JavaFileObject.Kind.CLASS);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.baos;
        }

        public byte[] getBytes() {
            return this.baos.toByteArray();
        }
    }

    private static class SourceFileObject
    extends SimpleJavaFileObject {
        private final String source;

        SourceFileObject(String name, String source) {
            super(URI.create("string:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.source = source;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.source;
        }
    }
}

