/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.thread;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class VThreadScheduler {
    private VThreadScheduler() {
    }

    public static Executor scheduler(Thread thread) {
        if (!thread.isVirtual()) {
            throw new IllegalArgumentException("Not a virtual thread");
        }
        try {
            Field scheduler = Class.forName("java.lang.VirtualThread").getDeclaredField("scheduler");
            scheduler.setAccessible(true);
            return (Executor)scheduler.get(thread);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean supportsCustomScheduler() {
        try (ExecutorService pool = Executors.newCachedThreadPool();){
            VThreadScheduler.virtualThreadBuilder(pool);
            boolean bl = true;
            return bl;
        }
    }

    public static Thread.Builder.OfVirtual virtualThreadBuilder(Executor scheduler) {
        try {
            Class<?> clazz = Class.forName("java.lang.ThreadBuilders$VirtualThreadBuilder");
            Constructor<?> ctor = clazz.getDeclaredConstructor(Executor.class);
            ctor.setAccessible(true);
            return (Thread.Builder.OfVirtual)ctor.newInstance(scheduler);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)cause;
                throw re;
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ThreadFactory virtualThreadFactory(Executor scheduler) {
        return VThreadScheduler.virtualThreadBuilder(scheduler).factory();
    }
}

